/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.ingredient.recipe.handler;

import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.cyclops.commoncapabilities.api.ingredient.IMixedIngredients;
import org.cyclops.commoncapabilities.api.ingredient.IPrototypedIngredient;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.commoncapabilities.api.ingredient.MixedIngredients;
import org.cyclops.commoncapabilities.api.ingredient.PrototypedIngredient;
import org.cyclops.cyclopscore.ingredient.recipe.IRecipeInputDefinitionHandler;
import org.cyclops.cyclopscore.ingredient.recipe.IRecipeOutputDefinitionHandler;
import org.cyclops.cyclopscore.recipe.custom.component.FluidStackRecipeComponent;

public class FluidStackRecipeComponentHandler
implements IRecipeInputDefinitionHandler<FluidStackRecipeComponent>,
IRecipeOutputDefinitionHandler<FluidStackRecipeComponent> {
    @Override
    public IMixedIngredients toRecipeDefinitionOutput(FluidStackRecipeComponent recipeOutput) {
        IdentityHashMap outputs = Maps.newIdentityHashMap();
        if (recipeOutput.getFluidStack() != null) {
            outputs.put(IngredientComponent.FLUIDSTACK, Collections.singletonList(recipeOutput.getFluidStack()));
        }
        return new MixedIngredients((Map)outputs);
    }

    @Override
    public Map<IngredientComponent<?, ?>, List<List<IPrototypedIngredient<?, ?>>>> toRecipeDefinitionInput(FluidStackRecipeComponent recipeInput) {
        IdentityHashMap inputs = Maps.newIdentityHashMap();
        if (recipeInput.getFluidStack() != null) {
            inputs.put(IngredientComponent.FLUIDSTACK, Collections.singletonList(Collections.singletonList(new PrototypedIngredient(IngredientComponent.FLUIDSTACK, (Object)recipeInput.getFluidStack(), (Object)1))));
        }
        return inputs;
    }
}

