/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.wizardry.common.world.trickery;

import com.teamwizardry.wizardry.api.util.RandUtil;
import com.teamwizardry.wizardry.common.entity.EntityFairy;
import com.teamwizardry.wizardry.init.ModBlocks;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.IChunkGenerator;

public class ChunkGeneratorTorikki
implements IChunkGenerator {
    private World world;

    public ChunkGeneratorTorikki(World worldIn) {
        this.world = worldIn;
    }

    private void generateCloud(Set<BlockPos> poses, BlockPos center, float weight, Random seed) {
        if (poses.contains(center)) {
            return;
        }
        poses.add(center);
        if (weight > 1.0f) {
            ArrayList directions = new ArrayList();
            HashSet horizontals = new HashSet();
            Collections.addAll(directions, EnumFacing.field_82609_l);
            Collections.addAll(horizontals, EnumFacing.field_176754_o);
            while (!directions.isEmpty()) {
                int i = seed.nextInt(directions.size());
                EnumFacing dir = horizontals.contains(directions.get(i)) ? (RandUtil.nextBoolean() ? (EnumFacing)directions.get(i) : (EnumFacing)directions.remove(i)) : (EnumFacing)directions.remove(i);
                this.generateCloud(poses, center.func_177972_a(dir), weight - seed.nextFloat() - 1.0f, seed);
            }
        }
    }

    private boolean isChunkCenter(int chunkX, int chunkZ) {
        long s2 = ((long)chunkX + this.world.func_72905_C() + 337L) * 947L + (long)chunkZ * 719L;
        Random rand = new Random(s2);
        rand.nextFloat();
        return rand.nextFloat() < 0.3f;
    }

    private Random getRandomForChunk(int chunkX, int chunkZ) {
        long s2 = ((long)chunkX + this.world.func_72905_C() + 13L) * 314L + (long)chunkZ * 17L;
        Random rand = new Random(s2);
        rand.nextFloat();
        return rand;
    }

    private void generate(int chunkX, int chunkZ, ChunkPrimer primer) {
        for (int cx = -1; cx <= 1; ++cx) {
            for (int cz = -1; cz <= 1; ++cz) {
                if (!this.isChunkCenter(chunkX + cx, chunkZ + cz)) continue;
                Random rand = this.getRandomForChunk(chunkX + cx, chunkZ + cz);
                HashSet<BlockPos> poses = new HashSet<BlockPos>();
                this.generateCloud(poses, new BlockPos(8 + cx * 16, 50, 8 + cz * 16), 20.0f, rand);
                for (BlockPos pos : poses) {
                    if (pos.func_177958_n() < 0 || pos.func_177958_n() > 15 || pos.func_177952_p() < 0 || pos.func_177952_p() > 15) continue;
                    IBlockState block = ModBlocks.CLOUD.func_176223_P();
                    primer.func_177855_a(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), block);
                }
            }
        }
    }

    @Nonnull
    public Chunk func_185932_a(int x, int z) {
        ChunkPrimer chunkprimer = new ChunkPrimer();
        this.generate(x, z, chunkprimer);
        Chunk chunk = new Chunk(this.world, chunkprimer, x, z);
        byte[] biomeArray = chunk.func_76605_m();
        for (int i = 0; i < biomeArray.length; ++i) {
            biomeArray[i] = 42;
        }
        chunk.func_76603_b();
        return chunk;
    }

    public void func_185931_b(int x, int z) {
        if (x / 16 == 0 && z / 16 == 0) {
            for (int i = -3; i < 3; ++i) {
                for (int j = -3; j < 3; ++j) {
                    this.world.func_175656_a(new BlockPos(i, 50, j), Blocks.field_150343_Z.func_176223_P());
                }
            }
        }
    }

    public boolean func_185933_a(@Nonnull Chunk chunkIn, int x, int z) {
        return false;
    }

    @Nonnull
    public List<Biome.SpawnListEntry> func_177458_a(@Nonnull EnumCreatureType creatureType, @Nonnull BlockPos pos) {
        ArrayList<Biome.SpawnListEntry> list = new ArrayList<Biome.SpawnListEntry>();
        list.add(new Biome.SpawnListEntry(EntityFairy.class, 1, 1, 3));
        return list;
    }

    @Nullable
    public BlockPos func_180513_a(@Nonnull World worldIn, @Nonnull String structureName, @Nonnull BlockPos position, boolean findUnexplored) {
        return null;
    }

    public void func_180514_a(@Nonnull Chunk chunkIn, int x, int z) {
    }

    public boolean func_193414_a(@Nonnull World worldIn, @Nonnull String structureName, @Nonnull BlockPos pos) {
        return false;
    }
}

