/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.wizardry.common.module.effects;

import com.teamwizardry.wizardry.api.spell.SpellData;
import com.teamwizardry.wizardry.api.spell.SpellRing;
import com.teamwizardry.wizardry.api.spell.annotation.RegisterModule;
import com.teamwizardry.wizardry.api.spell.attribute.AttributeRegistry;
import com.teamwizardry.wizardry.api.spell.module.IModuleEffect;
import com.teamwizardry.wizardry.api.spell.module.ModuleInstanceEffect;
import com.teamwizardry.wizardry.client.fx.LibParticles;
import com.teamwizardry.wizardry.init.ModPotions;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@RegisterModule(ID="effect_vanish")
public class ModuleEffectVanish
implements IModuleEffect {
    @Override
    public String[] compatibleModifiers() {
        return new String[]{"modifier_extend_time"};
    }

    @Override
    public boolean run(ModuleInstanceEffect instance, @Nonnull SpellData spell, @Nonnull SpellRing spellRing) {
        Entity targetEntity = spell.getVictim();
        double duration = spellRing.getAttributeValue(AttributeRegistry.DURATION, spell) * 20.0;
        if (targetEntity instanceof EntityLivingBase) {
            if (!spellRing.taxCaster(spell, true)) {
                return false;
            }
            ((EntityLivingBase)targetEntity).func_70690_d(new PotionEffect((Potion)ModPotions.VANISH, (int)duration, 0, true, false));
        }
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderSpell(ModuleInstanceEffect instance, @Nonnull SpellData spell, @Nonnull SpellRing spellRing) {
        World world = spell.world;
        Vec3d position = spell.getTarget();
        if (position == null) {
            return;
        }
        LibParticles.EFFECT_REGENERATE(world, position, instance.getPrimaryColor());
    }
}

