/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.wizardry.common.item.pearlbelt;

import com.teamwizardry.librarianlib.features.helpers.ItemNBTHelper;
import com.teamwizardry.librarianlib.features.network.PacketHandler;
import com.teamwizardry.wizardry.api.ConfigValues;
import com.teamwizardry.wizardry.api.item.INacreProduct;
import com.teamwizardry.wizardry.api.item.wheels.IPearlWheelHolder;
import com.teamwizardry.wizardry.common.network.belt.PacketPearlHolderCondenseInventory;
import com.teamwizardry.wizardry.init.ModItems;
import com.teamwizardry.wizardry.init.ModSounds;
import java.awt.Color;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import kotlin.jvm.functions.Function2;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.ItemStackHandler;

public interface IPearlBelt
extends IPearlWheelHolder,
INacreProduct.INacreDecayProduct {
    default public void addBeltColorProperty(Item item) {
        item.func_185043_a(new ResourceLocation("slot"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(@Nonnull ItemStack stack, @Nullable World worldIn, @Nullable EntityLivingBase entityIn) {
                ItemStackHandler handler = IPearlBelt.this.getPearls(stack);
                if (handler == null) {
                    return 0.0f;
                }
                int total = 0;
                for (int i = 0; i < handler.getSlots(); ++i) {
                    ItemStack pearl = handler.getStackInSlot(i);
                    if (pearl.func_190926_b()) continue;
                    ++total;
                }
                return MathHelper.func_76125_a((int)total, (int)0, (int)6);
            }
        });
    }

    default public void onRightClick(World world, EntityPlayer player, EnumHand hand) {
        ItemStack belt = player.func_184586_b(hand);
        if (!this.shouldUse(belt)) {
            return;
        }
        boolean changed = false;
        for (ItemStack stack : player.field_71071_by.field_70462_a) {
            if (stack.func_77973_b() != ModItems.PEARL_NACRE || !ItemNBTHelper.getBoolean((ItemStack)stack, (String)"infused", (boolean)false) || !this.addPearl(belt, stack.func_77946_l())) continue;
            stack.func_190918_g(1);
            changed = true;
        }
        if (changed) {
            ItemNBTHelper.setInt((ItemStack)belt, (String)"scroll_slot", (int)-1);
            if (player instanceof EntityPlayerMP) {
                PacketHandler.NETWORK.sendTo((IMessage)new PacketPearlHolderCondenseInventory(player.field_71071_by.func_184429_b(belt)), (EntityPlayerMP)player);
            }
            player.func_184185_a((SoundEvent)ModSounds.BELL_TING, 1.0f, 1.0f);
        }
    }

    default public void initBelt(ItemStack stack, @Nullable NBTTagCompound nbt) {
        if (nbt == null) {
            nbt = new NBTTagCompound();
        }
        nbt.func_74782_a("inv", (NBTBase)new ItemStackHandler(ConfigValues.pearlBeltInvSize).serializeNBT());
        stack.func_77982_d(nbt);
    }

    default public ItemStackHandler getBeltPearls(ItemStack stack) {
        NBTTagCompound tag = stack.func_77978_p();
        ItemStackHandler handler = null;
        if (tag == null || !tag.func_74764_b("inv")) {
            tag = new NBTTagCompound();
            handler = new ItemStackHandler(ConfigValues.pearlBeltInvSize);
            tag.func_74782_a("inv", (NBTBase)new ItemStackHandler(ConfigValues.pearlBeltInvSize).serializeNBT());
            stack.func_77982_d(handler.serializeNBT());
        }
        if (tag.func_74764_b("inv")) {
            NBTTagCompound inv = tag.func_74775_l("inv");
            handler = new ItemStackHandler();
            handler.deserializeNBT(inv);
        }
        return handler;
    }

    default public Function2<ItemStack, Integer, Integer> getBeltColorFunction() {
        return (pearlBelt, tintIndex) -> {
            if (tintIndex == 0) {
                return 0xFFFFFF;
            }
            ItemStackHandler handler = this.getPearls((ItemStack)pearlBelt);
            if (handler == null) {
                return 0;
            }
            ItemStack stack = handler.getStackInSlot(tintIndex - 1);
            if (stack.func_190926_b()) {
                return 0xFFFFFF;
            }
            if (!stack.func_77942_o()) {
                return Color.HSBtoRGB(MathHelper.func_76126_a((float)((float)Minecraft.func_71410_x().field_71441_e.func_82737_E() / 140.0f)), 0.75f, 1.0f);
            }
            long lastCast = ItemNBTHelper.getLong((ItemStack)stack, (String)"last_cast", (long)-1L);
            int decayCooldown = ItemNBTHelper.getInt((ItemStack)stack, (String)"last_cooldown", (int)-1);
            long tick = Minecraft.func_71410_x().field_71441_e.func_82737_E();
            long timeSinceCooldown = tick - lastCast;
            float decayStage = decayCooldown > 0 ? (float)timeSinceCooldown / (float)decayCooldown : 1.0f;
            float rand = ItemNBTHelper.getFloat((ItemStack)stack, (String)"rand", (float)-1.0f);
            float hue = rand < 0.0f ? (float)tick / 140.0f % 140.0f : rand;
            float pow = Math.min(1.0f, Math.max(0.0f, this.getQuality(stack)));
            double decaySaturation = lastCast == -1L || decayCooldown <= 0 || decayStage >= 1.0f ? 1.0 : ((double)decayStage < 0.16666666666666666 ? Math.pow(Math.E, -15.0f * decayStage) : Math.pow(Math.E, 3.0f * decayStage - 3.0f));
            float saturation = 1.1864825f * (1.0f - (float)Math.pow(Math.E, -pow)) * (float)decaySaturation;
            return Color.HSBtoRGB(hue, saturation, 1.0f);
        };
    }
}

