/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.wizardry.common.core;

import com.teamwizardry.wizardry.Wizardry;
import com.teamwizardry.wizardry.api.ConfigValues;
import com.teamwizardry.wizardry.api.block.FluidTracker;
import com.teamwizardry.wizardry.api.events.SpellCastEvent;
import com.teamwizardry.wizardry.api.spell.IContinuousModule;
import com.teamwizardry.wizardry.api.spell.SpellData;
import com.teamwizardry.wizardry.api.spell.SpellRing;
import com.teamwizardry.wizardry.api.spell.SpellUtils;
import com.teamwizardry.wizardry.api.util.PosUtils;
import com.teamwizardry.wizardry.api.util.RandUtil;
import com.teamwizardry.wizardry.api.util.TeleportUtil;
import com.teamwizardry.wizardry.common.entity.EntityFairy;
import com.teamwizardry.wizardry.crafting.burnable.EntityBurnableItem;
import com.teamwizardry.wizardry.init.ModPotions;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerFlyableFallEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EventHandler {
    private final HashSet<UUID> fallResetter = new HashSet();

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onTextureStitchEvent(TextureStitchEvent event) {
        event.getMap().func_174942_a(new ResourceLocation("wizardry", "particles/smoke"));
        event.getMap().func_174942_a(new ResourceLocation("wizardry", "particles/sparkle_blurred"));
        event.getMap().func_174942_a(new ResourceLocation("wizardry", "particles/diamond"));
    }

    @SubscribeEvent
    public void redstoneHandler(EntityJoinWorldEvent event) {
        EntityItem item;
        if (event.getWorld().field_72995_K) {
            return;
        }
        if (event.getEntity() instanceof EntityItem && !(event.getEntity() instanceof EntityBurnableItem) && EntityBurnableItem.isBurnable((item = (EntityItem)event.getEntity()).func_92059_d())) {
            EntityBurnableItem newItem = new EntityBurnableItem(event.getWorld(), item.field_70165_t, item.field_70163_u, item.field_70161_v, item.func_92059_d());
            newItem.field_70159_w = item.field_70159_w;
            newItem.field_70181_x = item.field_70181_x;
            newItem.field_70179_y = item.field_70179_y;
            newItem.func_174869_p();
            item.func_70106_y();
            event.getWorld().func_72838_d((Entity)newItem);
        }
    }

    @SubscribeEvent
    public void tickEvent(TickEvent.WorldTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            FluidTracker.INSTANCE.tick(event.world);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void underworldTeleport(LivingHurtEvent event) {
        if (!(event.getEntity() instanceof EntityPlayer)) {
            return;
        }
        if (this.fallResetter.contains(event.getEntity().func_110124_au())) {
            if (event.getEntity().field_70163_u < 0.0 || event.getEntity().field_70163_u > (double)event.getEntity().field_70170_p.func_72800_K()) {
                event.setCanceled(true);
                return;
            }
            if (event.getSource() == DamageSource.field_76379_h) {
                this.fallResetter.remove(event.getEntity().func_110124_au());
                event.setCanceled(true);
                return;
            }
        }
        if (event.getEntity().func_130014_f_().field_73011_w.getDimension() == Wizardry.underWorld.func_186068_a()) {
            if (event.getEntity().field_70163_u < 0.0) {
                EntityPlayer player = (EntityPlayer)event.getEntityLiving();
                player.field_70128_L = false;
                event.setAmount(0.0f);
                BlockPos spawn = player.isSpawnForced(0) ? player.getBedLocation(0) : player.field_70170_p.func_175694_M().func_177963_a(player.field_70170_p.field_73012_v.nextGaussian() * 16.0, 0.0, player.field_70170_p.field_73012_v.nextGaussian() * 16.0);
                BlockPos teleportTo = spawn.func_177982_a(0, 300 - spawn.func_177956_o(), 0);
                this.fallResetter.add(event.getEntity().func_110124_au());
                TeleportUtil.teleportToDimension((EntityPlayer)event.getEntity(), 0, teleportTo.func_177958_n(), teleportTo.func_177956_o(), teleportTo.func_177952_p());
                event.setCanceled(true);
            }
        } else if (event.getEntity().func_130014_f_().field_73011_w.getDimension() == 0 && event.getSource() == EntityDamageSource.field_76379_h && event.getEntity().field_70143_R >= (float)ConfigValues.underworldFallDistance) {
            BlockPos location = event.getEntity().func_180425_c();
            BlockPos bedrock = PosUtils.checkNeighborBlocksThoroughly(event.getEntity().func_130014_f_(), location, Blocks.field_150357_h);
            if (bedrock != null) {
                this.fallResetter.add(event.getEntity().func_110124_au());
                TeleportUtil.teleportToDimension((EntityPlayer)event.getEntity(), Wizardry.underWorld.func_186068_a(), 0.0, 300.0, 0.0);
                ((EntityPlayer)event.getEntity()).func_70690_d(new PotionEffect((Potion)ModPotions.NULLIFY_GRAVITY, 100, 0, true, false));
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onFlyFall(PlayerFlyableFallEvent event) {
        if (event.getEntityPlayer().func_130014_f_().field_73011_w.getDimension() == 0 && event.getEntityPlayer().field_70143_R >= (float)ConfigValues.underworldFallDistance) {
            BlockPos location = event.getEntityPlayer().func_180425_c();
            BlockPos bedrock = PosUtils.checkNeighborBlocksThoroughly(event.getEntity().func_130014_f_(), location, Blocks.field_150357_h);
            if (bedrock != null && event.getEntity().func_130014_f_().func_180495_p(bedrock).func_177230_c() == Blocks.field_150357_h) {
                TeleportUtil.teleportToDimension(event.getEntityPlayer(), Wizardry.underWorld.func_186068_a(), 0.0, 300.0, 0.0);
                ((EntityPlayer)event.getEntity()).func_70690_d(new PotionEffect((Potion)ModPotions.NULLIFY_GRAVITY, 100, 0, true, false));
                this.fallResetter.add(event.getEntity().func_110124_au());
            }
        }
    }

    @SubscribeEvent
    public void fairyAmbush(SpellCastEvent event) {
        Entity caster = event.getSpellData().getData(SpellData.DefaultKeys.CASTER);
        int chance = 5;
        for (SpellRing spellRing : SpellUtils.getAllSpellRings(event.getSpellRing())) {
            if (spellRing.getModule() == null || !(spellRing.getModule().getModuleClass() instanceof IContinuousModule)) continue;
            chance = 1000;
            break;
        }
        if (RandUtil.nextInt(chance) == 0 && caster != null) {
            List fairyList = event.getSpellData().world.func_72872_a(EntityFairy.class, new AxisAlignedBB(caster.func_180425_c()).func_72314_b(64.0, 64.0, 64.0));
            if (fairyList.isEmpty()) {
                return;
            }
            EntityFairy fairy = (EntityFairy)((Object)fairyList.get(RandUtil.nextInt(fairyList.size() - 1)));
            if (fairy == null) {
                return;
            }
            fairy.ambush = true;
        }
    }
}

