/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.wizardry.common.block;

import com.teamwizardry.librarianlib.features.base.block.tile.BlockModContainer;
import com.teamwizardry.librarianlib.features.helpers.ItemNBTHelper;
import com.teamwizardry.librarianlib.features.network.PacketHandler;
import com.teamwizardry.wizardry.api.block.IStructure;
import com.teamwizardry.wizardry.api.block.WizardryStructureRenderCompanion;
import com.teamwizardry.wizardry.api.item.IInfusable;
import com.teamwizardry.wizardry.api.spell.SpellBuilder;
import com.teamwizardry.wizardry.api.spell.SpellRing;
import com.teamwizardry.wizardry.api.spell.SpellUtils;
import com.teamwizardry.wizardry.api.util.RandUtil;
import com.teamwizardry.wizardry.common.network.PacketAddItemCraftingPlate;
import com.teamwizardry.wizardry.common.network.PacketExplode;
import com.teamwizardry.wizardry.common.network.PacketRemoveItemCraftingPlate;
import com.teamwizardry.wizardry.common.tile.TileCraftingPlate;
import com.teamwizardry.wizardry.init.ModBlocks;
import com.teamwizardry.wizardry.init.ModItems;
import com.teamwizardry.wizardry.init.ModSounds;
import com.teamwizardry.wizardry.init.ModStructures;
import java.awt.Color;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;

public class BlockCraftingPlate
extends BlockModContainer
implements IStructure {
    private static final AxisAlignedBB AABB_CRAFTING_PLATE = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.8125, 1.0);

    public BlockCraftingPlate() {
        super("crafting_plate", Material.field_151575_d, new String[0]);
        this.func_149711_c(2.0f);
        this.func_149752_b(15.0f);
        this.func_149672_a(SoundType.field_185848_a);
    }

    public int getLightValue(@Nonnull IBlockState state, IBlockAccess world, @Nonnull BlockPos pos) {
        return 15;
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState iBlockState) {
        return new TileCraftingPlate();
    }

    private TileCraftingPlate getTE(IBlockAccess world, BlockPos pos) {
        return (TileCraftingPlate)world.func_175625_s(pos);
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (worldIn.field_72995_K) {
            return true;
        }
        ItemStack heldItem = playerIn.func_184586_b(hand);
        if (this.testStructure(worldIn, pos).isEmpty()) {
            TileCraftingPlate plate = this.getTE((IBlockAccess)worldIn, pos);
            if (!((ItemStackHandler)plate.inputPearl.getHandler()).getStackInSlot(0).func_190926_b()) {
                return false;
            }
            if (!heldItem.func_190926_b()) {
                if (heldItem.func_77973_b() == ModItems.BOOK && playerIn.func_184812_l_()) {
                    ItemStack pearl = new ItemStack((Item)ModItems.PEARL_NACRE);
                    NBTTagList moduleList = ItemNBTHelper.getList((ItemStack)heldItem, (String)"spellData", (int)8);
                    if (moduleList == null) {
                        return false;
                    }
                    SpellBuilder builder = new SpellBuilder(SpellUtils.getSpellItems(SpellUtils.deserializeModuleList(moduleList)));
                    NBTTagList list = new NBTTagList();
                    for (SpellRing spellRing : builder.getSpell()) {
                        list.func_74742_a((NBTBase)spellRing.serializeNBT());
                    }
                    ItemNBTHelper.setList((ItemStack)pearl, (String)"spellData", (NBTTagList)list);
                    ItemNBTHelper.setBoolean((ItemStack)pearl, (String)"infused", (boolean)true);
                    ItemNBTHelper.setFloat((ItemStack)pearl, (String)"rand", (float)playerIn.field_70170_p.field_73012_v.nextFloat());
                    ((ItemStackHandler)plate.outputPearl.getHandler()).setStackInSlot(0, pearl);
                    plate.func_70296_d();
                    PacketHandler.NETWORK.sendToAllAround((IMessage)new PacketExplode(new Vec3d((Vec3i)pos).func_72441_c(0.5, 0.5, 0.5), Color.CYAN, Color.BLUE, 2.0, 2.0, 500, 300, 20, false), new NetworkRegistry.TargetPoint(worldIn.field_73011_w.getDimension(), (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 256.0));
                    worldIn.func_184133_a(null, pos, (SoundEvent)ModSounds.BASS_BOOM, SoundCategory.BLOCKS, 1.0f, (float)RandUtil.nextDouble(1.0, 1.5));
                    return true;
                }
                ItemStack stack = heldItem.func_77946_l();
                int oldCount = stack.func_190916_E();
                int subtractHand = playerIn.func_70093_af() ? 64 : 1;
                heldItem.func_190918_g(subtractHand);
                stack.func_190920_e(oldCount - heldItem.func_190916_E());
                if (!plate.isInventoryEmpty() && stack.func_77973_b() instanceof IInfusable) {
                    ((ItemStackHandler)plate.inputPearl.getHandler()).setStackInSlot(0, stack);
                    plate.func_70296_d();
                    playerIn.field_71070_bA.func_75142_b();
                    worldIn.func_184138_a(pos, state, state, 3);
                } else if (!(stack.func_77973_b() instanceof IInfusable)) {
                    ItemHandlerHelper.insertItem((IItemHandler)((IItemHandler)plate.realInventory.getHandler()), (ItemStack)stack, (boolean)false);
                    PacketHandler.NETWORK.sendToAllAround((IMessage)new PacketAddItemCraftingPlate(pos, stack), new NetworkRegistry.TargetPoint(worldIn.field_73011_w.getDimension(), (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 256.0));
                    plate.func_70296_d();
                    playerIn.field_71070_bA.func_75142_b();
                }
                return true;
            }
            if (plate.hasOutputPearl()) {
                playerIn.func_184611_a(hand, ((ItemStackHandler)plate.outputPearl.getHandler()).extractItem(0, 1, false));
                plate.func_70296_d();
                playerIn.field_71070_bA.func_75142_b();
                return true;
            }
            for (int i = ((ItemStackHandler)plate.realInventory.getHandler()).getSlots() - 1; i >= 0; --i) {
                ItemStack extracted = ((ItemStackHandler)plate.realInventory.getHandler()).extractItem(i, playerIn.func_70093_af() ? 64 : 1, false);
                PacketHandler.NETWORK.sendToAllAround((IMessage)new PacketRemoveItemCraftingPlate(pos, i), new NetworkRegistry.TargetPoint(worldIn.field_73011_w.getDimension(), (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 256.0));
                if (extracted.func_190926_b()) continue;
                playerIn.func_191521_c(extracted);
                plate.func_70296_d();
                playerIn.field_71070_bA.func_75142_b();
                break;
            }
            return true;
        }
        if (playerIn.func_184812_l_() && playerIn.func_70093_af()) {
            this.buildStructure(worldIn, pos);
        } else {
            TileCraftingPlate plate = this.getTE((IBlockAccess)worldIn, pos);
            plate.revealStructure = !plate.revealStructure;
            plate.func_70296_d();
        }
        return heldItem.func_190926_b();
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState blockState) {
        return false;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABB_CRAFTING_PLATE;
    }

    @Override
    public WizardryStructureRenderCompanion getStructure() {
        return ModStructures.INSTANCE.getStructure((Block)ModBlocks.CRAFTING_PLATE);
    }

    @Override
    public Vec3i offsetToCenter() {
        return new Vec3i(4, 1, 4);
    }
}

