/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.wizardry.client.gui.worktable;

import com.teamwizardry.librarianlib.core.LibrarianLib;
import com.teamwizardry.librarianlib.features.animator.Animation;
import com.teamwizardry.librarianlib.features.animator.Easing;
import com.teamwizardry.librarianlib.features.animator.animations.BasicAnimation;
import com.teamwizardry.librarianlib.features.animator.animations.Keyframe;
import com.teamwizardry.librarianlib.features.animator.animations.KeyframeAnimation;
import com.teamwizardry.librarianlib.features.animator.animations.ScheduledEventAnimation;
import com.teamwizardry.librarianlib.features.eventbus.Event;
import com.teamwizardry.librarianlib.features.gui.GuiBase;
import com.teamwizardry.librarianlib.features.gui.component.GuiComponent;
import com.teamwizardry.librarianlib.features.gui.component.GuiComponentEvents;
import com.teamwizardry.librarianlib.features.gui.components.ComponentRect;
import com.teamwizardry.librarianlib.features.gui.components.ComponentSprite;
import com.teamwizardry.librarianlib.features.gui.components.ComponentText;
import com.teamwizardry.librarianlib.features.gui.components.ComponentVoid;
import com.teamwizardry.librarianlib.features.gui.mixin.DragMixin;
import com.teamwizardry.librarianlib.features.helpers.ItemNBTHelper;
import com.teamwizardry.librarianlib.features.math.Vec2d;
import com.teamwizardry.librarianlib.features.network.PacketHandler;
import com.teamwizardry.librarianlib.features.sprite.ISprite;
import com.teamwizardry.librarianlib.features.sprite.Sprite;
import com.teamwizardry.wizardry.api.spell.CommonWorktableModule;
import com.teamwizardry.wizardry.api.spell.SpellBuilder;
import com.teamwizardry.wizardry.api.spell.SpellRing;
import com.teamwizardry.wizardry.api.spell.SpellUtils;
import com.teamwizardry.wizardry.api.spell.module.ModuleInstance;
import com.teamwizardry.wizardry.api.spell.module.ModuleInstanceModifier;
import com.teamwizardry.wizardry.api.spell.module.ModuleRegistry;
import com.teamwizardry.wizardry.api.spell.module.ModuleType;
import com.teamwizardry.wizardry.api.util.RandUtil;
import com.teamwizardry.wizardry.client.gui.worktable.ComponentModifiers;
import com.teamwizardry.wizardry.client.gui.worktable.TableModule;
import com.teamwizardry.wizardry.common.network.PacketSendSpellToBook;
import com.teamwizardry.wizardry.common.network.PacketSyncWorktable;
import com.teamwizardry.wizardry.common.tile.TileMagiciansWorktable;
import com.teamwizardry.wizardry.init.ModItems;
import com.teamwizardry.wizardry.init.ModSounds;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import kotlin.Pair;
import net.minecraft.client.Minecraft;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.jetbrains.annotations.NotNull;

public class WorktableGui
extends GuiBase {
    static final Sprite TABLE_SPRITE = new Sprite(new ResourceLocation("wizardry", "textures/gui/worktable/table.png"));
    static final Sprite SIDE_BAR_SHORT = new Sprite(new ResourceLocation("wizardry", "textures/gui/worktable/sidebar.png"));
    static final Sprite SIDE_BAR_LONG = new Sprite(new ResourceLocation("wizardry", "textures/gui/worktable/sidebar_long.png"));
    static final Sprite BUTTON_NORMAL = new Sprite(new ResourceLocation("wizardry", "textures/gui/worktable/button.png"));
    static final Sprite BUTTON_HIGHLIGHTED = new Sprite(new ResourceLocation("wizardry", "textures/gui/worktable/button_highlighted.png"));
    static final Sprite BUTTON_PRESSED = new Sprite(new ResourceLocation("wizardry", "textures/gui/worktable/button_pressed.png"));
    static final Sprite BUTTON_SHORT_NORMAL = new Sprite(new ResourceLocation("wizardry", "textures/gui/worktable/button_short.png"));
    static final Sprite BUTTON_SHORT_HIGHLIGHTED = new Sprite(new ResourceLocation("wizardry", "textures/gui/worktable/button_short_highlighted.png"));
    static final Sprite BUTTON_SHORT_PRESSED = new Sprite(new ResourceLocation("wizardry", "textures/gui/worktable/button_short_pressed.png"));
    static final Sprite PLATE = new Sprite(new ResourceLocation("wizardry", "textures/gui/worktable/plate.png"));
    static final Sprite PLATE_HIGHLIGHTED = new Sprite(new ResourceLocation("wizardry", "textures/gui/worktable/plate_highlighted.png"));
    static final Sprite PLATE_HIGHLIGHTED_ERROR = new Sprite(new ResourceLocation("wizardry", "textures/gui/worktable/plate_highlighted_error.png"));
    static final Sprite STREAK = new Sprite(new ResourceLocation("wizardry", "textures/gui/worktable/streak.png"));
    static final Sprite BOOK_ICON = new Sprite(new ResourceLocation("wizardry", "textures/items/book.png"));
    static final Sprite SAVE_ICON = new Sprite(new ResourceLocation("wizardry", "textures/gui/worktable/save.png"));
    static final Sprite BROOM_ICON = new Sprite(new ResourceLocation("wizardry", "textures/gui/worktable/broom.png"));
    static final Sprite BOOK_COVER_ICON = new Sprite(new ResourceLocation("wizardry", "textures/gui/worktable/book_cover.png"));
    final ComponentModifiers modifiers;
    final ComponentVoid paper;
    final ComponentText toast;
    @Nullable
    public TableModule selectedModule = null;
    public float backgroundAlpha = 0.0f;
    public boolean animationPlaying = false;
    private ComponentSprite tableComponent;
    private boolean hadBook = false;
    private boolean bookWarnRevised = false;
    protected Set<CommonWorktableModule> commonModules = new HashSet<CommonWorktableModule>();
    private List<List<ModuleInstance>> chains = new ArrayList<List<ModuleInstance>>();
    private boolean canBeSaved = false;
    @NotNull
    private final BlockPos pos;

    public WorktableGui(@Nonnull BlockPos pos) {
        super(480, 224);
        this.pos = pos;
        ComponentRect grayBackground = new ComponentRect(0, 0, 40000, 40000);
        grayBackground.getColor().setValue((Object)new Color(0.05f, 0.05f, 0.05f, 0.8f));
        grayBackground.getTransform().setTranslateZ(-20.0);
        this.getFullscreenComponents().add(new GuiComponent[]{grayBackground});
        this.tableComponent = new ComponentSprite((ISprite)TABLE_SPRITE, 0, 0, 480, 224);
        this.getMainComponents().add(new GuiComponent[]{this.tableComponent});
        this.paper = new ComponentVoid(181, 22, 180, 184);
        this.tableComponent.add(new GuiComponent[]{this.paper});
        this.toast = new ComponentText(384, 56, ComponentText.TextAlignH.LEFT, ComponentText.TextAlignV.TOP);
        this.toast.setSize(new Vec2d(80.0, 63.0).mul(2.0));
        this.toast.clipping.setClipToBounds(true);
        this.toast.getTransform().setScale(0.5);
        this.toast.getWrap().setValue((Object)160);
        this.tableComponent.add(new GuiComponent[]{this.toast});
        this.setCodexToastMessage();
        this.toast.BUS.hook(GuiComponentEvents.ComponentTickEvent.class, event -> {
            if (!this.bookWarnRevised && !this.hadBook && Minecraft.func_71410_x().field_71439_g.field_71071_by.func_70431_c(new ItemStack((Item)ModItems.BOOK))) {
                this.toast.getColor().setValue((Object)Color.GREEN);
                this.toast.getText().setValue((Object)LibrarianLib.PROXY.translate("wizardry.table.codex_found", new Object[0]));
                this.bookWarnRevised = true;
            }
        });
        ComponentSprite shapes = new ComponentSprite((ISprite)SIDE_BAR_SHORT, 29, 31, 48, 80);
        this.addModules(shapes, ModuleType.SHAPE);
        this.tableComponent.add(new GuiComponent[]{shapes});
        ComponentSprite effects = new ComponentSprite((ISprite)SIDE_BAR_LONG, 93, 37, 48, 160);
        this.addModules(effects, ModuleType.EFFECT);
        this.tableComponent.add(new GuiComponent[]{effects});
        ComponentSprite events = new ComponentSprite((ISprite)SIDE_BAR_SHORT, 29, 123, 48, 80);
        this.addModules(events, ModuleType.EVENT);
        this.tableComponent.add(new GuiComponent[]{events});
        this.modifiers = new ComponentModifiers(this);
        this.tableComponent.add(new GuiComponent[]{this.modifiers});
        int menuX = 384;
        int menuY = 20;
        int menuWidth = 80;
        int buttonWidth = 20;
        int buttonHeight = 16;
        int buttonX = 390;
        int buttonY = 25;
        int spacing = 5;
        int iconSize = 12;
        int iconSizeHovered = 16;
        ComponentSprite save = new ComponentSprite((ISprite)BUTTON_SHORT_NORMAL, menuX + menuWidth / 2 - buttonWidth - buttonWidth / 2 - spacing, spacing + menuY, buttonWidth, buttonHeight);
        ComponentSprite sprite = new ComponentSprite((ISprite)SAVE_ICON, buttonWidth / 2 - iconSize / 2, buttonHeight / 2 - iconSize / 2, iconSize, iconSize);
        save.add(new GuiComponent[]{sprite});
        save.render.getTooltip().func(t -> {
            ArrayList<String> txt = new ArrayList<String>();
            if (!this.animationPlaying) {
                txt.add(TextFormatting.GOLD + LibrarianLib.PROXY.translate("wizardry.table.save", new Object[0]));
                txt.add(TextFormatting.GRAY + LibrarianLib.PROXY.translate("wizardry.table.save_desc", new Object[0]));
                if (!Minecraft.func_71410_x().field_71439_g.field_71071_by.func_70431_c(new ItemStack((Item)ModItems.BOOK))) {
                    txt.add(TextFormatting.RED + LibrarianLib.PROXY.translate("wizardry.table.save_error", new Object[0]));
                }
                if (!this.canBeSaved) {
                    txt.add(TextFormatting.RED + "Invalid Spell!");
                }
            }
            return txt;
        });
        save.BUS.hook(GuiComponentEvents.ComponentTickEvent.class, event -> {
            if (!this.canBeSaved || this.animationPlaying || !Minecraft.func_71410_x().field_71439_g.field_71071_by.func_70431_c(new ItemStack((Item)ModItems.BOOK))) {
                save.setSprite((ISprite)BUTTON_SHORT_PRESSED);
            } else if (event.component.getMouseOver()) {
                save.setSprite((ISprite)BUTTON_SHORT_HIGHLIGHTED);
            } else {
                save.setSprite((ISprite)BUTTON_SHORT_NORMAL);
            }
        });
        save.BUS.hook(GuiComponentEvents.MouseDownEvent.class, event -> {
            if (!this.animationPlaying && event.component.getMouseOver()) {
                Minecraft.func_71410_x().field_71439_g.func_184185_a((SoundEvent)ModSounds.BUTTON_CLICK_IN, 1.0f, 1.0f);
            }
        });
        save.BUS.hook(GuiComponentEvents.MouseUpEvent.class, event -> {
            if (!this.animationPlaying && event.component.getMouseOver()) {
                Minecraft.func_71410_x().field_71439_g.func_184185_a((SoundEvent)ModSounds.BUTTON_CLICK_OUT, 1.0f, 1.0f);
            }
        });
        this.paper.BUS.hook(TableModule.ModuleUpdateEvent.class, event -> {
            TableModule subModule;
            Object lastModule;
            this.commonModules.clear();
            this.chains.clear();
            for (TableModule head : this.getSpellHeads()) {
                ArrayList<ModuleInstance> arrayList = new ArrayList<ModuleInstance>();
                lastModule = head;
                Object lastCommonModule = new CommonWorktableModule(((Object)lastModule).hashCode(), lastModule.getModule(), lastModule.getPos(), null, new HashMap<ModuleInstanceModifier, Integer>());
                this.commonModules.add((CommonWorktableModule)lastCommonModule);
                while (lastModule != null) {
                    if (lastModule.isInvalid()) continue;
                    arrayList.add(lastModule.getModule());
                    if (lastModule != head) {
                        CommonWorktableModule commonModule = new CommonWorktableModule(((Object)lastModule).hashCode(), lastModule.getModule(), lastModule.getPos(), null, new HashMap<ModuleInstanceModifier, Integer>());
                        ((CommonWorktableModule)lastCommonModule).setLinksTo(commonModule);
                        lastCommonModule = commonModule;
                    }
                    for (ModuleInstance module2 : ModuleRegistry.INSTANCE.getModules(ModuleType.MODIFIER)) {
                        if (!(module2 instanceof ModuleInstanceModifier) || !lastModule.hasData(Integer.class, module2.getSubModuleID())) continue;
                        int count = (Integer)lastModule.getData(Integer.class, module2.getSubModuleID());
                        for (int i = 0; i < count; ++i) {
                            arrayList.add(module2);
                        }
                        ((CommonWorktableModule)lastCommonModule).addModifier((ModuleInstanceModifier)module2, count);
                    }
                    lastModule = lastModule.getLinksTo();
                }
                this.chains.add(arrayList);
            }
            this.canBeSaved = true;
            block4: for (GuiComponent paperComponent : this.paper.getChildren()) {
                TableModule tableModule;
                if (!(paperComponent instanceof TableModule) || (tableModule = (TableModule)paperComponent).isInvalid() || tableModule.getLinksTo() != null) continue;
                for (GuiComponent subPaperComponent : this.paper.getChildren()) {
                    if (!(subPaperComponent instanceof TableModule) || (subModule = (TableModule)subPaperComponent).isInvalid() || subModule == tableModule || subModule.getLinksTo() != tableModule) continue;
                    continue block4;
                }
                tableModule.setErrored(true);
                TableModule.select(tableModule);
                this.canBeSaved = false;
            }
            if (!this.canBeSaved) {
                this.setToastMessage("Component is not linked to anything! Link it to something to make it function properly.", Color.RED);
                return;
            }
            block6: for (GuiComponent paperComponent : this.paper.getChildren()) {
                TableModule tableModule;
                if (!(paperComponent instanceof TableModule) || (tableModule = (TableModule)paperComponent).isInvalid() || tableModule.getModule().getModuleType() == ModuleType.SHAPE) continue;
                for (GuiComponent subPaperComponent : this.paper.getChildren()) {
                    if (!(subPaperComponent instanceof TableModule) || (subModule = (TableModule)subPaperComponent).isInvalid() || subModule == tableModule || subModule.getLinksTo() != tableModule) continue;
                    continue block6;
                }
                tableModule.setErrored(true);
                TableModule.select(tableModule);
                this.canBeSaved = false;
            }
            if (!this.canBeSaved) {
                this.setToastMessage("Spell chain starts without a Shape component! Your spell needs to start with a shape to run properly.", Color.RED);
                return;
            }
            boolean shapeLinkedFromNothing = false;
            for (CommonWorktableModule commonWorktableModule : this.commonModules) {
                lastModule = commonWorktableModule;
                while (lastModule != null) {
                    if (((CommonWorktableModule)lastModule).module.getModuleType() == ModuleType.SHAPE) {
                        if (((CommonWorktableModule)lastModule).linksTo == null) {
                            this.canBeSaved = false;
                            this.setToastMessage("Shape component is not linked to anything! It needs to link to something so you can run your spell properly.", Color.RED);
                        } else {
                            boolean isLinkedFrom = false;
                            for (CommonWorktableModule linkedFrom : this.commonModules) {
                                if (linkedFrom.linksTo != lastModule) continue;
                                isLinkedFrom = true;
                                break;
                            }
                            if (!isLinkedFrom) {
                                shapeLinkedFromNothing = true;
                            }
                        }
                    } else if (((CommonWorktableModule)lastModule).module.getModuleType() == ModuleType.EVENT && ((CommonWorktableModule)lastModule).linksTo == null) {
                        this.canBeSaved = false;
                        this.setToastMessage("Event is linked to nothing. Link it to an effect to use it properly.", Color.RED);
                    }
                    lastModule = ((CommonWorktableModule)lastModule).linksTo;
                }
            }
            if (!this.canBeSaved) {
                return;
            }
            if (!shapeLinkedFromNothing) {
                this.canBeSaved = false;
                this.setToastMessage("No spell starting with a shape found. Start a spell with a shape to be able to run it properly.", Color.RED);
            }
            if (this.canBeSaved) {
                this.setToastMessage("Spell is valid!", Color.GREEN);
            }
        });
        save.BUS.hook(GuiComponentEvents.MouseClickEvent.class, event -> {
            if (!this.canBeSaved || this.animationPlaying || !Minecraft.func_71410_x().field_71439_g.field_71071_by.func_70431_c(new ItemStack((Item)ModItems.BOOK))) {
                return;
            }
            NBTTagList commonList = new NBTTagList();
            for (CommonWorktableModule commonModule : this.commonModules) {
                commonList.func_74742_a((NBTBase)commonModule.serializeNBT());
            }
            for (ItemStack stack : Minecraft.func_71410_x().field_71439_g.field_71071_by.field_70462_a) {
                if (stack.func_77973_b() != ModItems.BOOK) continue;
                ItemNBTHelper.setList((ItemStack)stack, (String)"common_modules", (NBTTagList)commonList);
            }
            PacketHandler.NETWORK.sendToServer((IMessage)new PacketSendSpellToBook(Minecraft.func_71410_x().field_71439_g.func_110124_au(), this.chains, this.commonModules));
            this.playSaveAnimation(null);
        });
        this.getMainComponents().add(new GuiComponent[]{save});
        ComponentSprite load = new ComponentSprite((ISprite)BUTTON_SHORT_NORMAL, menuX + menuWidth / 2 - buttonWidth / 2, spacing + menuY, buttonWidth, buttonHeight);
        String saveStr = LibrarianLib.PROXY.translate("wizardry.table.load", new Object[0]);
        int stringWidth = Minecraft.func_71410_x().field_71466_p.func_78256_a(saveStr);
        int fitWidth = load.getSize().getXi() - 16;
        ComponentText textSave = new ComponentText(16 + (int)((double)fitWidth / 2.0 - (double)stringWidth / 2.0), load.getSize().getYi() / 2, ComponentText.TextAlignH.LEFT, ComponentText.TextAlignV.MIDDLE);
        textSave.getText().setValue((Object)saveStr);
        ComponentSprite sprite2 = new ComponentSprite((ISprite)BOOK_COVER_ICON, buttonWidth / 2 - iconSize / 2, buttonHeight / 2 - iconSize / 2, iconSize, iconSize);
        load.add(new GuiComponent[]{sprite2});
        load.render.getTooltip().func(t -> {
            ArrayList<String> txt = new ArrayList<String>();
            if (!this.animationPlaying) {
                txt.add(TextFormatting.GOLD + LibrarianLib.PROXY.translate("wizardry.table.load", new Object[0]));
                txt.add(TextFormatting.GRAY + LibrarianLib.PROXY.translate("wizardry.table.load_desc", new Object[0]));
            }
            return txt;
        });
        load.BUS.hook(GuiComponentEvents.ComponentTickEvent.class, event -> {
            if (this.animationPlaying) {
                load.setSprite((ISprite)BUTTON_SHORT_PRESSED);
            } else if (event.component.getMouseOver()) {
                load.setSprite((ISprite)BUTTON_SHORT_HIGHLIGHTED);
            } else {
                load.setSprite((ISprite)BUTTON_SHORT_NORMAL);
            }
        });
        load.BUS.hook(GuiComponentEvents.MouseDownEvent.class, event -> {
            if (!this.animationPlaying && event.component.getMouseOver()) {
                Minecraft.func_71410_x().field_71439_g.func_184185_a((SoundEvent)ModSounds.BUTTON_CLICK_IN, 1.0f, 1.0f);
            }
        });
        load.BUS.hook(GuiComponentEvents.MouseUpEvent.class, event -> {
            if (!this.animationPlaying && event.component.getMouseOver()) {
                Minecraft.func_71410_x().field_71439_g.func_184185_a((SoundEvent)ModSounds.BUTTON_CLICK_OUT, 1.0f, 1.0f);
            }
        });
        load.BUS.hook(GuiComponentEvents.MouseClickEvent.class, event -> {
            if (this.animationPlaying) {
                return;
            }
            NBTTagList commonList = null;
            for (Object stack : Minecraft.func_71410_x().field_71439_g.field_71071_by.field_70462_a) {
                NBTTagList list;
                if (stack.func_77973_b() != ModItems.BOOK || (list = ItemNBTHelper.getList((ItemStack)stack, (String)"common_modules", NBTTagCompound.class)) == null || list.func_82582_d()) continue;
                commonList = list;
            }
            if (commonList == null) {
                return;
            }
            HashSet<CommonWorktableModule> commonModules = new HashSet<CommonWorktableModule>();
            for (NBTBase base : commonList) {
                if (!(base instanceof NBTTagCompound)) continue;
                NBTTagCompound compound = (NBTTagCompound)base;
                CommonWorktableModule commonModule = CommonWorktableModule.deserailize(compound);
                commonModules.add(commonModule);
            }
            boolean isEmpty = true;
            for (GuiComponent child : this.paper.getChildren()) {
                if (!(child instanceof TableModule)) continue;
                isEmpty = false;
                break;
            }
            if (isEmpty) {
                this.playLoadAnimation(commonModules, () -> {
                    this.syncToServer();
                    this.animationPlaying = false;
                });
            } else {
                this.playClearAnimation(() -> this.playLoadAnimation(commonModules, () -> {
                    this.syncToServer();
                    this.animationPlaying = false;
                }));
            }
            this.setToastMessageNoHeader(LibrarianLib.PROXY.translate("wizardry.table.spell_loaded", new Object[0]), Color.GREEN);
        });
        this.getMainComponents().add(new GuiComponent[]{load});
        ComponentSprite clear = new ComponentSprite((ISprite)BUTTON_SHORT_NORMAL, menuX + menuWidth / 2 + buttonWidth / 2 + spacing, spacing + menuY, buttonWidth, buttonHeight);
        saveStr = LibrarianLib.PROXY.translate("wizardry.table.clear", new Object[0]);
        stringWidth = Minecraft.func_71410_x().field_71466_p.func_78256_a(saveStr);
        fitWidth = clear.getSize().getXi() - 16;
        textSave = new ComponentText(16 + (int)((double)fitWidth / 2.0 - (double)stringWidth / 2.0), clear.getSize().getYi() / 2, ComponentText.TextAlignH.LEFT, ComponentText.TextAlignV.MIDDLE);
        textSave.getText().setValue((Object)saveStr);
        sprite2 = new ComponentSprite((ISprite)BROOM_ICON, buttonWidth / 2 - iconSize / 2, buttonHeight / 2 - iconSize / 2, iconSize, iconSize);
        clear.add(new GuiComponent[]{sprite2});
        clear.render.getTooltip().func(t -> {
            ArrayList<String> txt = new ArrayList<String>();
            if (!this.animationPlaying) {
                txt.add(TextFormatting.GOLD + LibrarianLib.PROXY.translate("wizardry.table.clear", new Object[0]));
                txt.add(TextFormatting.GRAY + LibrarianLib.PROXY.translate("wizardry.table.clear_desc", new Object[0]));
            }
            return txt;
        });
        clear.BUS.hook(GuiComponentEvents.ComponentTickEvent.class, event -> {
            if (this.animationPlaying) {
                clear.setSprite((ISprite)BUTTON_SHORT_PRESSED);
            } else if (event.component.getMouseOver()) {
                clear.setSprite((ISprite)BUTTON_SHORT_HIGHLIGHTED);
            } else {
                clear.setSprite((ISprite)BUTTON_SHORT_NORMAL);
            }
        });
        clear.BUS.hook(GuiComponentEvents.MouseDownEvent.class, event -> {
            if (!this.animationPlaying && event.component.getMouseOver()) {
                Minecraft.func_71410_x().field_71439_g.func_184185_a((SoundEvent)ModSounds.BUTTON_CLICK_IN, 1.0f, 1.0f);
            }
        });
        clear.BUS.hook(GuiComponentEvents.MouseUpEvent.class, event -> {
            if (!this.animationPlaying && event.component.getMouseOver()) {
                Minecraft.func_71410_x().field_71439_g.func_184185_a((SoundEvent)ModSounds.BUTTON_CLICK_OUT, 1.0f, 1.0f);
            }
        });
        clear.BUS.hook(GuiComponentEvents.MouseClickEvent.class, event -> {
            if (this.animationPlaying) {
                return;
            }
            this.playClearAnimation(() -> {
                this.syncToServer();
                this.animationPlaying = false;
            });
            this.setToastMessageNoHeader(LibrarianLib.PROXY.translate("wizardry.table.paper_cleared", new Object[0]), Color.GREEN);
        });
        this.getMainComponents().add(new GuiComponent[]{clear});
        this.load();
        this.paper.BUS.fire((Event)new TableModule.ModuleUpdateEvent());
    }

    public void load() {
        TileEntity tile = Minecraft.func_71410_x().field_71441_e.func_175625_s(this.pos);
        if (tile instanceof TileMagiciansWorktable && ((TileMagiciansWorktable)tile).commonModules != null) {
            Set<CommonWorktableModule> commonModules = ((TileMagiciansWorktable)tile).getCommonModules();
            Iterator<CommonWorktableModule> iterator = commonModules.iterator();
            while (iterator.hasNext()) {
                CommonWorktableModule commonHead;
                CommonWorktableModule commonModule = commonHead = iterator.next();
                TableModule lastModule = new TableModule(this, commonHead.module, true, false);
                lastModule.setPos(commonHead.pos);
                while (commonModule != null) {
                    lastModule.radius = 10.0f;
                    lastModule.textRadius = 0.0f;
                    this.paper.add(new GuiComponent[]{lastModule});
                    DragMixin drag = new DragMixin((GuiComponent)lastModule, vec2d -> vec2d);
                    drag.setDragOffset(new Vec2d(6.0, 6.0));
                    for (ModuleInstanceModifier modifier : commonModule.modifiers.keySet()) {
                        lastModule.setData(Integer.class, modifier.getSubModuleID(), commonModule.modifiers.get(modifier));
                    }
                    if (commonModule.linksTo != null) {
                        TableModule childModule = new TableModule(this, commonModule.linksTo.module, true, false);
                        childModule.setPos(commonModule.linksTo.pos);
                        lastModule.setLinksTo(childModule);
                        lastModule = childModule;
                    }
                    commonModule = commonModule.linksTo;
                }
            }
        }
    }

    public void syncToServer() {
        HashSet<CommonWorktableModule> commonModules = new HashSet<CommonWorktableModule>();
        Iterator<TableModule> iterator = this.getSpellHeads().iterator();
        while (iterator.hasNext()) {
            TableModule head;
            TableModule lastModule;
            CommonWorktableModule lastCommonModule = new CommonWorktableModule(((Object)((Object)lastModule)).hashCode(), lastModule.getModule(), lastModule.getPos(), null, new HashMap<ModuleInstanceModifier, Integer>());
            commonModules.add(lastCommonModule);
            for (lastModule = head = iterator.next(); lastModule != null; lastModule = lastModule.getLinksTo()) {
                if (lastModule != head) {
                    CommonWorktableModule commonModule = new CommonWorktableModule(((Object)((Object)lastModule)).hashCode(), lastModule.getModule(), lastModule.getPos(), null, new HashMap<ModuleInstanceModifier, Integer>());
                    lastCommonModule.setLinksTo(commonModule);
                    lastCommonModule = commonModule;
                }
                for (ModuleInstance module : ModuleRegistry.INSTANCE.getModules(ModuleType.MODIFIER)) {
                    if (!(module instanceof ModuleInstanceModifier) || !lastModule.hasData(Integer.class, module.getSubModuleID())) continue;
                    int count = (Integer)lastModule.getData(Integer.class, module.getSubModuleID());
                    lastCommonModule.addModifier((ModuleInstanceModifier)module, count);
                }
            }
        }
        int dim = Minecraft.func_71410_x().field_71441_e.field_73011_w.getDimension();
        PacketHandler.NETWORK.sendToServer((IMessage)new PacketSyncWorktable(dim, this.pos, commonModules));
    }

    public void setCodexToastMessage() {
        if (!Minecraft.func_71410_x().field_71439_g.field_71071_by.func_70431_c(new ItemStack((Item)ModItems.BOOK))) {
            this.hadBook = false;
            this.toast.getColor().setValue((Object)Color.RED);
            this.toast.getText().setValue((Object)LibrarianLib.PROXY.translate("wizardry.table.no_codex_found", new Object[0]));
        } else {
            this.hadBook = true;
            this.toast.getColor().setValue((Object)Color.GREEN);
            this.toast.getText().setValue((Object)LibrarianLib.PROXY.translate("wizardry.table.codex_found", new Object[0]));
        }
    }

    public String getToastHeader() {
        return TextFormatting.YELLOW.toString() + this.getSpellName() + TextFormatting.RESET + "\n\n";
    }

    public String getSpellName() {
        ArrayList<List<ModuleInstance>> chains = new ArrayList<List<ModuleInstance>>();
        for (TableModule head : this.getSpellHeads()) {
            ArrayList<ModuleInstance> chain = new ArrayList<ModuleInstance>();
            for (TableModule lastModule = head; lastModule != null; lastModule = lastModule.getLinksTo()) {
                chain.add(lastModule.getModule());
                for (ModuleInstance module : ModuleRegistry.INSTANCE.getModules(ModuleType.MODIFIER)) {
                    if (!(module instanceof ModuleInstanceModifier) || !lastModule.hasData(Integer.class, module.getSubModuleID())) continue;
                    int count = (Integer)lastModule.getData(Integer.class, module.getSubModuleID());
                    for (int i = 0; i < count; ++i) {
                        chain.add(module);
                    }
                }
            }
            chains.add(chain);
        }
        SpellBuilder builder = new SpellBuilder(SpellUtils.getSpellItems(chains));
        StringBuilder spellNameBuilder = new StringBuilder();
        SpellRing lastRing = null;
        for (SpellRing ring : builder.getSpell()) {
            if (lastRing == null) {
                lastRing = ring;
            }
            if (ring == null) continue;
            if (ring != lastRing) {
                spellNameBuilder.append(TextFormatting.GRAY).append(" | ");
            }
            SpellRing tmpRing = ring;
            while (tmpRing != null) {
                spellNameBuilder.append(TextFormatting.YELLOW).append(tmpRing.getModuleReadableName()).append(TextFormatting.GRAY).append("(").append(TextFormatting.BLUE).append(Math.round(tmpRing.getManaDrain(null) * tmpRing.getManaMultiplier())).append(TextFormatting.GRAY).append("/").append(TextFormatting.RED).append(Math.round(tmpRing.getBurnoutFill(null) * tmpRing.getBurnoutMultiplier())).append(TextFormatting.GRAY).append(")");
                if ((tmpRing = tmpRing.getChildRing()) == null) continue;
                spellNameBuilder.append(TextFormatting.GRAY).append(" > ");
            }
        }
        return spellNameBuilder.toString();
    }

    public Pair<String, Color> getToastMessage() {
        String text = (String)this.toast.getText().getValue((Object)this.toast);
        Color color = (Color)this.toast.getColor().getValue((Object)this.toast);
        return new Pair((Object)text, (Object)color);
    }

    public void setToastMessage(String text, Color color) {
        this.toast.getText().setValue((Object)(this.getToastHeader() + text));
        this.toast.getColor().setValue((Object)color);
    }

    public void setToastMessageNoHeader(String text, Color color) {
        this.toast.getText().setValue((Object)text);
        this.toast.getColor().setValue((Object)color);
    }

    private Set<TableModule> getSpellHeads() {
        HashSet<TableModule> set = new HashSet<TableModule>();
        for (GuiComponent child : this.paper.getChildren()) {
            TableModule childModule;
            if (!(child instanceof TableModule) || (childModule = (TableModule)child).isInvalid()) continue;
            boolean linkedToSomehow = false;
            for (GuiComponent subChild : this.paper.getChildren()) {
                TableModule subChildModule;
                if (subChild.isInvalid() || !(subChild instanceof TableModule) || (subChildModule = (TableModule)subChild) == childModule || subChildModule.getLinksTo() != childModule) continue;
                linkedToSomehow = true;
                break;
            }
            if (linkedToSomehow) continue;
            set.add(childModule);
        }
        return set;
    }

    private void addModules(ComponentSprite parent, ModuleType type) {
        int column = 0;
        int row = 0;
        for (ModuleInstance module : ModuleRegistry.INSTANCE.getModules(type)) {
            TableModule tableModule = new TableModule(this, module, false, false);
            tableModule.setPos(new Vec2d((double)(row * 16), (double)(column * 16)));
            parent.add(new GuiComponent[]{tableModule});
            if (++row < 3) continue;
            row = 0;
            ++column;
        }
    }

    public void playSaveAnimation(@Nullable Runnable finish) {
        this.animationPlaying = true;
        if (this.selectedModule != null) {
            Vec2d toSize = new Vec2d(16.0, 16.0);
            BasicAnimation animSize = new BasicAnimation((Object)this.selectedModule, "size");
            animSize.setDuration(5.0f);
            animSize.setEasing((Easing)Easing.easeOutCubic);
            animSize.setTo((Object)toSize);
            this.selectedModule.add(new Animation[]{animSize});
            BasicAnimation animPos = new BasicAnimation((Object)this.selectedModule, "pos");
            animPos.setDuration(5.0f);
            animPos.setEasing((Easing)Easing.easeOutCubic);
            animPos.setTo((Object)this.selectedModule.getPos().add(this.selectedModule.getSize().sub(toSize).mul(0.5)));
            this.selectedModule.add(new Animation[]{animPos});
        }
        Runnable runnable = () -> {
            ComponentVoid fakePaper = new ComponentVoid(180, 19, 180, 188);
            fakePaper.getTransform().setTranslateZ(100.0);
            this.getMainComponents().add(new GuiComponent[]{fakePaper});
            ComponentVoid bookIconMask = new ComponentVoid(0, -100, 180, 100);
            fakePaper.add(new GuiComponent[]{bookIconMask});
            ComponentRect grayBackground = new ComponentRect(0, 0, this.tableComponent.getSize().getXi(), this.tableComponent.getSize().getYi());
            grayBackground.getColor().setValue((Object)new Color(0.05f, 0.05f, 0.05f, 0.0f));
            grayBackground.getTransform().setTranslateZ(200.0);
            grayBackground.BUS.hook(GuiComponentEvents.ComponentTickEvent.class, event -> grayBackground.getColor().setValue((Object)new Color(0.05f, 0.05f, 0.05f, this.backgroundAlpha)));
            this.tableComponent.add(new GuiComponent[]{grayBackground});
            KeyframeAnimation anim = new KeyframeAnimation((Object)this, "backgroundAlpha");
            anim.setDuration(100.0f);
            anim.setKeyframes(new Keyframe[]{new Keyframe(0.0f, (Object)Float.valueOf(0.0f), (Easing)Easing.easeInOutQuint), new Keyframe(0.2f, (Object)Float.valueOf(0.65f), (Easing)Easing.easeInOutQuint), new Keyframe(0.7f, (Object)Float.valueOf(0.65f), (Easing)Easing.easeInOutQuint), new Keyframe(1.0f, (Object)Float.valueOf(0.0f), (Easing)Easing.easeInOutQuint)});
            anim.setCompletion(() -> ((ComponentRect)grayBackground).invalidate());
            this.getMainComponents().add(new Animation[]{anim});
            ComponentSprite bookIcon = new ComponentSprite((ISprite)BOOK_ICON, (int)(bookIconMask.getSize().getX() / 2.0 - 16.0), (int)(bookIconMask.getSize().getY() + 50.0), 32, 32);
            bookIconMask.add(new GuiComponent[]{bookIcon});
            bookIcon.getTransform().setTranslateZ(200.0);
            bookIconMask.clipping.setClipToBounds(true);
            bookIconMask.getTransform().setTranslateZ(250.0);
            Vec2d originalPos = bookIcon.getPos();
            KeyframeAnimation anim2 = new KeyframeAnimation((Object)bookIcon, "pos.y");
            anim2.setDuration(120.0f);
            anim2.setKeyframes(new Keyframe[]{new Keyframe(0.0f, (Object)originalPos.getY(), Easing.linear), new Keyframe(0.4f, (Object)(bookIconMask.getSize().getY() / 2.0 - 25.0), (Easing)Easing.easeInBack), new Keyframe(0.5f, (Object)(bookIconMask.getSize().getY() / 2.0 - 10.0), (Easing)Easing.easeOutBack), new Keyframe(0.8f, (Object)(bookIconMask.getSize().getY() / 2.0 - 10.0), (Easing)Easing.easeInBack), new Keyframe(1.0f, (Object)originalPos.getY(), (Easing)Easing.easeInBack)});
            anim2.setCompletion(() -> {
                fakePaper.invalidate();
                if (finish == null) {
                    this.animationPlaying = false;
                } else {
                    finish.run();
                }
            });
            ScheduledEventAnimation animSound = new ScheduledEventAnimation(60.0f, () -> Minecraft.func_71410_x().field_71439_g.func_184185_a((SoundEvent)ModSounds.SCRIBBLING, 1.0f, 1.0f));
            bookIcon.add(new Animation[]{anim2, animSound});
            HashMap<Object, UUID> links = new HashMap<Object, UUID>();
            for (GuiComponent component : this.paper.getChildren()) {
                UUID linkTo;
                TableModule linkedModule;
                if (!(component instanceof TableModule)) continue;
                TableModule tableModule = (TableModule)component;
                TableModule fakeModule = new TableModule(this, tableModule.getModule(), false, true);
                fakeModule.setPos(tableModule.getPos());
                for (Object tag : tableModule.getTagList()) {
                    fakeModule.addTag(tag);
                }
                fakeModule.getTransform().setTranslateZ(230.0);
                fakePaper.add(new GuiComponent[]{fakeModule});
                for (ModuleInstance module : ModuleRegistry.INSTANCE.getModules(ModuleType.MODIFIER)) {
                    if (!tableModule.hasData(Integer.class, module.getSubModuleID())) continue;
                    fakeModule.setData(Integer.class, module.getSubModuleID(), tableModule.getData(Integer.class, module.getSubModuleID()));
                }
                UUID uuid = (UUID)tableModule.getData(UUID.class, "uuid");
                if (uuid != null) {
                    fakeModule.setData(UUID.class, "uuid", uuid);
                }
                if ((linkedModule = tableModule.getLinksTo()) == null || (linkTo = (UUID)linkedModule.getData(UUID.class, "uuid")) == null) continue;
                links.put((Object)fakeModule, linkTo);
            }
            block3: for (TableModule module : links.keySet()) {
                UUID linkTo;
                if (!links.containsKey((Object)module) || (linkTo = (UUID)links.get((Object)module)) == null) continue;
                for (GuiComponent child : fakePaper.getChildren()) {
                    UUID uuid = (UUID)child.getData(UUID.class, "uuid");
                    if (uuid == null || !linkTo.equals(uuid) || !(child instanceof TableModule)) continue;
                    TableModule reverseUUIDLink = (TableModule)child;
                    module.setLinksTo(reverseUUIDLink);
                    continue block3;
                }
            }
            for (GuiComponent component : fakePaper.getChildren()) {
                if (!(component instanceof TableModule)) continue;
                TableModule fakeModule = (TableModule)component;
                Vec2d random = fakeModule.getPos().add(RandUtil.nextDouble(-20.0, 20.0), RandUtil.nextDouble(-20.0, 20.0));
                float delay = RandUtil.nextFloat(0.2f, 0.3f);
                float dur = RandUtil.nextFloat(70.0f, 100.0f);
                ScheduledEventAnimation animSound1 = new ScheduledEventAnimation(dur * delay, () -> Minecraft.func_71410_x().field_71439_g.func_184185_a((SoundEvent)ModSounds.POP, 1.0f, 1.0f));
                ScheduledEventAnimation animSound2 = new ScheduledEventAnimation(dur * 0.75f, () -> Minecraft.func_71410_x().field_71439_g.func_184185_a((SoundEvent)ModSounds.WHOOSH, 1.0f, 1.0f));
                KeyframeAnimation animX = new KeyframeAnimation((Object)fakeModule, "pos.x");
                animX.setDuration(dur);
                animX.setKeyframes(new Keyframe[]{new Keyframe(delay, (Object)fakeModule.getPos().getX(), (Easing)Easing.easeOutQuint), new Keyframe(0.45f, (Object)random.getX(), (Easing)Easing.easeOutQuint), new Keyframe(0.6f, (Object)random.getX(), (Easing)Easing.easeOutQuint), new Keyframe(1.0f, (Object)(bookIconMask.getSize().getX() / 2.0 - 8.0), (Easing)Easing.easeInOutQuint)});
                KeyframeAnimation animY = new KeyframeAnimation((Object)fakeModule, "pos.y");
                animY.setDuration(dur);
                animY.setKeyframes(new Keyframe[]{new Keyframe(delay, (Object)fakeModule.getPos().getY(), (Easing)Easing.easeOutQuint), new Keyframe(0.45f, (Object)random.getY(), (Easing)Easing.easeOutQuint), new Keyframe(0.6f, (Object)random.getY(), (Easing)Easing.easeOutQuint), new Keyframe(1.0f, (Object)(-(bookIconMask.getSize().getY() / 2.0) - 4.0), (Easing)Easing.easeInOutQuint)});
                BasicAnimation animRadius = new BasicAnimation((Object)fakeModule, "radius");
                animRadius.setDuration(20.0f);
                animRadius.setEasing((Easing)Easing.easeOutCubic);
                animRadius.setTo((Object)0);
                BasicAnimation animText = new BasicAnimation((Object)fakeModule, "textRadius");
                animText.setDuration(40.0f);
                animText.setEasing((Easing)Easing.easeOutCubic);
                animText.setTo((Object)0);
                animY.setCompletion(() -> ((TableModule)fakeModule).invalidate());
                fakeModule.add(new Animation[]{animX, animY, animSound1, animSound2, animRadius, animText});
            }
        };
        if (this.selectedModule != null) {
            this.selectedModule = null;
            this.getMainComponents().add(new Animation[]{new ScheduledEventAnimation(5.0f, runnable)});
        } else {
            runnable.run();
        }
    }

    public void playClearAnimation(@Nullable Runnable finish) {
        this.animationPlaying = true;
        if (this.selectedModule != null) {
            Vec2d toSize = new Vec2d(16.0, 16.0);
            BasicAnimation animSize = new BasicAnimation((Object)this.selectedModule, "size");
            animSize.setDuration(5.0f);
            animSize.setEasing((Easing)Easing.easeOutCubic);
            animSize.setTo((Object)toSize);
            this.selectedModule.add(new Animation[]{animSize});
            BasicAnimation animPos = new BasicAnimation((Object)this.selectedModule, "pos");
            animPos.setDuration(5.0f);
            animPos.setEasing((Easing)Easing.easeOutCubic);
            animPos.setTo((Object)this.selectedModule.getPos().add(this.selectedModule.getSize().sub(toSize).mul(0.5)));
            this.selectedModule.add(new Animation[]{animPos});
        }
        Runnable runnable = () -> {
            ScheduledEventAnimation animFinish = new ScheduledEventAnimation(110.0f, () -> {
                if (finish == null) {
                    this.animationPlaying = false;
                    this.syncToServer();
                } else {
                    finish.run();
                }
            });
            this.paper.add(new Animation[]{animFinish});
            for (GuiComponent component : this.paper.getChildren()) {
                if (!(component instanceof TableModule)) continue;
                TableModule module = (TableModule)component;
                Vec2d random = module.getPos().add(RandUtil.nextDouble(-20.0, 20.0), RandUtil.nextDouble(-20.0, 20.0));
                float delay = RandUtil.nextFloat(0.2f, 0.3f);
                float dur = RandUtil.nextFloat(70.0f, 100.0f);
                BasicAnimation animRadius = new BasicAnimation((Object)module, "radius");
                animRadius.setDuration(20.0f);
                animRadius.setEasing((Easing)Easing.easeOutCubic);
                animRadius.setTo((Object)0);
                BasicAnimation animText = new BasicAnimation((Object)module, "textRadius");
                animText.setDuration(40.0f);
                animText.setEasing((Easing)Easing.easeOutCubic);
                animText.setTo((Object)0);
                ScheduledEventAnimation animSound1 = new ScheduledEventAnimation(dur * delay, () -> Minecraft.func_71410_x().field_71439_g.func_184185_a((SoundEvent)ModSounds.POP, 1.0f, 1.0f));
                KeyframeAnimation animX = new KeyframeAnimation((Object)module, "pos.x");
                animX.setDuration(dur);
                animX.setKeyframes(new Keyframe[]{new Keyframe(delay, (Object)module.getPos().getX(), (Easing)Easing.easeOutQuint), new Keyframe(0.45f, (Object)random.getX(), (Easing)Easing.easeOutQuint), new Keyframe(0.6f, (Object)random.getX(), (Easing)Easing.easeOutQuint), new Keyframe(1.0f, (Object)(random.getX() + RandUtil.nextDouble(-10.0, 10.0)), (Easing)Easing.easeInOutQuint)});
                KeyframeAnimation animY = new KeyframeAnimation((Object)module, "pos.y");
                animY.setDuration(dur);
                animY.setKeyframes(new Keyframe[]{new Keyframe(delay, (Object)module.getPos().getY(), (Easing)Easing.easeOutQuint), new Keyframe(0.45f, (Object)random.getY(), (Easing)Easing.easeOutQuint), new Keyframe(0.6f, (Object)random.getY(), (Easing)Easing.easeOutQuint), new Keyframe(1.0f, (Object)(this.field_146295_m + 100), (Easing)Easing.easeInOutQuint)});
                animY.setCompletion(() -> {
                    module.invalidate();
                    Minecraft.func_71410_x().field_71439_g.func_184185_a((SoundEvent)ModSounds.ZOOM, 1.0f, 1.0f);
                });
                module.add(new Animation[]{animX, animY, animSound1, animRadius, animText});
            }
        };
        if (this.selectedModule != null) {
            this.selectedModule = null;
            this.getMainComponents().add(new Animation[]{new ScheduledEventAnimation(5.0f, runnable)});
        } else {
            runnable.run();
        }
    }

    public void playLoadAnimation(Set<CommonWorktableModule> commonModules, @Nullable Runnable finish) {
        this.animationPlaying = true;
        if (this.selectedModule != null) {
            Vec2d toSize = new Vec2d(16.0, 16.0);
            BasicAnimation animSize = new BasicAnimation((Object)this.selectedModule, "size");
            animSize.setDuration(5.0f);
            animSize.setEasing((Easing)Easing.easeOutCubic);
            animSize.setTo((Object)toSize);
            this.selectedModule.add(new Animation[]{animSize});
            BasicAnimation animPos = new BasicAnimation((Object)this.selectedModule, "pos");
            animPos.setDuration(5.0f);
            animPos.setEasing((Easing)Easing.easeOutCubic);
            animPos.setTo((Object)this.selectedModule.getPos().add(this.selectedModule.getSize().sub(toSize).mul(0.5)));
            this.selectedModule.add(new Animation[]{animPos});
        }
        ComponentVoid bookIconMask = new ComponentVoid(0, -100, 180, 100);
        this.paper.add(new GuiComponent[]{bookIconMask});
        Vec2d bookOrigin = new Vec2d(bookIconMask.getSize().getX() / 2.0 - 8.0, -(bookIconMask.getSize().getY() / 2.0) - 4.0);
        Runnable itemsRunnable = () -> {
            Iterator iterator = commonModules.iterator();
            while (iterator.hasNext()) {
                CommonWorktableModule commonHead;
                CommonWorktableModule commonModule = commonHead = (CommonWorktableModule)iterator.next();
                TableModule lastModule = new TableModule(this, commonHead.module, true, false);
                lastModule.setPos(commonHead.pos);
                while (commonModule != null) {
                    this.paper.add(new GuiComponent[]{lastModule});
                    DragMixin drag = new DragMixin((GuiComponent)lastModule, vec2d -> vec2d);
                    drag.setDragOffset(new Vec2d(6.0, 6.0));
                    lastModule.setData(Vec2d.class, "true_pos", commonModule.pos);
                    for (ModuleInstanceModifier modifier : commonModule.modifiers.keySet()) {
                        lastModule.setData(Integer.class, modifier.getSubModuleID(), commonModule.modifiers.get(modifier));
                    }
                    lastModule.radius = 0.0f;
                    lastModule.textRadius = 0.0f;
                    if (commonModule.linksTo != null) {
                        TableModule childModule = new TableModule(this, commonModule.linksTo.module, true, false);
                        childModule.setPos(bookOrigin);
                        lastModule.setLinksTo(childModule);
                        lastModule = childModule;
                    }
                    commonModule = commonModule.linksTo;
                }
            }
            for (GuiComponent component : this.paper.getChildren()) {
                if (!(component instanceof TableModule)) continue;
                TableModule module = (TableModule)component;
                Vec2d target = (Vec2d)module.getData(Vec2d.class, "true_pos");
                if (target == null) {
                    module.invalidate();
                    continue;
                }
                Vec2d randGen = new Vec2d(RandUtil.nextDouble(-100.0, 100.0), RandUtil.nextDouble(-100.0, 100.0));
                Vec2d random = bookOrigin.add(randGen);
                float delay = RandUtil.nextFloat(0.2f, 0.3f);
                float dur = RandUtil.nextFloat(70.0f, 100.0f);
                ScheduledEventAnimation animSound1 = new ScheduledEventAnimation(dur * delay, () -> Minecraft.func_71410_x().field_71439_g.func_184185_a((SoundEvent)ModSounds.WHOOSH, 1.0f, 1.0f));
                KeyframeAnimation animX = new KeyframeAnimation((Object)module, "pos.x");
                animX.setDuration(dur);
                animX.setKeyframes(new Keyframe[]{new Keyframe(delay, (Object)bookOrigin.getX(), (Easing)Easing.easeOutQuint), new Keyframe(0.5f, (Object)random.getX(), (Easing)Easing.easeOutQuint), new Keyframe(0.6f, (Object)random.getX(), (Easing)Easing.easeOutQuint), new Keyframe(1.0f, (Object)target.getX(), (Easing)Easing.easeOutQuint)});
                KeyframeAnimation animY = new KeyframeAnimation((Object)module, "pos.y");
                animY.setDuration(dur);
                animY.setKeyframes(new Keyframe[]{new Keyframe(delay, (Object)bookOrigin.getY(), (Easing)Easing.easeOutQuint), new Keyframe(0.5f, (Object)random.getY(), (Easing)Easing.easeOutQuint), new Keyframe(0.6f, (Object)random.getY(), (Easing)Easing.easeOutQuint), new Keyframe(1.0f, (Object)target.getY(), (Easing)Easing.easeOutQuint)});
                animY.setCompletion(() -> {
                    BasicAnimation animRadius = new BasicAnimation((Object)module, "radius");
                    animRadius.setDuration(20.0f);
                    animRadius.setEasing((Easing)Easing.easeOutCubic);
                    animRadius.setTo((Object)10);
                    module.add(new Animation[]{animRadius});
                    BasicAnimation animText = new BasicAnimation((Object)module, "textRadius");
                    animText.setDuration(40.0f);
                    animText.setEasing((Easing)Easing.easeOutCubic);
                    animText.setTo((Object)0);
                    module.add(new Animation[]{animText});
                });
                module.add(new Animation[]{animX, animY, animSound1});
            }
        };
        Runnable runnable = () -> {
            ComponentRect grayBackground = new ComponentRect(0, 0, this.tableComponent.getSize().getXi(), this.tableComponent.getSize().getYi());
            grayBackground.getColor().setValue((Object)new Color(0.05f, 0.05f, 0.05f, 0.0f));
            grayBackground.getTransform().setTranslateZ(200.0);
            grayBackground.BUS.hook(GuiComponentEvents.ComponentTickEvent.class, event -> grayBackground.getColor().setValue((Object)new Color(0.05f, 0.05f, 0.05f, this.backgroundAlpha)));
            KeyframeAnimation anim = new KeyframeAnimation((Object)this, "backgroundAlpha");
            anim.setDuration(100.0f);
            anim.setKeyframes(new Keyframe[]{new Keyframe(0.0f, (Object)Float.valueOf(0.0f), (Easing)Easing.easeInOutQuint), new Keyframe(0.2f, (Object)Float.valueOf(0.65f), (Easing)Easing.easeInOutQuint), new Keyframe(0.7f, (Object)Float.valueOf(0.65f), (Easing)Easing.easeInOutQuint), new Keyframe(1.0f, (Object)Float.valueOf(0.0f), (Easing)Easing.easeInOutQuint)});
            anim.setCompletion(() -> ((ComponentRect)grayBackground).invalidate());
            ComponentSprite bookIcon = new ComponentSprite((ISprite)BOOK_ICON, (int)(bookIconMask.getSize().getX() / 2.0 - 16.0), (int)(bookIconMask.getSize().getY() + 50.0), 32, 32);
            bookIconMask.add(new GuiComponent[]{bookIcon});
            bookIcon.getTransform().setTranslateZ(200.0);
            bookIconMask.clipping.setClipToBounds(true);
            bookIconMask.getTransform().setTranslateZ(250.0);
            Vec2d originalPos = bookIcon.getPos();
            KeyframeAnimation anim2 = new KeyframeAnimation((Object)bookIcon, "pos.y");
            anim2.setDuration(120.0f);
            anim2.setKeyframes(new Keyframe[]{new Keyframe(0.0f, (Object)originalPos.getY(), Easing.linear), new Keyframe(0.4f, (Object)(bookIconMask.getSize().getY() / 2.0 - 25.0), (Easing)Easing.easeInBack), new Keyframe(0.5f, (Object)(bookIconMask.getSize().getY() / 2.0 - 10.0), (Easing)Easing.easeOutBack), new Keyframe(0.8f, (Object)(bookIconMask.getSize().getY() / 2.0 - 10.0), (Easing)Easing.easeInBack), new Keyframe(1.0f, (Object)originalPos.getY(), (Easing)Easing.easeInBack)});
            ScheduledEventAnimation animSound = new ScheduledEventAnimation(48.0f, () -> {
                Minecraft.func_71410_x().field_71439_g.func_184185_a((SoundEvent)ModSounds.WHOOSH, 1.0f, 1.0f);
                itemsRunnable.run();
                ScheduledEventAnimation animFinish = new ScheduledEventAnimation(100.0f, () -> {
                    bookIcon.invalidate();
                    if (finish == null) {
                        this.animationPlaying = false;
                    } else {
                        finish.run();
                    }
                });
                this.getMainComponents().add(new Animation[]{animFinish});
            });
            bookIcon.add(new Animation[]{anim2, animSound});
        };
        if (this.selectedModule != null) {
            this.selectedModule = null;
            this.getMainComponents().add(new Animation[]{new ScheduledEventAnimation(5.0f, runnable)});
        } else {
            runnable.run();
        }
    }

    public boolean func_73868_f() {
        return false;
    }
}

