/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.wizardry.client.core.renderer;

import com.teamwizardry.librarianlib.features.forgeevents.CustomWorldRenderEvent;
import com.teamwizardry.wizardry.api.item.ICooldown;
import com.teamwizardry.wizardry.api.spell.SpellData;
import com.teamwizardry.wizardry.api.spell.SpellRing;
import com.teamwizardry.wizardry.api.spell.SpellUtils;
import com.teamwizardry.wizardry.api.spell.module.ModuleInstance;
import com.teamwizardry.wizardry.init.ModItems;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber(modid="wizardry", value={Side.CLIENT})
public class SpellVisualizationRenderer {
    private static HashMap<ModuleInstance, SpellData> previousTickCache = new HashMap();

    @SubscribeEvent
    public static void tickDisplay(CustomWorldRenderEvent event) {
        if (Minecraft.func_71410_x().field_71439_g == null) {
            return;
        }
        if (Minecraft.func_71410_x().field_71441_e == null) {
            return;
        }
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        ItemStack hand = player.func_184614_ca();
        if (hand.func_190926_b() || hand.func_77973_b() != ModItems.STAFF) {
            return;
        }
        if (hand.func_77973_b() instanceof ICooldown && ((ICooldown)hand.func_77973_b()).isCoolingDown((World)world, hand)) {
            return;
        }
        List<SpellRing> chains = SpellUtils.getSpellChains(hand);
        HashSet<ModuleInstance> untransientModules = new HashSet<ModuleInstance>();
        for (SpellRing chain : chains) {
            SpellData data = new SpellData((World)world);
            data.processEntity((Entity)player, true);
            for (SpellRing ring = chain; ring != null; ring = ring.getChildRing()) {
                if (ring.getModule() == null) continue;
                if (previousTickCache.containsKey(ring.getModule())) {
                    untransientModules.add(ring.getModule());
                    SpellData oldTickData = previousTickCache.get(ring.getModule());
                    SpellData newTickData = ring.getModule().renderVisualization(data, ring, oldTickData);
                    if (newTickData == oldTickData) continue;
                    previousTickCache.put(ring.getModule(), newTickData);
                    continue;
                }
                SpellData newTickData = ring.getModule().renderVisualization(data, ring, new SpellData((World)world));
                previousTickCache.put(ring.getModule(), newTickData);
            }
        }
        HashSet<ModuleInstance> tmp = new HashSet<ModuleInstance>(previousTickCache.keySet());
        for (ModuleInstance module : tmp) {
            if (untransientModules.contains(module)) continue;
            previousTickCache.remove(module);
        }
    }
}

