/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.wizardry.client.core.renderer;

import com.teamwizardry.librarianlib.core.client.ClientTickHandler;
import com.teamwizardry.librarianlib.features.sprite.Sprite;
import com.teamwizardry.librarianlib.features.sprite.Texture;
import com.teamwizardry.wizardry.api.capability.mana.CapManager;
import com.teamwizardry.wizardry.api.item.BaublesSupport;
import com.teamwizardry.wizardry.init.ModItems;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber(modid="wizardry", value={Side.CLIENT})
public class HudRenderer {
    private static final Texture HUD_TEXTURE = new Texture(new ResourceLocation("wizardry", "textures/gui/hud.png"));
    private static final Sprite emptyManaBar = HUD_TEXTURE.getSprite("mana_empty", 101, 5);
    private static final Sprite fullManaBar = HUD_TEXTURE.getSprite("mana_full", 101, 5);
    private static final Sprite emptyBurnoutBar = HUD_TEXTURE.getSprite("burnout_empty", 101, 5);
    private static final Sprite fullBurnoutBar = HUD_TEXTURE.getSprite("burnout_full", 101, 5);

    @SubscribeEvent
    public static void renderHud(RenderGameOverlayEvent.Post event) {
        ScaledResolution resolution = event.getResolution();
        int width = resolution.func_78326_a();
        int height = resolution.func_78328_b();
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        ItemStack stack = BaublesSupport.getItem((EntityLivingBase)player, ModItems.FAKE_HALO, ModItems.CREATIVE_HALO, ModItems.REAL_HALO);
        if (stack == null || stack.func_190926_b()) {
            return;
        }
        if (event.getType() == RenderGameOverlayEvent.ElementType.EXPERIENCE) {
            HUD_TEXTURE.bind();
            GlStateManager.func_179094_E();
            GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
            int barSide = Minecraft.func_71410_x().field_71474_y.field_186715_A == EnumHandSide.RIGHT ? 1 : -1;
            int right = width / 2 - 50 + 155 * barSide;
            int top = height - 17;
            emptyManaBar.draw(ClientTickHandler.getTicks(), (float)right, (float)top);
            emptyBurnoutBar.draw(ClientTickHandler.getTicks(), (float)right, (float)(top + 6));
            GlStateManager.func_179121_F();
            try (CapManager.CapManagerBuilder mgr = CapManager.forObject((Entity)player);){
                double mana = mgr.getMana();
                double burnout = mgr.getBurnout();
                double maxMana = mgr.getMaxMana();
                double maxBurnout = mgr.getMaxBurnout();
                GlStateManager.func_179094_E();
                GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
                int visualManaLength = 0;
                if (mana > 0.0) {
                    visualManaLength = (int)(mana * 100.0 / maxMana % 101.0);
                }
                fullManaBar.drawClipped(ClientTickHandler.getTicks(), (float)right, (float)top, visualManaLength, 5);
                GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
                int visualBurnoutLength = 0;
                if (burnout > 0.0) {
                    visualBurnoutLength = (int)(burnout * 100.0 / maxBurnout % 101.0);
                }
                fullBurnoutBar.drawClipped(ClientTickHandler.getTicks(), (float)right, (float)(top + 6), visualBurnoutLength, 5);
                GlStateManager.func_179121_F();
            }
        }
    }
}

