/*
 * Decompiled with CFR 0.152.
 */
package com.pau101.fairylights.server.fastener.connection.type;

import com.google.common.base.MoreObjects;
import com.pau101.fairylights.server.fastener.Fastener;
import com.pau101.fairylights.server.fastener.connection.Catenary;
import com.pau101.fairylights.server.fastener.connection.Feature;
import com.pau101.fairylights.server.fastener.connection.FeatureType;
import com.pau101.fairylights.server.fastener.connection.Segment;
import com.pau101.fairylights.server.fastener.connection.collision.Collidable;
import com.pau101.fairylights.server.fastener.connection.collision.FeatureCollisionTree;
import com.pau101.fairylights.server.fastener.connection.type.Connection;
import com.pau101.fairylights.util.AABBBuilder;
import com.pau101.fairylights.util.Mth;
import com.pau101.fairylights.util.matrix.Matrix;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public abstract class ConnectionHangingFeature<F extends HangingFeature>
extends Connection {
    protected static final FeatureType FEATURE = FeatureType.create("feature");
    protected F[] features = this.createFeatures(0);
    @Nullable
    protected F[] prevFeatures;

    public ConnectionHangingFeature(World world, Fastener<?> fastener, UUID uuid, Fastener<?> destination, boolean isOrigin, NBTTagCompound compound) {
        super(world, fastener, uuid, destination, isOrigin, compound);
    }

    public ConnectionHangingFeature(World world, Fastener<?> fastener, UUID uuid) {
        super(world, fastener, uuid);
    }

    public final F[] getFeatures() {
        return this.features;
    }

    public final F[] getPrevFeatures() {
        return (HangingFeature[])MoreObjects.firstNonNull(this.prevFeatures, this.features);
    }

    @Override
    protected void updatePrev() {
        this.prevFeatures = this.features;
    }

    @Override
    protected void onCalculateCatenary() {
        this.updateFeatures();
    }

    protected void updateFeatures() {
        Catenary catenary = this.getCatenary();
        float spacing = this.getFeatureSpacing();
        float totalLength = catenary.getLength();
        float distance = (totalLength % spacing + spacing) / 2.0f;
        Segment[] segments = catenary.getSegments();
        this.prevFeatures = this.features;
        ArrayList<F> features = new ArrayList<F>((int)(totalLength / spacing));
        this.onBeforeUpdateFeatures(features.size());
        boolean hasPrevLights = this.prevFeatures != null;
        int index = 0;
        for (int i = 0; i < segments.length; ++i) {
            Segment segment = segments[i];
            double length = segment.getLength();
            while ((double)distance < length) {
                F feature = this.createFeature(index, segment.pointAt((double)distance / length), segment.getRotation());
                if (hasPrevLights && index < this.prevFeatures.length) {
                    ((HangingFeature)feature).inherit(this.prevFeatures[index]);
                }
                features.add(feature);
                distance += spacing;
                ++index;
            }
            distance = (float)((double)distance - length);
        }
        this.features = features.toArray(this.createFeatures(features.size()));
        this.onAfterUpdateFeatures(index);
    }

    protected abstract F[] createFeatures(int var1);

    protected abstract F createFeature(int var1, Vec3d var2, Vec3d var3);

    protected abstract float getFeatureSpacing();

    protected void onBeforeUpdateFeatures(int size) {
    }

    protected void onAfterUpdateFeatures(int size) {
    }

    @Override
    public void addCollision(List<Collidable> collision, Vec3d origin) {
        super.addCollision(collision, origin);
        if (this.features.length > 0) {
            Matrix matrix = new Matrix();
            collision.add(FeatureCollisionTree.build((FeatureType)FEATURE, this.features, f -> {
                Vec3d[] verts;
                Vec3d pos = f.getPoint();
                double x = origin.field_72450_a + pos.field_72450_a / 16.0;
                double y = origin.field_72448_b + pos.field_72448_b / 16.0;
                double z = origin.field_72449_c + pos.field_72449_c / 16.0;
                double w = f.getWidth() / 2.0;
                double h = f.getHeight();
                matrix.push();
                Vec3d rot = f.getRotation();
                if (f.parallelsCord()) {
                    matrix.rotate(rot.field_72450_a, 0.0, 1.0, 0.0);
                    matrix.rotate(rot.field_72448_b, 1.0, 0.0, 0.0);
                }
                matrix.translate(0.0, 0.025, 0.0);
                AABBBuilder bounds = new AABBBuilder();
                for (Vec3d vert : verts = new Vec3d[]{new Vec3d(-w, -h, -w), new Vec3d(w, -h, -w), new Vec3d(w, -h, w), new Vec3d(-w, -h, w), new Vec3d(-w, 0.0, -w), new Vec3d(w, 0.0, -w), new Vec3d(w, 0.0, w), new Vec3d(-w, 0.0, w)}) {
                    bounds.include(matrix.transform(vert));
                }
                matrix.pop();
                return bounds.add(x, y, z).build();
            }));
        }
    }

    public static abstract class HangingFeature<F extends HangingFeature<F>>
    implements Feature {
        protected final int index;
        protected final Vec3d point;
        protected Vec3d rotation;
        protected Vec3d prevRotation;

        public HangingFeature(int index, Vec3d point, Vec3d rotation) {
            this.index = index;
            this.point = point;
            this.prevRotation = this.rotation = rotation;
        }

        @Override
        public final int getId() {
            return this.index;
        }

        public final Vec3d getPoint() {
            return this.point;
        }

        public final Vec3d getRotation() {
            return this.rotation;
        }

        public final Vec3d getRotation(float t) {
            return Mth.lerpAngles(this.prevRotation, this.rotation, t);
        }

        public final Vec3d getAbsolutePoint(Fastener<?> fastener) {
            return this.point.func_186678_a(0.0625).func_178787_e(fastener.getConnectionPoint());
        }

        public void inherit(F feature) {
            this.prevRotation = ((HangingFeature)feature).rotation;
        }

        public abstract double getWidth();

        public abstract double getHeight();

        public abstract boolean parallelsCord();
    }
}

