/*
 * Decompiled with CFR 0.152.
 */
package com.pau101.fairylights.server.fastener.connection.type;

import com.google.common.base.MoreObjects;
import com.pau101.fairylights.FairyLights;
import com.pau101.fairylights.server.fastener.Fastener;
import com.pau101.fairylights.server.fastener.FastenerType;
import com.pau101.fairylights.server.fastener.accessor.FastenerAccessor;
import com.pau101.fairylights.server.fastener.connection.Catenary;
import com.pau101.fairylights.server.fastener.connection.ConnectionType;
import com.pau101.fairylights.server.fastener.connection.Feature;
import com.pau101.fairylights.server.fastener.connection.FeatureType;
import com.pau101.fairylights.server.fastener.connection.PlayerAction;
import com.pau101.fairylights.server.fastener.connection.collision.Collidable;
import com.pau101.fairylights.server.fastener.connection.collision.ConnectionCollision;
import com.pau101.fairylights.server.fastener.connection.collision.FeatureCollisionTree;
import com.pau101.fairylights.server.fastener.connection.collision.Intersection;
import com.pau101.fairylights.server.item.ItemConnection;
import com.pau101.fairylights.server.net.serverbound.MessageConnectionInteraction;
import com.pau101.fairylights.server.sound.FLSounds;
import com.pau101.fairylights.util.CubicBezier;
import com.pau101.fairylights.util.NBTSerializable;
import com.pau101.fairylights.util.OreDictUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public abstract class Connection
implements NBTSerializable {
    public static final int MAX_LENGTH = 32;
    public static final double PULL_RANGE = 5.0;
    public static final FeatureType CORD_FEATURE = FeatureType.create("cord");
    private static final CubicBezier SLACK_CURVE = new CubicBezier(0.495f, 0.505f, 0.495f, 0.505f);
    private static final float MAX_SLACK = 3.0f;
    protected final Fastener<?> fastener;
    private final UUID uuid;
    private FastenerAccessor destination;
    protected World world;
    private boolean isOrigin;
    @Nullable
    private Catenary catenary;
    @Nullable
    private Catenary prevCatenary;
    protected float slack = 1.0f;
    private final ConnectionCollision collision = new ConnectionCollision();
    private boolean updateCatenary;
    private boolean catenaryUpdateState;
    protected boolean dataUpdateState;
    public boolean forceRemove;
    private int prevStretchStage;
    private boolean removed;
    @Nullable
    private List<Runnable> removeListeners;

    public Connection(World world, Fastener<?> fastener, UUID uuid, Fastener<?> destination, boolean isOrigin, NBTTagCompound compound) {
        this(world, fastener, uuid);
        this.destination = destination.createAccessor();
        this.isOrigin = isOrigin;
        this.deserializeLogic(compound);
    }

    public Connection(World world, Fastener<?> fastener, UUID uuid) {
        this.world = world;
        this.fastener = fastener;
        this.uuid = uuid;
        this.computeCatenary();
    }

    @Nullable
    public final Catenary getCatenary() {
        return this.catenary;
    }

    @Nullable
    public final Catenary getPrevCatenary() {
        return this.prevCatenary == null ? this.catenary : this.prevCatenary;
    }

    public void setWorld(World world) {
        this.world = world;
    }

    public final World getWorld() {
        return this.world;
    }

    public final boolean isOrigin() {
        return this.isOrigin;
    }

    public final ConnectionCollision getCollision() {
        return this.collision;
    }

    public final Fastener<?> getFastener() {
        return this.fastener;
    }

    public final UUID getUUID() {
        return this.uuid;
    }

    public final void setDestination(Fastener<?> destination) {
        this.destination = destination.createAccessor();
        this.computeCatenary();
    }

    public final FastenerAccessor getDestination() {
        return this.destination;
    }

    public boolean isDestination(FastenerAccessor location) {
        return this.destination.equals(location);
    }

    public boolean shouldDrop() {
        return this.fastener.shouldDropConnection() && this.destination.isLoaded(this.world) && this.destination.get(this.world).shouldDropConnection();
    }

    public boolean shouldDisconnect() {
        return !this.destination.exists(this.world) || this.forceRemove;
    }

    public ItemStack getItemStack() {
        ItemStack stack = new ItemStack((Item)this.getType().getItem());
        NBTTagCompound tagCompound = this.serializeLogic();
        if (!tagCompound.func_82582_d()) {
            stack.func_77982_d(tagCompound);
        }
        return stack;
    }

    public float getRadius() {
        return 0.0625f;
    }

    public final boolean isDynamic() {
        if (this.destination.isLoaded(this.world)) {
            return this.isDynamic(this.destination.get(this.world));
        }
        return this.fastener.isDynamic();
    }

    private boolean isDynamic(Fastener<?> to) {
        return this.fastener.isDynamic() || to.isDynamic();
    }

    public final boolean isModifiable(EntityPlayer player) {
        return this.world.func_175660_a(player, this.fastener.getPos());
    }

    public final void addRemoveListener(Runnable listener) {
        if (this.removeListeners == null) {
            this.removeListeners = new ArrayList<Runnable>();
        }
        this.removeListeners.add(listener);
    }

    public final void remove() {
        if (!this.removed) {
            this.removed = true;
            this.onRemove();
            if (this.removeListeners != null) {
                this.removeListeners.forEach(Runnable::run);
            }
        }
    }

    public void computeCatenary() {
        this.dataUpdateState = true;
        this.updateCatenary = true;
    }

    public void processClientAction(EntityPlayer player, PlayerAction action, Intersection intersection) {
        FairyLights.network.sendToServer((IMessage)new MessageConnectionInteraction(this, action, intersection));
    }

    public void disconnect(EntityPlayer player, Vec3d hit) {
        if (!this.destination.isLoaded(this.world)) {
            return;
        }
        this.fastener.removeConnection(this);
        this.destination.get(this.world).removeConnection(this.uuid);
        if (this.shouldDrop()) {
            ItemStack stack = this.getItemStack();
            EntityItem item = new EntityItem(this.world, hit.field_72450_a, hit.field_72448_b, hit.field_72449_c, stack);
            float scale = 0.05f;
            item.field_70159_w = this.world.field_73012_v.nextGaussian() * (double)scale;
            item.field_70181_x = this.world.field_73012_v.nextGaussian() * (double)scale + (double)0.2f;
            item.field_70179_y = this.world.field_73012_v.nextGaussian() * (double)scale;
            this.world.func_72838_d((Entity)item);
        }
        this.world.func_184148_a(null, hit.field_72450_a, hit.field_72448_b, hit.field_72449_c, FLSounds.CORD_DISCONNECT, SoundCategory.BLOCKS, 1.0f, 1.0f);
    }

    public boolean interact(EntityPlayer player, Vec3d hit, FeatureType featureType, int feature, ItemStack heldStack, EnumHand hand) {
        Item item = heldStack.func_77973_b();
        if (item instanceof ItemConnection) {
            if (this.destination.isLoaded(this.world)) {
                this.replace(player, hit, heldStack);
                return true;
            }
        } else if (OreDictUtils.matches(heldStack, "string") ? this.slacken(hit, heldStack, 0.2f) : OreDictUtils.matches(heldStack, "stickWood") && this.slacken(hit, heldStack, -0.2f)) {
            return true;
        }
        return false;
    }

    private void replace(EntityPlayer player, Vec3d hit, ItemStack heldStack) {
        Fastener<?> dest = this.destination.get(this.world);
        this.fastener.removeConnectionImmediately(this);
        dest.removeConnectionImmediately(this.uuid);
        if (this.shouldDrop()) {
            player.field_71071_by.func_70441_a(this.getItemStack());
        }
        NBTTagCompound data = (NBTTagCompound)MoreObjects.firstNonNull((Object)heldStack.func_77978_p(), (Object)new NBTTagCompound());
        ConnectionType type = ((ItemConnection)heldStack.func_77973_b()).getConnectionType();
        this.fastener.connectWith(this.world, dest, type, data).onConnect(player.field_70170_p, player, heldStack);
        heldStack.func_190918_g(1);
        this.world.func_184148_a(null, hit.field_72450_a, hit.field_72448_b, hit.field_72449_c, FLSounds.CORD_CONNECT, SoundCategory.BLOCKS, 1.0f, 1.0f);
    }

    private boolean slacken(Vec3d hit, ItemStack heldStack, float amount) {
        if (this.slack <= 0.0f && amount < 0.0f || this.slack >= 3.0f && amount > 0.0f) {
            return false;
        }
        this.slack = MathHelper.func_76131_a((float)(this.slack + amount), (float)0.0f, (float)3.0f);
        if (this.slack < 0.01f) {
            this.slack = 0.0f;
        }
        this.dataUpdateState = true;
        this.world.func_184148_a(null, hit.field_72450_a, hit.field_72448_b, hit.field_72449_c, FLSounds.CORD_STRETCH, SoundCategory.BLOCKS, 1.0f, 0.8f + (3.0f - this.slack) * 0.4f);
        return true;
    }

    public void onConnect(World world, EntityPlayer user, ItemStack heldStack) {
    }

    protected void onRemove() {
    }

    protected void updatePrev() {
    }

    protected void onUpdateEarly() {
    }

    protected void onUpdateLate() {
    }

    protected void onCalculateCatenary() {
    }

    public abstract ConnectionType getType();

    public final void update(Vec3d from) {
        this.prevCatenary = this.catenary;
        this.updatePrev();
        this.destination.update(this.world, this.fastener.getPos());
        if (this.destination.isLoaded(this.world)) {
            this.onUpdateEarly();
            Fastener<?> dest = this.destination.get(this.world);
            Vec3d point = dest.getConnectionPoint();
            this.updateCatenary(from, dest, point);
            double dist = point.func_72438_d(from);
            double pull = dist - 32.0 + 5.0;
            if (pull > 0.0) {
                int stage = (int)(pull + (double)0.1f);
                if (stage > this.prevStretchStage) {
                    this.world.func_184148_a(null, point.field_72450_a, point.field_72448_b, point.field_72449_c, FLSounds.CORD_STRETCH, SoundCategory.BLOCKS, 0.25f, 0.5f + (float)stage / 8.0f);
                }
                this.prevStretchStage = stage;
            }
            if (dist > 37.0) {
                this.world.func_184148_a(null, point.field_72450_a, point.field_72448_b, point.field_72449_c, FLSounds.CORD_SNAP, SoundCategory.BLOCKS, 0.75f, 0.8f + this.world.field_73012_v.nextFloat() * 0.3f);
                this.forceRemove = true;
            } else if (dest.isDynamic()) {
                dest.resistSnap(from);
            }
            this.onUpdateLate();
        }
    }

    public void updateCatenary(Vec3d from) {
        if (this.world.func_175667_e(this.fastener.getPos())) {
            this.destination.update(this.world, this.fastener.getPos());
            if (this.destination.isLoaded(this.world)) {
                Fastener<?> dest = this.destination.get(this.world);
                Vec3d point = dest.getConnectionPoint();
                this.updateCatenary(from, dest, point);
                this.updateCatenary = false;
            }
        }
    }

    private void updateCatenary(Vec3d from, Fastener<?> dest, Vec3d point) {
        if (this.updateCatenary || this.isDynamic(dest)) {
            Vec3d vec = point.func_178788_d(from);
            if (vec.func_72433_c() > 1.0E-6) {
                this.catenary = Catenary.from(vec, SLACK_CURVE, this.slack);
                this.onCalculateCatenary();
                this.collision.update(this, from);
            }
            this.catenaryUpdateState = true;
            this.updateCatenary = false;
        }
    }

    public final boolean pollCateneryUpdate() {
        boolean state = this.catenaryUpdateState;
        this.catenaryUpdateState = false;
        return state;
    }

    public final boolean pollDataUpdate() {
        boolean state = this.dataUpdateState;
        this.dataUpdateState = false;
        return state;
    }

    public void addCollision(List<Collidable> collision, Vec3d origin) {
        Feature[] segments = this.catenary.getSegments();
        float radius = this.getRadius();
        collision.add(FeatureCollisionTree.build((FeatureType)CORD_FEATURE, (Feature[])segments, s -> {
            Vec3d start = s.getStart();
            Vec3d end = s.getEnd();
            return new AxisAlignedBB(origin.field_72450_a + start.field_72450_a / 16.0, origin.field_72448_b + start.field_72448_b / 16.0, origin.field_72449_c + start.field_72449_c / 16.0, origin.field_72450_a + end.field_72450_a / 16.0, origin.field_72448_b + end.field_72448_b / 16.0, origin.field_72449_c + end.field_72449_c / 16.0).func_186662_g((double)radius);
        }, (int)1, (int)(segments.length - 2)));
    }

    @Override
    public NBTTagCompound serialize() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74757_a("isOrigin", this.isOrigin);
        compound.func_74782_a("destination", (NBTBase)FastenerType.serialize(this.destination));
        compound.func_74782_a("logic", (NBTBase)this.serializeLogic());
        compound.func_74776_a("slack", this.slack);
        return compound;
    }

    @Override
    public void deserialize(NBTTagCompound compound) {
        this.isOrigin = compound.func_74767_n("isOrigin");
        this.destination = FastenerType.deserialize(compound.func_74775_l("destination"));
        if (this.world != null) {
            this.destination.update(this.world, this.fastener.getPos());
        }
        this.deserializeLogic(compound.func_74775_l("logic"));
        this.slack = compound.func_150297_b("slack", 99) ? compound.func_74760_g("slack") : 1.0f;
        this.updateCatenary = true;
    }

    public NBTTagCompound serializeLogic() {
        return new NBTTagCompound();
    }

    public void deserializeLogic(NBTTagCompound compound) {
    }
}

