/*
 * Decompiled with CFR 0.152.
 */
package com.pau101.fairylights.client.midi;

import com.mojang.realmsclient.gui.ChatFormatting;
import com.pau101.fairylights.client.ClientEventHandler;
import com.pau101.fairylights.client.midi.MidiJingler;
import com.pau101.fairylights.server.fastener.Fastener;
import com.pau101.fairylights.server.fastener.accessor.FastenerAccessor;
import com.pau101.fairylights.server.fastener.connection.type.Connection;
import com.pau101.fairylights.server.fastener.connection.type.hanginglights.ConnectionHangingLights;
import com.pau101.fairylights.util.Utils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.annotation.Nullable;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiDeviceTransmitter;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Receiver;
import javax.sound.midi.Sequencer;
import javax.sound.midi.Transmitter;
import joptsimple.internal.Strings;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiChat;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.text.WordUtils;

public final class CommandJingler
extends CommandBase {
    private static final List<String> OPTIONS = Arrays.asList("open", "close", "list");
    private static final Set<MidiDevice> DEVICES = new HashSet<MidiDevice>();
    private static final Map<ConnectionHangingLights, List<MidiDeviceTransmitter>> TRANSMITTERS = new WeakHashMap<ConnectionHangingLights, List<MidiDeviceTransmitter>>();
    private static final Field CHAT_INPUT_FIELD = Utils.getFieldOfType(GuiChat.class, GuiTextField.class);
    @Nullable
    private static Thread shutdownCloser;

    public String func_71518_a(ICommandSender sender) {
        return "/jingler <open|close|list>";
    }

    public String func_71517_b() {
        return "jingler";
    }

    public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
        GuiScreen screen = Minecraft.func_71410_x().field_71462_r;
        if (screen instanceof GuiChat) {
            try {
                GuiTextField field = (GuiTextField)CHAT_INPUT_FIELD.get(screen);
                if (field.func_146179_b().startsWith("/jingler")) {
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return Thread.currentThread().getStackTrace()[2].getClassName().contains("forge");
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length < 1) {
            throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
        }
        String option = args[0];
        if ("open".equalsIgnoreCase(option)) {
            MidiDeviceTransmitter transmitter;
            if (args.length < 2) {
                throw new WrongUsageException("/jingler open <device name>", new Object[0]);
            }
            Connection connection = ClientEventHandler.getHitConnection();
            if (!(connection instanceof ConnectionHangingLights)) {
                throw new CommandException("Must be looking at hanging lights", new Object[0]);
            }
            ConnectionHangingLights hangingLights = (ConnectionHangingLights)connection;
            MidiDevice device = this.getDeviceFromArgs(args, 1);
            for (Transmitter transmitter2 : device.getTransmitters()) {
                Receiver rec = transmitter2.getReceiver();
                if (!(rec instanceof MidiJingler) || ((MidiJingler)rec).getConnection() != connection) continue;
                throw new CommandException("Device already connected", new Object[0]);
            }
            try {
                transmitter = this.toMidiDeviceTransmitter(device.getTransmitter(), device);
                if (!device.isOpen()) {
                    device.open();
                    this.trackDevice(device);
                }
            }
            catch (MidiUnavailableException e) {
                throw new CommandException("Unable to open connection", new Object[]{e});
            }
            List<MidiDeviceTransmitter> transmitters = TRANSMITTERS.get(connection);
            if (transmitters == null) {
                transmitters = new ArrayList<MidiDeviceTransmitter>();
                TRANSMITTERS.put(hangingLights, transmitters);
            }
            transmitters.add(transmitter);
            transmitter.setReceiver(new MidiJingler(hangingLights));
            hangingLights.addRemoveListener(new ConnectionRemoveListener(hangingLights));
            sender.func_145747_a((ITextComponent)new TextComponentString("Connection opened"));
        } else if ("close".equalsIgnoreCase(option)) {
            MidiDevice device = args.length == 1 ? null : this.getDeviceFromArgs(args, 1);
            Connection connection = ClientEventHandler.getHitConnection();
            int closed = 0;
            if (connection instanceof ConnectionHangingLights) {
                closed = this.closeTransmitters((ConnectionHangingLights)connection, device);
            } else {
                Iterator<List<MidiDeviceTransmitter>> iter = TRANSMITTERS.values().iterator();
                while (iter.hasNext()) {
                    List<MidiDeviceTransmitter> transmitters = iter.next();
                    closed += this.closeTransmitters(transmitters, device);
                    if (!transmitters.isEmpty()) continue;
                    iter.remove();
                }
            }
            StringBuilder msg = new StringBuilder();
            if (closed == 0) {
                msg.append("No");
            } else {
                msg.append(closed);
            }
            msg.append(" connection");
            if (closed != 1) {
                msg.append('s');
            }
            msg.append(" closed");
            if (closed > 0 && TRANSMITTERS.isEmpty()) {
                msg.append(", non remaining");
            }
            sender.func_145747_a((ITextComponent)new TextComponentString(msg.toString()));
        } else if ("list".equalsIgnoreCase(option)) {
            if (TRANSMITTERS.isEmpty()) {
                sender.func_145747_a((ITextComponent)new TextComponentString("No connections to list"));
            } else {
                ArrayList<ConnectionHangingLights> allConnections = new ArrayList<ConnectionHangingLights>(TRANSMITTERS.keySet());
                allConnections.sort(Comparator.comparingDouble(c -> sender.func_174791_d().func_72438_d(c.getFastener().getAbsolutePos())));
                HashMap<MidiDevice, List> deviceConnections = new HashMap<MidiDevice, List>();
                for (ConnectionHangingLights connection : allConnections) {
                    for (MidiDeviceTransmitter t : TRANSMITTERS.get(connection)) {
                        MidiDevice device = t.getMidiDevice();
                        deviceConnections.computeIfAbsent(device, k -> new ArrayList()).add(connection);
                    }
                }
                ArrayList devices = new ArrayList(deviceConnections.keySet());
                devices.sort(Comparator.comparing(d -> d.getDeviceInfo().getName()));
                for (MidiDevice device : devices) {
                    sender.func_145747_a((ITextComponent)new TextComponentString(ChatFormatting.GREEN + device.getDeviceInfo().getName()));
                    for (ConnectionHangingLights connection : (List)deviceConnections.get(device)) {
                        Fastener<?> fastener = connection.getFastener();
                        FastenerAccessor dest = connection.getDestination();
                        String destStr = dest.isLoaded(sender.func_130014_f_()) ? dest.get(sender.func_130014_f_()).toString() : "?";
                        sender.func_145747_a((ITextComponent)new TextComponentString(String.format("  Connection: %s to %s", fastener, destStr)));
                    }
                }
            }
        } else {
            throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
        }
    }

    private MidiDevice getDeviceFromArgs(String[] args, int n) throws CommandException {
        MidiDevice device = this.getDevice(this.getNoSpaceName(Strings.join((String[])Arrays.copyOfRange(args, n, args.length), (String)" ")));
        if (device == null) {
            throw new CommandException("Device not found", new Object[0]);
        }
        return device;
    }

    private void trackDevice(MidiDevice device) {
        DEVICES.add(device);
        if (shutdownCloser == null) {
            shutdownCloser = new Thread("MIDI Device Closer"){

                @Override
                public void run() {
                    DEVICES.forEach(MidiDevice::close);
                    DEVICES.clear();
                }
            };
            Runtime.getRuntime().addShutdownHook(shutdownCloser);
        }
    }

    private MidiDeviceTransmitter toMidiDeviceTransmitter(final Transmitter transmitter, final MidiDevice device) {
        if (transmitter instanceof MidiDeviceTransmitter) {
            return (MidiDeviceTransmitter)transmitter;
        }
        return new MidiDeviceTransmitter(){

            @Override
            public void setReceiver(Receiver receiver) {
                transmitter.setReceiver(receiver);
            }

            @Override
            public Receiver getReceiver() {
                return transmitter.getReceiver();
            }

            @Override
            public void close() {
                transmitter.close();
            }

            @Override
            public MidiDevice getMidiDevice() {
                return device;
            }
        };
    }

    private int closeTransmitters(ConnectionHangingLights connection, MidiDevice device) {
        int closed = 0;
        List<MidiDeviceTransmitter> transmitters = TRANSMITTERS.get(connection);
        if (transmitters != null) {
            closed = this.closeTransmitters(transmitters, device);
            if (transmitters.isEmpty()) {
                TRANSMITTERS.remove(connection);
            }
        }
        return closed;
    }

    private int closeTransmitters(List<MidiDeviceTransmitter> transmitters, MidiDevice device) {
        int closed;
        if (device == null) {
            closed = transmitters.size();
            transmitters.forEach(Transmitter::close);
            transmitters.clear();
        } else {
            closed = 0;
            Iterator<MidiDeviceTransmitter> iter = transmitters.iterator();
            while (iter.hasNext()) {
                MidiDeviceTransmitter t = iter.next();
                if (t.getMidiDevice() != device) continue;
                ++closed;
                t.close();
                iter.remove();
            }
        }
        return closed;
    }

    private MidiDevice getDevice(String name) {
        for (MidiDevice.Info info : MidiSystem.getMidiDeviceInfo()) {
            try {
                MidiDevice device = MidiSystem.getMidiDevice(info);
                if (!this.isUseableDevice(device) || !name.equals(this.getNoSpaceName(info.getName()))) continue;
                return device;
            }
            catch (MidiUnavailableException midiUnavailableException) {
                // empty catch block
            }
        }
        return null;
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos pos) {
        int len = args.length;
        if (len == 1) {
            return OPTIONS;
        }
        if (len == 2 && "open".equals(args[0]) || "close".equals(args[0])) {
            ArrayList<String> devices = new ArrayList<String>();
            for (MidiDevice.Info info : MidiSystem.getMidiDeviceInfo()) {
                try {
                    MidiDevice device = MidiSystem.getMidiDevice(info);
                    if (!this.shouldShowDevice(device)) continue;
                    devices.add(this.getNoSpaceName(info.getName()));
                }
                catch (MidiUnavailableException midiUnavailableException) {
                    // empty catch block
                }
            }
            return devices;
        }
        return Collections.EMPTY_LIST;
    }

    private String getNoSpaceName(String name) {
        return WordUtils.capitalize((String)StringUtils.normalizeSpace((String)name)).replace(" ", "");
    }

    private boolean shouldShowDevice(MidiDevice device) {
        return this.isUseableDevice(device) && !(device instanceof Sequencer);
    }

    private boolean isUseableDevice(MidiDevice device) {
        return device.getMaxTransmitters() != 0;
    }

    @SubscribeEvent
    public void load(WorldEvent.Load event) {
        this.closeAllTransmitters();
    }

    @SubscribeEvent
    public void unload(WorldEvent.Unload event) {
        this.closeAllTransmitters();
    }

    private void closeAllTransmitters() {
        Iterator<List<MidiDeviceTransmitter>> iter = TRANSMITTERS.values().iterator();
        while (iter.hasNext()) {
            this.closeTransmitters(iter.next(), null);
            iter.remove();
        }
    }

    private class ConnectionRemoveListener
    implements Runnable {
        private final ConnectionHangingLights connection;

        public ConnectionRemoveListener(ConnectionHangingLights connection) {
            this.connection = connection;
        }

        @Override
        public void run() {
            CommandJingler.this.closeTransmitters(this.connection, null);
        }

        public boolean equals(Object obj) {
            return obj instanceof ConnectionRemoveListener && ((ConnectionRemoveListener)obj).connection == this.connection;
        }

        public int hashCode() {
            return this.connection.hashCode();
        }
    }
}

