/*
 * Decompiled with CFR 0.152.
 */
package mcjty.xnet.init;

import mcjty.lib.base.ModBase;
import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.blocks.GenericBlock;
import mcjty.lib.builder.BaseBlockBuilder;
import mcjty.lib.builder.BlockFlags;
import mcjty.lib.builder.GenericBlockBuilder;
import mcjty.lib.builder.GenericBlockBuilderFactory;
import mcjty.lib.container.GenericContainer;
import mcjty.xnet.XNet;
import mcjty.xnet.blocks.cables.NetCableSetup;
import mcjty.xnet.blocks.controller.TileEntityController;
import mcjty.xnet.blocks.controller.gui.GuiController;
import mcjty.xnet.blocks.facade.FacadeBlock;
import mcjty.xnet.blocks.redstoneproxy.RedstoneProxyBlock;
import mcjty.xnet.blocks.redstoneproxy.RedstoneProxyUBlock;
import mcjty.xnet.blocks.router.GuiRouter;
import mcjty.xnet.blocks.router.TileEntityRouter;
import mcjty.xnet.blocks.wireless.GuiWirelessRouter;
import mcjty.xnet.blocks.wireless.TileEntityWirelessRouter;
import mcjty.xnet.config.GeneralConfiguration;
import net.minecraft.block.properties.IProperty;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ModBlocks {
    public static GenericBlock<TileEntityController, GenericContainer> controllerBlock;
    public static GenericBlock<TileEntityRouter, GenericContainer> routerBlock;
    public static GenericBlock<TileEntityWirelessRouter, GenericContainer> wirelessRouterBlock;
    public static BaseBlock antennaBlock;
    public static BaseBlock antennaBaseBlock;
    public static BaseBlock antennaDishBlock;
    public static FacadeBlock facadeBlock;
    public static RedstoneProxyBlock redstoneProxyBlock;
    public static RedstoneProxyUBlock redstoneProxyUBlock;
    public static GenericBlockBuilderFactory builderFactory;

    public static void init() {
        builderFactory = new GenericBlockBuilderFactory((ModBase)XNet.instance).creativeTabs(XNet.tabXNet);
        facadeBlock = new FacadeBlock();
        redstoneProxyBlock = new RedstoneProxyBlock();
        redstoneProxyUBlock = new RedstoneProxyUBlock();
        controllerBlock = ((GenericBlockBuilder)((GenericBlockBuilder)((GenericBlockBuilder)((GenericBlockBuilder)builderFactory.builder("controller").tileEntityClass(TileEntityController.class).container(TileEntityController.CONTAINER_FACTORY).flags(new BlockFlags[]{BlockFlags.REDSTONE_CHECK})).guiId(1).property((IProperty)TileEntityController.ERROR)).info("message.xnet.shiftmessage")).infoExtended("message.xnet.controller")).build();
        routerBlock = ((GenericBlockBuilder)((GenericBlockBuilder)((GenericBlockBuilder)builderFactory.builder("router").tileEntityClass(TileEntityRouter.class).emptyContainer().guiId(3).property((IProperty)TileEntityRouter.ERROR)).info("message.xnet.shiftmessage")).infoExtended("message.xnet.router")).build();
        wirelessRouterBlock = ((GenericBlockBuilder)((GenericBlockBuilder)((GenericBlockBuilder)builderFactory.builder("wireless_router").tileEntityClass(TileEntityWirelessRouter.class).emptyContainer().guiId(4).property((IProperty)TileEntityWirelessRouter.ERROR)).info("message.xnet.shiftmessage")).infoExtended("message.xnet.wireless_router")).build();
        antennaBlock = new BaseBlockBuilder((ModBase)XNet.instance, "antenna").rotationType(BaseBlock.RotationType.HORIZROTATION).flags(new BlockFlags[]{BlockFlags.NON_OPAQUE}).creativeTabs(XNet.tabXNet).info("message.xnet.shiftmessage").infoExtended("message.xnet.antenna").infoExtendedParameter(stack -> Integer.toString(GeneralConfiguration.antennaTier1Range)).infoExtendedParameter(stack -> Integer.toString(GeneralConfiguration.wirelessRouterRfPerChannel[0])).infoExtendedParameter(stack -> Integer.toString(GeneralConfiguration.antennaTier2Range)).infoExtendedParameter(stack -> Integer.toString(GeneralConfiguration.wirelessRouterRfPerChannel[1])).build();
        antennaBaseBlock = new BaseBlockBuilder((ModBase)XNet.instance, "antenna_base").rotationType(BaseBlock.RotationType.NONE).flags(new BlockFlags[]{BlockFlags.NON_OPAQUE}).creativeTabs(XNet.tabXNet).info("message.xnet.shiftmessage").infoExtended("message.xnet.antenna_base").build();
        antennaDishBlock = new BaseBlockBuilder((ModBase)XNet.instance, "antenna_dish").rotationType(BaseBlock.RotationType.HORIZROTATION).flags(new BlockFlags[]{BlockFlags.NON_OPAQUE}).creativeTabs(XNet.tabXNet).info("message.xnet.shiftmessage").infoExtended("message.xnet.antenna_dish").infoExtendedParameter(stack -> Integer.toString(GeneralConfiguration.wirelessRouterRfPerChannel[2])).build();
        NetCableSetup.init();
    }

    @SideOnly(value=Side.CLIENT)
    public static void initModels() {
        controllerBlock.initModel();
        controllerBlock.setGuiFactory(GuiController::new);
        routerBlock.initModel();
        routerBlock.setGuiFactory(GuiRouter::new);
        wirelessRouterBlock.initModel();
        wirelessRouterBlock.setGuiFactory(GuiWirelessRouter::new);
        antennaBlock.initModel();
        antennaBaseBlock.initModel();
        antennaDishBlock.initModel();
        facadeBlock.initModel();
        redstoneProxyBlock.initModel();
        redstoneProxyUBlock.initModel();
        NetCableSetup.initClient();
    }

    @SideOnly(value=Side.CLIENT)
    public static void initItemModels() {
        facadeBlock.initItemModel();
        NetCableSetup.initItemModels();
    }

    @SideOnly(value=Side.CLIENT)
    public static void initColorHandlers(BlockColors blockColors) {
        facadeBlock.initColorHandler(blockColors);
        NetCableSetup.initColorHandlers(blockColors);
    }
}

