/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.biome.vanilla;

import biomesoplenty.api.biome.BiomeOwner;
import biomesoplenty.api.biome.IExtendedBiome;
import biomesoplenty.api.block.BOPBlocks;
import biomesoplenty.api.block.IBlockPosQuery;
import biomesoplenty.api.config.IBOPWorldSettings;
import biomesoplenty.api.config.IConfigObj;
import biomesoplenty.api.enums.BOPClimates;
import biomesoplenty.api.enums.BOPFlowers;
import biomesoplenty.api.enums.BOPPlants;
import biomesoplenty.api.generation.GeneratorStage;
import biomesoplenty.api.generation.IGenerator;
import biomesoplenty.common.block.BlockBOPMushroom;
import biomesoplenty.common.init.ModBiomes;
import biomesoplenty.common.util.biome.BiomeUtils;
import biomesoplenty.common.util.biome.GeneratorUtils;
import biomesoplenty.common.util.block.BlockQuery;
import biomesoplenty.common.world.GenerationManager;
import biomesoplenty.common.world.generator.GeneratorFlora;
import biomesoplenty.core.BiomesOPlenty;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.properties.IProperty;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;

public class ExtendedBiomeWrapper
implements IExtendedBiome {
    public final Biome biome;
    private GenerationManager generationManager = new GenerationManager();
    private Map<BOPClimates, Integer> weightMap = new HashMap<BOPClimates, Integer>();
    public ResourceLocation beachBiomeLocation = BiomeUtils.getLocForBiome(Biomes.field_76787_r);

    public ExtendedBiomeWrapper(Biome biome) {
        this.biome = biome;
        this.addGenerator("roots", GeneratorStage.FLOWERS, ((GeneratorFlora.Builder)((GeneratorFlora.Builder)new GeneratorFlora.Builder().amountPerChunk(4.0f)).with(BOPPlants.ROOT)).create());
        IBlockPosQuery suitableStonePosition = BlockQuery.buildAnd().withAltitudeBetween(0, 55).blocks(Blocks.field_150348_b).create();
        this.addGenerator("miners_delight", GeneratorStage.FLOWERS, ((GeneratorFlora.Builder)((GeneratorFlora.Builder)((GeneratorFlora.Builder)((GeneratorFlora.Builder)((GeneratorFlora.Builder)new GeneratorFlora.Builder().amountPerChunk(0.25f)).generationAttempts(64)).with(BOPFlowers.MINERS_DELIGHT)).placeOn(suitableStonePosition)).scatterYMethod(GeneratorUtils.ScatterYMethod.BELOW_GROUND)).create());
        this.addGenerator("glowshrooms", GeneratorStage.FLOWERS, ((GeneratorFlora.Builder)((GeneratorFlora.Builder)((GeneratorFlora.Builder)((GeneratorFlora.Builder)((GeneratorFlora.Builder)new GeneratorFlora.Builder().amountPerChunk(1.5f)).generationAttempts(64)).placeOn(suitableStonePosition)).with(BOPBlocks.mushroom.func_176223_P().func_177226_a((IProperty)BlockBOPMushroom.VARIANT, (Comparable)((Object)BlockBOPMushroom.MushroomType.GLOWSHROOM)))).scatterYMethod(GeneratorUtils.ScatterYMethod.BELOW_GROUND)).create());
    }

    @Override
    public void applySettings(IBOPWorldSettings settings) {
        if (!settings.isEnabled(IBOPWorldSettings.GeneratorType.GEMS)) {
            this.removeGenerator("ruby");
            this.removeGenerator("topaz");
            this.removeGenerator("amber");
            this.removeGenerator("peridot");
            this.removeGenerator("malachite");
            this.removeGenerator("sapphire");
            this.removeGenerator("tanzanite");
            this.removeGenerator("amethyst");
        }
        if (!settings.isEnabled(IBOPWorldSettings.GeneratorType.POISON_IVY)) {
            this.removeGenerator("poison_ivy");
        }
        if (!settings.isEnabled(IBOPWorldSettings.GeneratorType.BERRY_BUSHES)) {
            this.removeGenerator("berry_bushes");
        }
        if (!settings.isEnabled(IBOPWorldSettings.GeneratorType.NETHER_HIVES)) {
            this.removeGenerator("hive");
        }
        if (!settings.isEnabled(IBOPWorldSettings.GeneratorType.THORNS)) {
            this.removeGenerator("thorns");
        }
        if (!settings.isEnabled(IBOPWorldSettings.GeneratorType.QUICKSAND)) {
            this.removeGenerator("quicksand");
        }
        if (!settings.isEnabled(IBOPWorldSettings.GeneratorType.HOT_SPRINGS)) {
            this.removeGenerator("hot_springs");
        }
        if (!settings.isEnabled(IBOPWorldSettings.GeneratorType.LIQUID_POISON)) {
            this.removeGenerator("poison_lakes");
        }
    }

    @Override
    public void configure(IConfigObj conf) {
        this.beachBiomeLocation = conf.getResourceLocation("beachBiomeLocation", this.beachBiomeLocation);
        IConfigObj confGenerators = conf.getObject("generators");
        this.generationManager.configure(confGenerators);
        for (String msg : conf.flushMessages()) {
            BiomesOPlenty.logger.info(msg);
        }
        ModBiomes.writeDefaultConfigFile(ModBiomes.VANILLA_DEFAULTS_DIR, this.getResourceLocation().func_110623_a(), conf);
    }

    @Override
    public BiomeOwner getBiomeOwner() {
        return BiomeOwner.OTHER;
    }

    @Override
    public void addGenerator(String name, GeneratorStage stage, IGenerator generator) {
        this.generationManager.addGenerator(name, stage, generator);
    }

    public IGenerator getGenerator(String name) {
        return this.generationManager.getGenerator(name);
    }

    public void removeGenerator(String name) {
        this.generationManager.removeGenerator(name);
    }

    @Override
    public GenerationManager getGenerationManager() {
        return this.generationManager;
    }

    @Override
    public Map<BOPClimates, Integer> getWeightMap() {
        return this.weightMap;
    }

    @Override
    public void addWeight(BOPClimates climate, int weight) {
        this.weightMap.put(climate, weight);
    }

    @Override
    public void clearWeights() {
        this.weightMap.clear();
    }

    @Override
    public ResourceLocation getBeachLocation() {
        return this.beachBiomeLocation;
    }

    @Override
    public ResourceLocation getResourceLocation() {
        return BiomeUtils.getLocForBiome(this.biome);
    }

    @Override
    public Biome getBaseBiome() {
        return this.biome;
    }
}

