/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolspower.modules.powercell.blocks;

import com.mojang.blaze3d.matrix.MatrixStack;
import javax.annotation.Nonnull;
import mcjty.lib.typed.Key;
import mcjty.lib.typed.Type;
import mcjty.lib.typed.TypedMap;
import mcjty.rftoolsbase.api.infoscreen.IInformationScreenInfo;
import mcjty.rftoolsbase.modules.informationscreen.blocks.DefaultPowerInformationScreenInfo;
import mcjty.rftoolspower.modules.powercell.blocks.PowerCellTileEntity;
import mcjty.rftoolspower.modules.powercell.client.PowerCellInformationRenderer;
import mcjty.rftoolspower.modules.powercell.data.PowerCellNetwork;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.util.Direction;

public class PowerCellInformationScreenInfo
implements IInformationScreenInfo {
    public static final int MODE_POWER_EXTENDED = 2;
    public static final Key<Long> RFEXTRACT_PERTICK = new Key("rfExtractPerTick", Type.LONG);
    public static final Key<Long> RFINSERT_PERTICK = new Key("rfInsertPerTick", Type.LONG);
    public static final Key<Long> ROUGH_MAXRF_PERTICK = new Key("roughMaxRfPerTick", Type.LONG);
    private final PowerCellTileEntity cell;
    private long lastExtracted = 0L;
    private long lastInserted = 0L;
    private long rfExtractPerTick = 0L;
    private long rfInsertedPerTick = 0L;

    public PowerCellInformationScreenInfo(PowerCellTileEntity cell) {
        this.cell = cell;
    }

    public int[] getSupportedModes() {
        return new int[]{0, 1, 2};
    }

    public void tick() {
        PowerCellNetwork network = this.cell.getNetwork();
        if (network != null) {
            long newExtracted = network.getExtracted();
            long newInserted = network.getInserted();
            this.rfExtractPerTick = (newExtracted - this.lastExtracted) / 10L;
            this.rfInsertedPerTick = (newInserted - this.lastInserted) / 10L;
            this.lastExtracted = newExtracted;
            this.lastInserted = newInserted;
        } else {
            this.rfExtractPerTick = -1L;
            this.rfInsertedPerTick = -1L;
        }
    }

    private long calculateRoughMaxRfPerTick() {
        return this.cell.getRfPerTickPerSide() * 2L;
    }

    @Nonnull
    public TypedMap getInfo(int mode) {
        PowerCellNetwork network = this.cell.getNetwork();
        if (network != null) {
            long energy = network.getEnergy();
            long maxEnergy = network.getMaxEnergy();
            return TypedMap.builder().put(DefaultPowerInformationScreenInfo.ENERGY, (Object)energy).put(DefaultPowerInformationScreenInfo.MAXENERGY, (Object)maxEnergy).put(RFEXTRACT_PERTICK, (Object)this.rfExtractPerTick).put(RFINSERT_PERTICK, (Object)this.rfInsertedPerTick).put(ROUGH_MAXRF_PERTICK, (Object)this.calculateRoughMaxRfPerTick()).build();
        }
        return TypedMap.EMPTY;
    }

    public void render(int mode, MatrixStack matrixStack, IRenderTypeBuffer buffer, @Nonnull TypedMap data, Direction orientation, double x, double y, double z, double scale) {
        if (mode == 0) {
            PowerCellInformationRenderer.renderDefault(matrixStack, buffer, data, orientation, x, y, z, scale);
        } else {
            PowerCellInformationRenderer.renderGraphical(matrixStack, buffer, mode, data, orientation, x, y, z, scale);
        }
    }
}

