/*
 * Decompiled with CFR 0.152.
 */
package xyz.brassgoggledcoders.transport.tileentity.loader;

import com.hrznstudio.titanium.api.IFactory;
import com.hrznstudio.titanium.api.client.IScreenAddon;
import com.hrznstudio.titanium.api.client.IScreenAddonProvider;
import java.util.Collections;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import xyz.brassgoggledcoders.transport.capability.InventoryPlusComponent;
import xyz.brassgoggledcoders.transport.capability.ItemHandlerDirectional;
import xyz.brassgoggledcoders.transport.container.containeraddon.IContainerAddon;
import xyz.brassgoggledcoders.transport.content.TransportBlocks;
import xyz.brassgoggledcoders.transport.tileentity.loader.BasicLoaderTileEntity;

public class ItemLoaderTileEntity
extends BasicLoaderTileEntity<IItemHandler>
implements IScreenAddonProvider {
    private final InventoryPlusComponent<ItemLoaderTileEntity> inventoryComponent = new InventoryPlusComponent("inventory", 44, 35, 5);
    private final LazyOptional<IItemHandler> internalLazyOptional = LazyOptional.of(() -> this.inventoryComponent);

    public ItemLoaderTileEntity() {
        this(TransportBlocks.ITEM_LOADER.getTileEntityType());
    }

    public <T extends ItemLoaderTileEntity> ItemLoaderTileEntity(TileEntityType<T> tileEntityType) {
        super(tileEntityType, CapabilityItemHandler.ITEM_HANDLER_CAPABILITY);
    }

    @Override
    protected void transfer(IItemHandler from, IItemHandler to) {
        for (int fromIndex = 0; fromIndex < from.getSlots(); ++fromIndex) {
            ItemStack itemStackSimPushed;
            ItemStack itemStackSimPulled = from.extractItem(fromIndex, 64, true);
            if (itemStackSimPulled.func_190926_b() || !(itemStackSimPushed = ItemHandlerHelper.insertItem((IItemHandler)to, (ItemStack)itemStackSimPulled, (boolean)true)).func_190926_b()) continue;
            ItemHandlerHelper.insertItem((IItemHandler)to, (ItemStack)from.extractItem(fromIndex, 64, false), (boolean)false);
            break;
        }
    }

    @Override
    protected LazyOptional<IItemHandler> getInternalCAP() {
        return this.internalLazyOptional;
    }

    @Override
    protected LazyOptional<IItemHandler> createOutputCAP() {
        return LazyOptional.of(() -> new ItemHandlerDirectional((IItemHandler)this.inventoryComponent, false));
    }

    @Override
    protected LazyOptional<IItemHandler> createInputCAP() {
        return LazyOptional.of(() -> new ItemHandlerDirectional((IItemHandler)this.inventoryComponent, true));
    }

    @Override
    protected CompoundNBT serializeCap() {
        return this.inventoryComponent.serializeNBT();
    }

    @Override
    protected void deserializeCap(CompoundNBT compoundNBT) {
        this.inventoryComponent.deserializeNBT(compoundNBT);
    }

    public List<IFactory<? extends IScreenAddon>> getScreenAddons() {
        return this.inventoryComponent.getScreenAddons();
    }

    @Override
    public List<IContainerAddon> getContainerAddons() {
        return Collections.singletonList(this.inventoryComponent);
    }
}

