/*
 * Decompiled with CFR 0.152.
 */
package xyz.brassgoggledcoders.transport.tileentity.loader;

import com.hrznstudio.titanium.api.IFactory;
import com.hrznstudio.titanium.api.client.IScreenAddon;
import java.util.Collections;
import java.util.List;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import xyz.brassgoggledcoders.transport.capability.FluidHandlerDirectional;
import xyz.brassgoggledcoders.transport.capability.FluidTankPlusComponent;
import xyz.brassgoggledcoders.transport.container.containeraddon.IContainerAddon;
import xyz.brassgoggledcoders.transport.content.TransportBlocks;
import xyz.brassgoggledcoders.transport.tileentity.loader.BasicLoaderTileEntity;

public class FluidLoaderTileEntity
extends BasicLoaderTileEntity<IFluidHandler> {
    private final FluidTankPlusComponent<FluidLoaderTileEntity> fluidTankComponent = new FluidTankPlusComponent("Loader", 10000, 80, 28);
    private final LazyOptional<IFluidHandler> lazyFluid = LazyOptional.of(() -> this.fluidTankComponent);

    public FluidLoaderTileEntity() {
        super(TransportBlocks.FLUID_LOADER.getTileEntityType(), CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY);
    }

    @Override
    protected void transfer(IFluidHandler from, IFluidHandler to) {
        int filledAmount;
        FluidStack output = from.drain(1000, IFluidHandler.FluidAction.SIMULATE);
        if (!output.isEmpty() && (filledAmount = to.fill(output, IFluidHandler.FluidAction.SIMULATE)) > 0) {
            to.fill(from.drain(filledAmount, IFluidHandler.FluidAction.EXECUTE), IFluidHandler.FluidAction.EXECUTE);
        }
    }

    @Override
    public void onActivated(PlayerEntity player, Hand hand, BlockRayTraceResult rayTraceResult) {
        if (this.getTheWorld().field_72995_K || !FluidUtil.interactWithFluidHandler((PlayerEntity)player, (Hand)hand, this.fluidTankComponent)) {
            super.onActivated(player, hand, rayTraceResult);
        }
    }

    @Override
    protected LazyOptional<IFluidHandler> getInternalCAP() {
        return this.lazyFluid;
    }

    @Override
    protected LazyOptional<IFluidHandler> createOutputCAP() {
        return LazyOptional.of(() -> new FluidHandlerDirectional((IFluidHandler)this.fluidTankComponent, false));
    }

    @Override
    protected LazyOptional<IFluidHandler> createInputCAP() {
        return LazyOptional.of(() -> new FluidHandlerDirectional((IFluidHandler)this.fluidTankComponent, true));
    }

    @Override
    protected CompoundNBT serializeCap() {
        return this.fluidTankComponent.writeToNBT(new CompoundNBT());
    }

    @Override
    protected void deserializeCap(CompoundNBT compoundNBT) {
        this.fluidTankComponent.readFromNBT(compoundNBT);
    }

    public List<IFactory<? extends IScreenAddon>> getScreenAddons() {
        return this.fluidTankComponent.getScreenAddons();
    }

    @Override
    public List<IContainerAddon> getContainerAddons() {
        return Collections.singletonList(this.fluidTankComponent);
    }
}

