/*
 * Decompiled with CFR 0.152.
 */
package xyz.brassgoggledcoders.transport.item;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.AbstractRailBlock;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.minecart.AbstractMinecartEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.Items;
import net.minecraft.item.MinecartItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.properties.RailShape;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistryEntry;
import xyz.brassgoggledcoders.transport.Transport;
import xyz.brassgoggledcoders.transport.api.TransportAPI;
import xyz.brassgoggledcoders.transport.api.cargo.Cargo;
import xyz.brassgoggledcoders.transport.api.cargoinstance.CargoInstance;
import xyz.brassgoggledcoders.transport.content.TransportEntities;
import xyz.brassgoggledcoders.transport.entity.CargoCarrierMinecartEntity;

public class CargoCarrierMinecartItem
extends MinecartItem {
    public CargoCarrierMinecartItem() {
        this(new Item.Properties().func_200919_a(Items.field_151143_au).func_200916_a(Transport.ITEM_GROUP));
    }

    public CargoCarrierMinecartItem(Item.Properties properties) {
        super(AbstractMinecartEntity.Type.CHEST, properties);
        this.func_185043_a(new ResourceLocation("transport", "cargo"), (itemStack, world, livingEntity) -> Optional.ofNullable(CargoCarrierMinecartItem.getCargo(itemStack.func_179543_a("cargo"))).map(ForgeRegistryEntry::getRegistryName).map(arg_0 -> TransportAPI.CARGO.getID(arg_0)).map(id -> Float.valueOf((float)id.intValue() / 1000.0f)).orElse(Float.valueOf(0.0f)).floatValue());
    }

    public static ItemStack getCartStack(CargoInstance cargoInstance) {
        ItemStack itemStack = new ItemStack((IItemProvider)TransportEntities.CARGO_MINECART_ITEM.map(Item::func_199767_j).orElse(Items.field_151143_au));
        itemStack.func_190925_c("cargo").func_74778_a("name", Objects.requireNonNull(cargoInstance.getCargo().getRegistryName()).toString());
        return itemStack;
    }

    public static Cargo getCargo(@Nullable CompoundNBT cargo) {
        return Optional.ofNullable(cargo).map(compoundNBT -> compoundNBT.func_74779_i("name")).map(ResourceLocation::new).map(arg_0 -> TransportAPI.CARGO.getValue(arg_0)).orElseGet((Supplier<Cargo>)TransportAPI.EMPTY_CARGO);
    }

    @Nonnull
    public ActionResultType func_195939_a(ItemUseContext context) {
        BlockPos blockPos;
        World world = context.func_195991_k();
        BlockState blockstate = world.func_180495_p(blockPos = context.func_195995_a());
        if (!blockstate.func_203425_a(BlockTags.field_203437_y)) {
            return ActionResultType.FAIL;
        }
        ItemStack itemStack = context.func_195996_i();
        if (!world.field_72995_K) {
            RailShape railshape = blockstate.func_177230_c() instanceof AbstractRailBlock ? ((AbstractRailBlock)blockstate.func_177230_c()).getRailDirection(blockstate, (IBlockReader)world, blockPos, null) : RailShape.NORTH_SOUTH;
            double d0 = 0.0;
            if (railshape.func_208092_c()) {
                d0 = 0.5;
            }
            CompoundNBT cargoNBT = itemStack.func_179543_a("cargo");
            CargoCarrierMinecartEntity cargoCarrierMinecartEntity = new CargoCarrierMinecartEntity(world, CargoCarrierMinecartItem.getCargo(cargoNBT), (double)blockPos.func_177958_n() + 0.5, (double)blockPos.func_177956_o() + 0.0625 + d0, (double)blockPos.func_177952_p() + 0.5);
            if (itemStack.func_82837_s()) {
                cargoCarrierMinecartEntity.func_200203_b(itemStack.func_200301_q());
            }
            Optional.ofNullable(cargoNBT).map(compoundNBT -> compoundNBT.func_74775_l("instance")).ifPresent(cargoCarrierMinecartEntity.getCargoInstance()::deserializeNBT);
            world.func_217376_c((Entity)cargoCarrierMinecartEntity);
        }
        itemStack.func_190918_g(1);
        return ActionResultType.SUCCESS;
    }

    @ParametersAreNonnullByDefault
    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (this.func_194125_a(group)) {
            TransportAPI.CARGO.getValues().stream().filter(cargo -> !cargo.isEmpty()).map(ForgeRegistryEntry::getRegistryName).filter(Objects::nonNull).map(ResourceLocation::toString).map(resourceLocation -> {
                ItemStack itemStack = new ItemStack((IItemProvider)this);
                itemStack.func_190925_c("cargo").func_74778_a("name", resourceLocation);
                return itemStack;
            }).forEach(arg_0 -> items.add(arg_0));
        }
    }

    @Nonnull
    public ITextComponent func_200295_i(@Nonnull ItemStack stack) {
        return new TranslationTextComponent("text.transport.with", new Object[]{Items.field_151143_au.func_200295_i(stack), CargoCarrierMinecartItem.getCargo(stack.func_179543_a("cargo")).getDisplayName()});
    }
}

