/*
 * Decompiled with CFR 0.152.
 */
package xyz.brassgoggledcoders.transport.entity;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.item.minecart.AbstractMinecartEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.registries.IForgeRegistryEntry;
import xyz.brassgoggledcoders.transport.Transport;
import xyz.brassgoggledcoders.transport.api.TransportAPI;
import xyz.brassgoggledcoders.transport.api.cargo.Cargo;
import xyz.brassgoggledcoders.transport.api.cargocarrier.ICargoCarrier;
import xyz.brassgoggledcoders.transport.api.cargoinstance.CargoInstance;
import xyz.brassgoggledcoders.transport.content.TransportCargoes;
import xyz.brassgoggledcoders.transport.content.TransportEntities;
import xyz.brassgoggledcoders.transport.item.CargoCarrierMinecartItem;

public class CargoCarrierMinecartEntity
extends AbstractMinecartEntity
implements ICargoCarrier {
    private static final DataParameter<ResourceLocation> CARGO_PARAMETER = EntityDataManager.func_187226_a(CargoCarrierMinecartEntity.class, (IDataSerializer)Transport.RESOURCE_LOCATION_DATA_SERIALIZER);
    private ITextComponent displayName;
    private Cargo cargo;
    private CargoInstance cargoInstance;

    public CargoCarrierMinecartEntity(EntityType<CargoCarrierMinecartEntity> entityType, World world) {
        super(entityType, world);
    }

    public CargoCarrierMinecartEntity(World world, Cargo cargo, double x, double y, double z) {
        this((EntityType<CargoCarrierMinecartEntity>)((EntityType)TransportEntities.CARGO_MINECART.get()), world, cargo, x, y, z);
    }

    public CargoCarrierMinecartEntity(EntityType<CargoCarrierMinecartEntity> entityType, World world, Cargo cargo, double x, double y, double z) {
        super(entityType, world, x, y, z);
        this.cargo = cargo;
        this.func_184212_Q().func_187227_b(CARGO_PARAMETER, (Object)Objects.requireNonNull(cargo.getRegistryName()));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(CARGO_PARAMETER, (Object)TransportCargoes.EMPTY.getId());
    }

    @Nonnull
    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    @Nonnull
    public AbstractMinecartEntity.Type func_184264_v() {
        return AbstractMinecartEntity.Type.CHEST;
    }

    @Nonnull
    public ActionResultType func_184199_a(PlayerEntity player, Vec3d vec, Hand hand) {
        return this.getCargoInstance().applyInteraction(this, player, vec, hand);
    }

    @Nonnull
    public ITextComponent func_145748_c_() {
        if (this.displayName == null) {
            this.displayName = new TranslationTextComponent("text.transport.with", new Object[]{super.func_145748_c_(), this.getCargoInstance().getDisplayName()});
        }
        return this.displayName;
    }

    @Nonnull
    public BlockState func_174897_t() {
        return this.getCargoInstance().getBlockState();
    }

    protected void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        CompoundNBT cargo = compound.func_74775_l("cargo");
        this.func_184212_Q().func_187227_b(CARGO_PARAMETER, (Object)new ResourceLocation(cargo.func_74779_i("name")));
    }

    protected void func_213281_b(@Nonnull CompoundNBT compound) {
        super.func_213281_b(compound);
        CompoundNBT cargo = new CompoundNBT();
        cargo.func_74778_a("name", ((ResourceLocation)this.func_184212_Q().func_187225_a(CARGO_PARAMETER)).toString());
        compound.func_218657_a("cargo", (INBT)cargo);
    }

    public ItemStack getCartItem() {
        return CargoCarrierMinecartItem.getCartStack(this.getCargoInstance());
    }

    @Override
    public World getTheWorld() {
        return this.field_70170_p;
    }

    @Override
    @Nonnull
    public Cargo getCargo() {
        if (this.cargo == null) {
            this.cargo = Optional.ofNullable(TransportAPI.CARGO.getValue((ResourceLocation)this.func_184212_Q().func_187225_a(CARGO_PARAMETER))).orElseGet((Supplier<IForgeRegistryEntry>)TransportCargoes.EMPTY);
        }
        return this.cargo;
    }

    @Override
    @Nonnull
    public CargoInstance getCargoInstance() {
        if (this.cargoInstance == null) {
            this.cargoInstance = this.getCargo().create(this.getTheWorld());
        }
        return this.cargoInstance;
    }

    @Override
    public void openContainer(PlayerEntity playerEntity, INamedContainerProvider provider, Consumer<PacketBuffer> packetBufferConsumer) {
        if (playerEntity instanceof ServerPlayerEntity) {
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)playerEntity), (INamedContainerProvider)provider, packetBuffer -> {
                packetBuffer.writeInt(this.func_145782_y());
                packetBufferConsumer.accept((PacketBuffer)packetBuffer);
            });
        }
    }

    @Override
    public boolean canInteractWith(PlayerEntity playerEntity) {
        return this.func_70089_S();
    }

    @Override
    public ITextComponent getCarrierDisplayName() {
        return super.func_145748_c_();
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        LazyOptional cargoLazyOptional = this.getCargoInstance().getCapability(cap, side);
        return cargoLazyOptional.isPresent() ? cargoLazyOptional : super.getCapability(cap, side);
    }

    public void func_94095_a(DamageSource source) {
        this.func_70106_y();
        if (this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223604_g)) {
            ItemStack itemStack = this.getCargo().createItemStack((Item)TransportEntities.CARGO_MINECART_ITEM.get(), this.getCargoInstance());
            if (this.func_145818_k_()) {
                itemStack.func_200302_a(this.func_200201_e());
            }
            this.func_199701_a_(itemStack);
        }
    }

    public int getComparatorLevel() {
        return this.getCargoInstance().getComparatorLevel();
    }
}

