/*
 * Decompiled with CFR 0.152.
 */
package xyz.brassgoggledcoders.transport.datagen;

import java.util.function.Supplier;
import net.minecraft.data.DataGenerator;
import net.minecraft.entity.EntityType;
import net.minecraft.item.Item;
import net.minecraftforge.common.data.LanguageProvider;
import xyz.brassgoggledcoders.transport.api.cargo.Cargo;
import xyz.brassgoggledcoders.transport.content.TransportBlocks;
import xyz.brassgoggledcoders.transport.content.TransportCargoes;
import xyz.brassgoggledcoders.transport.content.TransportEntities;
import xyz.brassgoggledcoders.transport.content.TransportItems;

public class TransportLanguageProvider
extends LanguageProvider {
    public TransportLanguageProvider(DataGenerator gen) {
        super(gen, "transport", "en_us");
    }

    protected void addTranslations() {
        this.addBlock(TransportBlocks.DIAMOND_CROSSING_RAIL, "Diamond Crossing Rail");
        this.addBlock(TransportBlocks.SCAFFOLDING_RAIL, "Scaffolding Rail");
        this.addBlock(TransportBlocks.HOLDING_RAIL, "Holding Rail");
        this.addBlock(TransportBlocks.ELEVATOR_SWITCH_RAIL, "Elevator Switch Rail");
        this.addBlock((Supplier)TransportBlocks.ELEVATOR_SWITCH_SUPPORT, "Elevator Switch Support");
        this.addBlock(TransportBlocks.ITEM_LOADER, "Item Loader");
        this.addBlock(TransportBlocks.ENERGY_LOADER, "Energy Loader");
        this.addBlock(TransportBlocks.FLUID_LOADER, "Fluid Loader");
        this.addBlock(TransportBlocks.SCAFFOLDING_SLAB_BLOCK, "Scaffolding Slab");
        this.addBlock(TransportBlocks.SWITCH_RAIL, "Switch Rail");
        this.addBlock(TransportBlocks.WYE_SWITCH_RAIL, "Wye Switch Rail");
        this.addBlock(TransportBlocks.BUMPER_RAIL, "Bumper Rail");
        this.addCargo((Supplier<? extends Cargo>)TransportCargoes.EMPTY, "No Cargo");
        this.addCargo((Supplier<? extends Cargo>)TransportCargoes.ITEM, "Inventory");
        this.addCargo((Supplier<? extends Cargo>)TransportCargoes.FLUID, "Fluid Tank");
        this.addCargo((Supplier<? extends Cargo>)TransportCargoes.ENERGY, "Energy Storage");
        this.add((EntityType)TransportEntities.CARGO_MINECART.get(), "Minecart");
        this.add((Item)TransportEntities.CARGO_MINECART_ITEM.get(), "Minecart");
        this.add((Item)TransportItems.RAIL_BREAKER.get(), "Rail Breaker");
        this.add("itemGroup.transport", "Transport");
        this.add("text.transport.with", "%s With %s");
        this.add("guide.transport.name", "Advanced Transport");
        this.add("guide.transport.landing_text", "Importing the Transportation of Goods");
    }

    public void addCargo(Supplier<? extends Cargo> cargo, String name) {
        this.add(cargo.get(), name);
    }

    public void add(Cargo cargo, String name) {
        this.add(cargo.getTranslationKey(), name);
    }
}

