/*
 * Decompiled with CFR 0.152.
 */
package xyz.brassgoggledcoders.transport.block.rail;

import javax.annotation.Nonnull;
import net.minecraft.block.AbstractRailBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.item.minecart.AbstractMinecartEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.RailShape;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import xyz.brassgoggledcoders.transport.api.TransportBlockStateProperties;
import xyz.brassgoggledcoders.transport.content.TransportItemTags;
import xyz.brassgoggledcoders.transport.util.RailUtils;

public class HoldingRailBlock
extends AbstractRailBlock {
    public static final BooleanProperty NORTH_WEST = TransportBlockStateProperties.NORTH_WEST;
    public static final EnumProperty<RailShape> SHAPE = TransportBlockStateProperties.STRAIGHT_RAIL_SHAPE;
    public static final BooleanProperty POWERED = BlockStateProperties.field_208194_u;

    public HoldingRailBlock() {
        this(Block.Properties.func_200945_a((Material)Material.field_151594_q).func_200942_a().func_200943_b(0.7f).func_200947_a(SoundType.field_185852_e));
    }

    public HoldingRailBlock(Block.Properties properties) {
        super(true, properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false))).func_206870_a(SHAPE, (Comparable)RailShape.NORTH_SOUTH)).func_206870_a((IProperty)NORTH_WEST, (Comparable)Boolean.valueOf(true)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{SHAPE, NORTH_WEST, POWERED});
    }

    @Nonnull
    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult rayTraceResult) {
        if (TransportItemTags.WRENCHES.func_199685_a_(player.func_184586_b(hand).func_77973_b())) {
            state = (BlockState)state.func_206870_a((IProperty)NORTH_WEST, (Comparable)Boolean.valueOf((Boolean)state.func_177229_b((IProperty)NORTH_WEST) == false));
            world.func_180501_a(pos, state, 3);
            return ActionResultType.SUCCESS;
        }
        return super.func_225533_a_(state, world, pos, player, hand, rayTraceResult);
    }

    public void onMinecartPass(BlockState state, World world, BlockPos pos, AbstractMinecartEntity cart) {
        if (((Boolean)state.func_177229_b((IProperty)POWERED)).booleanValue()) {
            float speedIncrease = 0.5f;
            if (((Boolean)state.func_177229_b((IProperty)NORTH_WEST)).booleanValue()) {
                speedIncrease *= -1.0f;
            }
            Vec3d motion = cart.func_213322_ci();
            if (state.func_177229_b(SHAPE) == RailShape.NORTH_SOUTH) {
                cart.func_213317_d(motion.func_72441_c(0.0, 0.0, (double)speedIncrease));
            } else {
                cart.func_213317_d(motion.func_72441_c((double)speedIncrease, 0.0, 0.0));
            }
        } else {
            cart.func_213317_d(Vec3d.field_186680_a);
        }
    }

    protected void func_189541_b(BlockState state, World world, BlockPos pos, Block block) {
        boolean isStatePowered = (Boolean)state.func_177229_b((IProperty)POWERED);
        boolean isWorldPowered = world.func_175640_z(pos);
        if (isWorldPowered != isStatePowered) {
            world.func_180501_a(pos, (BlockState)state.func_206870_a((IProperty)POWERED, (Comparable)Boolean.valueOf(isWorldPowered)), 3);
            world.func_195593_d(pos.func_177977_b(), (Block)this);
        }
        super.func_189541_b(state, world, pos, block);
    }

    @Nonnull
    public Property<RailShape> getShapeProperty() {
        return SHAPE;
    }

    public boolean canMakeSlopes(BlockState state, IBlockReader world, BlockPos pos) {
        return false;
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return RailUtils.setRailStateWithFacing(this.func_176223_P(), context);
    }
}

