/*
 * Decompiled with CFR 0.152.
 */
package xyz.brassgoggledcoders.transport.api.cargo;

import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistryEntry;
import xyz.brassgoggledcoders.transport.api.cargoinstance.CargoInstance;

public class Cargo
extends ForgeRegistryEntry<Cargo>
implements IItemProvider {
    private final Supplier<? extends Block> blockSupplier;
    private final Function<Cargo, ? extends CargoInstance> cargoInstanceCreator;
    private BlockState blockState;
    private String translationKey = null;
    private ITextComponent name;

    public Cargo(Supplier<? extends Block> blockSupplier) {
        this(blockSupplier, CargoInstance::new);
    }

    public Cargo(Supplier<? extends Block> blockSupplier, Function<Cargo, ? extends CargoInstance> cargoInstanceCreator) {
        this.blockSupplier = blockSupplier;
        this.cargoInstanceCreator = cargoInstanceCreator;
    }

    @Nonnull
    public CargoInstance create(@Nullable World world) {
        return this.cargoInstanceCreator.apply(this);
    }

    @Nonnull
    public String getTranslationKey() {
        if (this.translationKey == null) {
            this.translationKey = Util.func_200697_a((String)"cargo", (ResourceLocation)this.getRegistryName());
        }
        return this.translationKey;
    }

    @Nonnull
    public ITextComponent getDisplayName() {
        if (this.name == null) {
            this.name = new TranslationTextComponent(this.getTranslationKey(), new Object[0]);
        }
        return this.name;
    }

    @Nonnull
    public BlockState getDefaultBlockState() {
        if (this.blockState == null) {
            this.blockState = this.blockSupplier.get().func_176223_P();
        }
        return this.blockState;
    }

    public boolean isEmpty() {
        return false;
    }

    public ItemStack createItemStack(Item item) {
        return this.createItemStack(item, null);
    }

    public ItemStack createItemStack(Item item, @Nullable CargoInstance cargoInstance) {
        ItemStack itemStack = new ItemStack((IItemProvider)item);
        CompoundNBT cargoNBT = itemStack.func_190925_c("cargo");
        cargoNBT.func_74778_a("name", String.valueOf(this.getRegistryName()));
        if (cargoInstance != null) {
            cargoNBT.func_218657_a("instance", (INBT)cargoInstance.serializeNBT());
        }
        return itemStack;
    }

    @Nonnull
    public Item func_199767_j() {
        return this.getDefaultBlockState().func_177230_c().func_199767_j();
    }
}

