/*
 * Decompiled with CFR 0.152.
 */
package xyz.brassgoggledcoders.transport;

import net.minecraft.block.Blocks;
import net.minecraft.item.ItemGroup;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import xyz.brassgoggledcoders.transport.ClientEventHandler;
import xyz.brassgoggledcoders.transport.api.TransportAPI;
import xyz.brassgoggledcoders.transport.content.TransportBlocks;
import xyz.brassgoggledcoders.transport.content.TransportCargoes;
import xyz.brassgoggledcoders.transport.content.TransportContainers;
import xyz.brassgoggledcoders.transport.content.TransportEntities;
import xyz.brassgoggledcoders.transport.content.TransportItems;
import xyz.brassgoggledcoders.transport.content.TransportRecipes;
import xyz.brassgoggledcoders.transport.datagen.TransportDataGenerator;
import xyz.brassgoggledcoders.transport.entity.ResourceLocationDataSerializer;
import xyz.brassgoggledcoders.transport.item.TransportItemGroup;
import xyz.brassgoggledcoders.transport.pointmachine.ComparatorPointMachineBehavior;
import xyz.brassgoggledcoders.transport.pointmachine.LeverPointMachineBehavior;
import xyz.brassgoggledcoders.transport.pointmachine.RedstonePointMachineBehavior;

@Mod(value="transport")
public class Transport {
    public static final String ID = "transport";
    public static final ItemGroup ITEM_GROUP = new TransportItemGroup("transport", TransportBlocks.HOLDING_RAIL::getItem);
    public static final ResourceLocationDataSerializer RESOURCE_LOCATION_DATA_SERIALIZER = Transport.createDataSerializer();
    public static Transport instance;

    public Transport() {
        instance = this;
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> modBus.addListener(ClientEventHandler::clientSetup));
        modBus.addListener(TransportDataGenerator::gather);
        modBus.addListener(this::commonSetup);
        TransportBlocks.register(modBus);
        TransportCargoes.register(modBus);
        TransportContainers.register(modBus);
        TransportEntities.register(modBus);
        TransportRecipes.register(modBus);
        TransportItems.register(modBus);
    }

    public void commonSetup(FMLCommonSetupEvent event) {
        TransportAPI.POINT_MACHINE_BEHAVIORS.put(Blocks.field_150442_at, new LeverPointMachineBehavior());
        TransportAPI.POINT_MACHINE_BEHAVIORS.put(Blocks.field_196633_cV, new RedstonePointMachineBehavior());
        TransportAPI.POINT_MACHINE_BEHAVIORS.put(Blocks.field_196762_fd, new ComparatorPointMachineBehavior());
    }

    private static ResourceLocationDataSerializer createDataSerializer() {
        ResourceLocationDataSerializer dataSerializer = new ResourceLocationDataSerializer();
        DataSerializers.func_187189_a((IDataSerializer)dataSerializer);
        return dataSerializer;
    }
}

