/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.extradisks;

import de.melanx.extradisks.ConfigHandler;
import de.melanx.extradisks.CreativeTab;
import de.melanx.extradisks.items.AdvancedStorageHousingItem;
import de.melanx.extradisks.items.fluid.ExtraFluidStorageDiskItem;
import de.melanx.extradisks.items.fluid.ExtraFluidStoragePartItem;
import de.melanx.extradisks.items.fluid.ExtraFluidStorageType;
import de.melanx.extradisks.items.item.ExtraItemStorageType;
import de.melanx.extradisks.items.item.ExtraStorageDiskItem;
import de.melanx.extradisks.items.item.ExtraStoragePartItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="extradisks")
public class ExtraDisks {
    public static final String MODID = "extradisks";
    public static final Logger LOGGER = LogManager.getLogger();
    public static final ItemGroup ModGroup = new CreativeTab();

    public ExtraDisks() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, ConfigHandler.SERVER_CONFIG);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        ConfigHandler.loadConfig(ConfigHandler.SERVER_CONFIG, FMLPaths.CONFIGDIR.get().resolve("extradisks-server.toml"));
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void setup(FMLCommonSetupEvent event) {
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class RegistryEvents {
        @SubscribeEvent
        public static void onItemsRegistry(RegistryEvent.Register<Item> event) {
            event.getRegistry().register((IForgeRegistryEntry)new AdvancedStorageHousingItem());
            for (ExtraItemStorageType extraItemStorageType : ExtraItemStorageType.values()) {
                if (extraItemStorageType.getCapacity() > ExtraItemStorageType.TIER_8.getCapacity() && !((Boolean)ConfigHandler.moreDisks.get()).booleanValue()) break;
                event.getRegistry().register((IForgeRegistryEntry)new ExtraStoragePartItem(extraItemStorageType));
                event.getRegistry().register((IForgeRegistryEntry)new ExtraStorageDiskItem(extraItemStorageType));
            }
            for (Enum enum_ : ExtraFluidStorageType.values()) {
                if (((ExtraFluidStorageType)enum_).getCapacity() > ExtraFluidStorageType.TIER_8_FLUID.getCapacity() && !((Boolean)ConfigHandler.moreDisks.get()).booleanValue()) break;
                event.getRegistry().register((IForgeRegistryEntry)new ExtraFluidStoragePartItem((ExtraFluidStorageType)enum_));
                event.getRegistry().register((IForgeRegistryEntry)new ExtraFluidStorageDiskItem((ExtraFluidStorageType)enum_));
            }
        }
    }
}

