/*
 * Decompiled with CFR 0.152.
 */
package com.unrealdinnerbone.tramplestopper;

import com.unrealdinnerbone.tramplestopper.TrampleType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="tramplestopper")
@Mod.EventBusSubscriber
public class TrampleStopper {
    public static final String MOD_ID = "tramplestopper";
    private static final ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
    public static ForgeConfigSpec.EnumValue<TrampleType> type;
    public ForgeConfigSpec.IntValue intValue;
    public ForgeConfigSpec.DoubleValue doubleValue;
    public static ResourceLocation FARMLAND_TRAMPLED;
    public static ResourceLocation FARMLAND_NOT_TRAMPLED;
    private static TrampleStopper THIS;
    private static final Logger LOGGER;

    public TrampleStopper() {
        THIS = this;
        builder.push("general");
        type = builder.comment(new String[]{"When should farmland get trampled", "Never: Never trampled farmland", "Always: It Always get trampled", "Default: Normal behavior", "Feather Falling: Does not get trampled with you have feather falling boots"}).defineEnum("type", (Enum)TrampleType.FEATHER_FALLING);
        this.intValue = builder.comment("Level of Feather Falling needed").defineInRange("level", 1, 1, 3);
        this.doubleValue = builder.comment("At how many blocks should trampling stop start").defineInRange("blocks", 0.0, 0.0, 256.0);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, builder.build());
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void setup(FMLCommonSetupEvent event) {
        LOGGER.info("HI");
        FARMLAND_TRAMPLED = (ResourceLocation)Registry.func_218322_a((Registry)Registry.field_212623_l, (ResourceLocation)new ResourceLocation(MOD_ID, "farmland_trampled"), (Object)new ResourceLocation(MOD_ID, "farmland_trampled"));
        FARMLAND_NOT_TRAMPLED = (ResourceLocation)Registry.func_218322_a((Registry)Registry.field_212623_l, (ResourceLocation)new ResourceLocation(MOD_ID, "farmland_saved"), (Object)new ResourceLocation(MOD_ID, "farmland_saved"));
    }

    @SubscribeEvent
    public static void onCropTrample(BlockEvent.FarmlandTrampleEvent event) {
        if (((TrampleType)((Object)type.get())).getFunction().apply(THIS, new Pair<Entity, Float>(event.getEntity(), Float.valueOf(event.getFallDistance()))).booleanValue()) {
            event.setCanceled(true);
            if (event.getEntity() instanceof PlayerEntity) {
                ((PlayerEntity)event.getEntity()).func_195066_a(FARMLAND_NOT_TRAMPLED);
            }
        } else if (event.getEntity() instanceof PlayerEntity) {
            ((PlayerEntity)event.getEntity()).func_195066_a(FARMLAND_TRAMPLED);
        }
    }

    static {
        LOGGER = LogManager.getLogger();
    }

    public static class Pair<A, B> {
        private final A a;
        private final B b;

        public Pair(A a, B b) {
            this.a = a;
            this.b = b;
        }

        public A getA() {
            return this.a;
        }

        public B getB() {
            return this.b;
        }
    }
}

