/*
 * Decompiled with CFR 0.152.
 */
package com.kotori316.scala_lib;

import java.lang.reflect.Field;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraftforge.eventbus.EventBusErrorMessage;
import net.minecraftforge.eventbus.api.BusBuilder;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.IEventListener;
import net.minecraftforge.fml.AutomaticEventSubscriber;
import net.minecraftforge.fml.LifecycleEventProvider;
import net.minecraftforge.fml.Logging;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModLoadingException;
import net.minecraftforge.fml.ModLoadingStage;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.javafmlmod.FMLModContainer;
import net.minecraftforge.fml.unsafe.UnsafeHacks;
import net.minecraftforge.forgespi.language.IModInfo;
import net.minecraftforge.forgespi.language.ModFileScanData;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;

public class ScalaModContainer
extends ModContainer {
    private static final Logger LOGGER = LogManager.getLogger(ScalaModContainer.class);
    private final IModInfo info;
    private final String className;
    private final ClassLoader modClassLoader;
    private final ModFileScanData scanData;
    private final boolean isScalaObject;
    private final IEventBus eventBus;
    private Class<?> modClass;
    private Object modInstance;

    public ScalaModContainer(IModInfo info, String className, ClassLoader modClassLoader, ModFileScanData modFileScanResults) {
        super(info);
        this.info = info;
        this.className = className;
        this.modClassLoader = modClassLoader;
        LOGGER.debug(Logging.LOADING, "Creating scala container Class: {}, with classLoader {} & {}", (Object)className, (Object)modClassLoader, (Object)((Object)((Object)this)).getClass().getClassLoader());
        this.scanData = modFileScanResults;
        this.isScalaObject = className.endsWith("$");
        this.triggerMap.put(ModLoadingStage.CONSTRUCT, ScalaModContainer.dummy().andThen(this::beforeEvent).andThen(this::constructMod).andThen(this::afterEvent));
        this.triggerMap.put(ModLoadingStage.CREATE_REGISTRIES, ScalaModContainer.dummy().andThen(this::beforeEvent).andThen(this::fireEvent).andThen(this::afterEvent));
        this.triggerMap.put(ModLoadingStage.LOAD_REGISTRIES, ScalaModContainer.dummy().andThen(this::beforeEvent).andThen(this::fireEvent).andThen(this::afterEvent));
        this.triggerMap.put(ModLoadingStage.COMMON_SETUP, ScalaModContainer.dummy().andThen(this::beforeEvent).andThen(this::preInitMod).andThen(this::fireEvent).andThen(this::afterEvent));
        this.triggerMap.put(ModLoadingStage.SIDED_SETUP, ScalaModContainer.dummy().andThen(this::beforeEvent).andThen(this::fireEvent).andThen(this::afterEvent));
        this.triggerMap.put(ModLoadingStage.ENQUEUE_IMC, ScalaModContainer.dummy().andThen(this::beforeEvent).andThen(this::initMod).andThen(this::fireEvent).andThen(this::afterEvent));
        this.triggerMap.put(ModLoadingStage.PROCESS_IMC, ScalaModContainer.dummy().andThen(this::beforeEvent).andThen(this::fireEvent).andThen(this::afterEvent));
        this.triggerMap.put(ModLoadingStage.COMPLETE, ScalaModContainer.dummy().andThen(this::beforeEvent).andThen(this::completeLoading).andThen(this::fireEvent).andThen(this::afterEvent));
        this.triggerMap.put(ModLoadingStage.GATHERDATA, ScalaModContainer.dummy().andThen(this::beforeEvent).andThen(this::fireEvent).andThen(this::afterEvent));
        this.eventBus = BusBuilder.builder().setExceptionHandler(this::onEventFailed).setTrackPhases(false).build();
        this.configHandler = Optional.of(arg_0 -> ((IEventBus)this.eventBus).post(arg_0));
        FMLJavaModLoadingContext contextExtension = ScalaModContainer.createContext(this.eventBus);
        this.contextExtension = () -> contextExtension;
    }

    private void fireEvent(LifecycleEventProvider.LifecycleEvent lifecycleEvent) {
        Event event = lifecycleEvent.getOrBuildEvent((ModContainer)this);
        LOGGER.debug(Logging.LOADING, "Firing event for modid {} : {}", (Object)this.getModId(), (Object)event);
        try {
            this.eventBus.post(event);
            LOGGER.debug(Logging.LOADING, "Fired event for modid {} : {}", (Object)this.getModId(), (Object)event);
        }
        catch (Throwable e) {
            LOGGER.error(Logging.LOADING, "Caught exception during event {} dispatch for modid {}", (Object)event, (Object)this.getModId(), (Object)e);
            throw new ModLoadingException(this.modInfo, lifecycleEvent.fromStage(), "fml.modloading.errorduringevent", e, new Object[0]);
        }
    }

    private void constructMod(LifecycleEventProvider.LifecycleEvent event) {
        if (this.isScalaObject) {
            try {
                this.modClass = Class.forName(this.className, true, this.modClassLoader);
                LOGGER.debug(Logging.LOADING, "Scala Class Loaded {} with {}.", this.modClass, (Object)this.modClass.getClassLoader());
                this.modInstance = this.modClass.getField("MODULE$").get(null);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                LOGGER.error(Logging.LOADING, "Failed to load class {}", (Object)this.className, (Object)e);
                throw new ModLoadingException(this.info, ModLoadingStage.CONSTRUCT, "fml.modloading.failedtoloadmodclass", (Throwable)e, new Object[0]);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                e.printStackTrace();
                LOGGER.error(Logging.LOADING, "Failed to create mod instance. ModID: {}, class {}", (Object)this.getModId(), (Object)this.modClass.getName(), (Object)e);
                throw new ModLoadingException(this.modInfo, event.fromStage(), "fml.modloading.failedtoloadmod", (Throwable)e, new Object[]{this.modClass});
            }
        }
        try {
            this.modClass = Class.forName(this.className, true, this.modClassLoader);
            LOGGER.debug(Logging.LOADING, "Scala Class Loaded {} with {}.", this.modClass, (Object)this.modClass.getClassLoader());
            LOGGER.debug(Logging.LOADING, "Scala Mod instance for {} is about to create. {}", (Object)this.getModId(), (Object)this.modClass.getName());
            this.modInstance = this.modClass.newInstance();
            LOGGER.debug(Logging.LOADING, "Scala Mod instance for {} created. {}", (Object)this.getModId(), this.modInstance);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            LOGGER.error(Logging.LOADING, "Failed to load class {}", (Object)this.className, (Object)e);
            throw new ModLoadingException(this.info, ModLoadingStage.CONSTRUCT, "fml.modloading.failedtoloadmodclass", (Throwable)e, new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException e) {
            e.printStackTrace();
            LOGGER.error(Logging.LOADING, "Failed to create mod instance. ModID: {}, class {}", (Object)this.getModId(), (Object)this.modClass.getName(), (Object)e);
            throw new ModLoadingException(this.modInfo, event.fromStage(), "fml.modloading.failedtoloadmod", (Throwable)e, new Object[]{this.modClass});
        }
        LOGGER.debug(Logging.LOADING, "Injecting Automatic event subscribers for {}", (Object)this.getModId());
        AutomaticEventSubscriber.inject((ModContainer)this, (ModFileScanData)this.scanData, (ClassLoader)this.modClass.getClassLoader());
        LOGGER.debug(Logging.LOADING, "Completed Automatic event subscribers for {}", (Object)this.getModId());
    }

    private void onEventFailed(IEventBus bus, Event event, IEventListener[] listeners, int i, Throwable throwable) {
        LOGGER.error((Message)new EventBusErrorMessage(event, i, listeners, throwable));
    }

    private void preInitMod(LifecycleEventProvider.LifecycleEvent event) {
    }

    private void initMod(LifecycleEventProvider.LifecycleEvent event) {
    }

    private void completeLoading(LifecycleEventProvider.LifecycleEvent event) {
    }

    private void beforeEvent(LifecycleEventProvider.LifecycleEvent event) {
    }

    private void afterEvent(LifecycleEventProvider.LifecycleEvent event) {
        if (this.getCurrentState() == ModLoadingStage.ERROR) {
            LOGGER.error(Logging.LOADING, "An error occurred while dispatching event {} to {}", (Object)event.fromStage(), (Object)this.getModId());
        }
    }

    private static Consumer<LifecycleEventProvider.LifecycleEvent> dummy() {
        return lifecycleEvent -> {};
    }

    public IEventBus getEventBus() {
        return this.eventBus;
    }

    public boolean matches(Object mod) {
        return mod == this.modInstance;
    }

    public Object getMod() {
        return this.modInstance;
    }

    protected void acceptEvent(Event e) {
        this.getEventBus().post(e);
    }

    public static FMLJavaModLoadingContext createContext(IEventBus bus) {
        try {
            FMLJavaModLoadingContext instance = (FMLJavaModLoadingContext)UnsafeHacks.newInstance(FMLJavaModLoadingContext.class);
            FMLModContainer container = (FMLModContainer)UnsafeHacks.newInstance(FMLModContainer.class);
            UnsafeHacks.setField((Field)FMLModContainer.class.getDeclaredField("eventBus"), (Object)container, (Object)bus);
            UnsafeHacks.setField((Field)FMLJavaModLoadingContext.class.getDeclaredField("container"), (Object)instance, (Object)container);
            return instance;
        }
        catch (ReflectiveOperationException e) {
            LOGGER.error("Error happened in creating dummy instance.", (Throwable)e);
            try {
                return (FMLJavaModLoadingContext)Class.forName("com.kotori316.scala_lib.ScalaLoadingContext").getConstructor(IEventBus.class).newInstance(bus);
            }
            catch (ReflectiveOperationException ex) {
                LOGGER.error("Error happened in creating real instance.", (Throwable)ex);
                return null;
            }
        }
    }
}

