/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.tile.craftingmonitor;

import com.raoulvdberge.refinedstorage.RS;
import com.raoulvdberge.refinedstorage.api.autocrafting.ICraftingManager;
import com.raoulvdberge.refinedstorage.api.autocrafting.task.ICraftingTask;
import com.raoulvdberge.refinedstorage.api.network.INetwork;
import com.raoulvdberge.refinedstorage.item.WirelessCraftingMonitorItem;
import com.raoulvdberge.refinedstorage.network.craftingmonitor.WirelessCraftingMonitorSettingsUpdateMessage;
import com.raoulvdberge.refinedstorage.tile.craftingmonitor.ICraftingMonitor;
import com.raoulvdberge.refinedstorage.tile.data.TileDataParameter;
import com.raoulvdberge.refinedstorage.util.NetworkUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.DimensionManager;

public class WirelessCraftingMonitor
implements ICraftingMonitor {
    private ItemStack stack;
    @Nullable
    private MinecraftServer server;
    private DimensionType nodeDimension;
    private BlockPos nodePos;
    private int tabPage;
    private Optional<UUID> tabSelected;
    private int slotId;

    public WirelessCraftingMonitor(ItemStack stack, @Nullable MinecraftServer server, int slotId) {
        this.stack = stack;
        this.server = server;
        this.slotId = slotId;
        this.nodeDimension = WirelessCraftingMonitorItem.getDimension(stack);
        this.nodePos = new BlockPos(WirelessCraftingMonitorItem.getX(stack), WirelessCraftingMonitorItem.getY(stack), WirelessCraftingMonitorItem.getZ(stack));
        this.tabPage = WirelessCraftingMonitorItem.getTabPage(stack);
        this.tabSelected = WirelessCraftingMonitorItem.getTabSelected(stack);
    }

    public void setSettings(Optional<UUID> tabSelected, int tabPage) {
        this.tabSelected = tabSelected;
        this.tabPage = tabPage;
        WirelessCraftingMonitorItem.setTabSelected(this.stack, tabSelected);
        WirelessCraftingMonitorItem.setTabPage(this.stack, tabPage);
    }

    @Override
    public ITextComponent getTitle() {
        return new TranslationTextComponent("gui.refinedstorage.wireless_crafting_monitor", new Object[0]);
    }

    @Override
    public void onCancelled(ServerPlayerEntity player, @Nullable UUID id) {
        INetwork network = this.getNetwork();
        if (network != null) {
            network.getItemGridHandler().onCraftingCancelRequested(player, id);
        }
    }

    @Override
    public TileDataParameter<Integer, ?> getRedstoneModeParameter() {
        return null;
    }

    @Override
    public Collection<ICraftingTask> getTasks() {
        INetwork network = this.getNetwork();
        if (network != null) {
            return network.getCraftingManager().getTasks();
        }
        return Collections.emptyList();
    }

    @Override
    @Nullable
    public ICraftingManager getCraftingManager() {
        INetwork network = this.getNetwork();
        if (network != null) {
            return network.getCraftingManager();
        }
        return null;
    }

    private INetwork getNetwork() {
        ServerWorld world = DimensionManager.getWorld((MinecraftServer)this.server, (DimensionType)this.nodeDimension, (boolean)true, (boolean)true);
        if (world != null) {
            return NetworkUtils.getNetworkFromNode(NetworkUtils.getNodeFromTile(world.func_175625_s(this.nodePos)));
        }
        return null;
    }

    public ItemStack getStack() {
        return this.stack;
    }

    @Override
    public boolean isActiveOnClient() {
        return true;
    }

    @Override
    public void onClosed(PlayerEntity player) {
        INetwork network = this.getNetwork();
        if (network != null) {
            network.getNetworkItemManager().close(player);
        }
    }

    @Override
    public Optional<UUID> getTabSelected() {
        return this.tabSelected;
    }

    @Override
    public int getTabPage() {
        return this.tabPage;
    }

    @Override
    public void onTabSelectionChanged(Optional<UUID> taskId) {
        this.tabSelected = taskId.isPresent() && this.tabSelected.isPresent() && taskId.get().equals(this.tabSelected.get()) ? Optional.empty() : taskId;
        RS.NETWORK_HANDLER.sendToServer(new WirelessCraftingMonitorSettingsUpdateMessage(this.tabSelected, this.tabPage));
    }

    @Override
    public void onTabPageChanged(int page) {
        if (page >= 0) {
            this.tabPage = page;
            RS.NETWORK_HANDLER.sendToServer(new WirelessCraftingMonitorSettingsUpdateMessage(this.tabSelected, this.tabPage));
        }
    }

    @Override
    public int getSlotId() {
        return this.slotId;
    }
}

