/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.screen.grid.filtering;

import com.raoulvdberge.refinedstorage.api.network.grid.IGrid;
import com.raoulvdberge.refinedstorage.api.util.IFilter;
import com.raoulvdberge.refinedstorage.screen.grid.filtering.CraftableGridFilter;
import com.raoulvdberge.refinedstorage.screen.grid.filtering.FilterGridFilter;
import com.raoulvdberge.refinedstorage.screen.grid.filtering.ModGridFilter;
import com.raoulvdberge.refinedstorage.screen.grid.filtering.NameGridFilter;
import com.raoulvdberge.refinedstorage.screen.grid.filtering.OrGridFilter;
import com.raoulvdberge.refinedstorage.screen.grid.filtering.TagGridFilter;
import com.raoulvdberge.refinedstorage.screen.grid.filtering.TooltipGridFilter;
import com.raoulvdberge.refinedstorage.screen.grid.stack.IGridStack;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;

public final class GridFilterParser {
    public static List<Predicate<IGridStack>> getFilters(@Nullable IGrid grid, String query, List<IFilter> filters) {
        List<Predicate<IGridStack>> gridFilters;
        String[] orParts = query.split("\\|");
        if (orParts.length == 1) {
            gridFilters = GridFilterParser.getFilters(query);
        } else {
            LinkedList<List<Predicate<IGridStack>>> orPartFilters = new LinkedList<List<Predicate<IGridStack>>>();
            for (String orPart : orParts) {
                orPartFilters.add(GridFilterParser.getFilters(orPart));
            }
            gridFilters = new LinkedList<Predicate<IGridStack>>();
            gridFilters.add(new OrGridFilter(orPartFilters));
        }
        if (grid != null) {
            if (grid.getViewType() == 1) {
                gridFilters.add(new CraftableGridFilter(false));
            } else if (grid.getViewType() == 2) {
                gridFilters.add(new CraftableGridFilter(true));
            }
        }
        if (!filters.isEmpty()) {
            gridFilters.add(new FilterGridFilter(filters));
        }
        return gridFilters;
    }

    private static List<Predicate<IGridStack>> getFilters(String query) {
        LinkedList<Predicate<IGridStack>> gridFilters = new LinkedList<Predicate<IGridStack>>();
        for (String part : query.toLowerCase().trim().split(" ")) {
            if (part.startsWith("@")) {
                gridFilters.add(new ModGridFilter(part.substring(1)));
                continue;
            }
            if (part.startsWith("#")) {
                gridFilters.add(new TooltipGridFilter(part.substring(1)));
                continue;
            }
            if (part.startsWith("$")) {
                gridFilters.add(new TagGridFilter(part.substring(1)));
                continue;
            }
            gridFilters.add(new NameGridFilter(part));
        }
        return gridFilters;
    }
}

