/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.storage.disk;

import com.raoulvdberge.refinedstorage.RS;
import com.raoulvdberge.refinedstorage.api.storage.disk.IStorageDiskSync;
import com.raoulvdberge.refinedstorage.api.storage.disk.StorageDiskSyncData;
import com.raoulvdberge.refinedstorage.network.disk.StorageDiskSizeRequestMessage;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;

public class StorageDiskSync
implements IStorageDiskSync {
    private static final int THROTTLE_MS = 500;
    private Map<UUID, StorageDiskSyncData> data = new HashMap<UUID, StorageDiskSyncData>();
    private Map<UUID, Long> syncTime = new HashMap<UUID, Long>();

    @Override
    @Nullable
    public StorageDiskSyncData getData(UUID id) {
        return this.data.get(id);
    }

    public void setData(UUID id, StorageDiskSyncData data) {
        this.data.put(id, data);
    }

    @Override
    public void sendRequest(UUID id) {
        long lastSync = this.syncTime.getOrDefault(id, 0L);
        if (System.currentTimeMillis() - lastSync > 500L) {
            RS.NETWORK_HANDLER.sendToServer(new StorageDiskSizeRequestMessage(id));
            this.syncTime.put(id, System.currentTimeMillis());
        }
    }
}

