/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.network.node;

import com.raoulvdberge.refinedstorage.api.network.INetwork;
import com.raoulvdberge.refinedstorage.api.network.INetworkNodeVisitor;
import com.raoulvdberge.refinedstorage.api.network.node.INetworkNode;
import com.raoulvdberge.refinedstorage.api.util.Action;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.ConnectivityStateChangeCause;
import com.raoulvdberge.refinedstorage.block.BaseBlock;
import com.raoulvdberge.refinedstorage.block.NetworkNodeBlock;
import com.raoulvdberge.refinedstorage.tile.config.RedstoneMode;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.items.IItemHandler;

public abstract class NetworkNode
implements INetworkNode,
INetworkNodeVisitor {
    private static final String NBT_OWNER = "Owner";
    private static final String NBT_VERSION = "Version";
    private static final int VERSION = 1;
    @Nullable
    protected INetwork network;
    protected World world;
    protected BlockPos pos;
    protected int ticks;
    protected RedstoneMode redstoneMode = RedstoneMode.IGNORE;
    @Nullable
    protected UUID owner;
    protected String version;
    private Direction direction;
    private boolean throttlingDisabled = true;
    private boolean couldUpdate;
    private int ticksSinceUpdateChanged;

    public NetworkNode(World world, BlockPos pos) {
        if (world == null) {
            throw new IllegalArgumentException("World cannot be null");
        }
        this.world = world;
        this.pos = pos;
    }

    public RedstoneMode getRedstoneMode() {
        return this.redstoneMode;
    }

    public void setRedstoneMode(RedstoneMode redstoneMode) {
        this.redstoneMode = redstoneMode;
        this.markDirty();
    }

    @Override
    @Nonnull
    public ItemStack getItemStack() {
        return new ItemStack((IItemProvider)Item.field_179220_a.get(this.world.func_180495_p(this.pos).func_177230_c()), 1);
    }

    @Override
    public void onConnected(INetwork network) {
        this.onConnectedStateChange(network, true, ConnectivityStateChangeCause.GRAPH_CHANGE);
        this.network = network;
    }

    @Override
    public void onDisconnected(INetwork network) {
        this.network = null;
        this.onConnectedStateChange(network, false, ConnectivityStateChangeCause.GRAPH_CHANGE);
    }

    protected void onConnectedStateChange(INetwork network, boolean state, ConnectivityStateChangeCause cause) {
    }

    @Override
    public void markDirty() {
        if (!this.world.field_72995_K) {
            API.instance().getNetworkNodeManager((ServerWorld)this.world).markForSaving();
        }
    }

    @Override
    public boolean isActive() {
        return this.redstoneMode.isEnabled(this.world, this.pos);
    }

    protected final boolean canUpdate() {
        if (this.isActive() && this.network != null) {
            return this.network.canRun();
        }
        return false;
    }

    protected int getUpdateThrottleInactiveToActive() {
        return 20;
    }

    protected int getUpdateThrottleActiveToInactive() {
        return 4;
    }

    @Override
    public void update() {
        ++this.ticks;
        boolean canUpdate = this.canUpdate();
        if (this.couldUpdate != canUpdate) {
            ++this.ticksSinceUpdateChanged;
            if ((!canUpdate ? this.ticksSinceUpdateChanged > this.getUpdateThrottleActiveToInactive() : this.ticksSinceUpdateChanged > this.getUpdateThrottleInactiveToActive()) || this.throttlingDisabled) {
                this.ticksSinceUpdateChanged = 0;
                this.couldUpdate = canUpdate;
                this.throttlingDisabled = false;
                BlockState blockState = this.world.func_180495_p(this.pos);
                if (blockState.func_177230_c() instanceof NetworkNodeBlock && ((NetworkNodeBlock)blockState.func_177230_c()).hasConnectedState()) {
                    this.world.func_175656_a(this.pos, (BlockState)this.world.func_180495_p(this.pos).func_206870_a((IProperty)NetworkNodeBlock.CONNECTED, (Comparable)Boolean.valueOf(canUpdate)));
                }
                if (this.network != null) {
                    this.onConnectedStateChange(this.network, canUpdate, ConnectivityStateChangeCause.REDSTONE_MODE_OR_NETWORK_ENERGY_CHANGE);
                    if (this.shouldRebuildGraphOnChange()) {
                        this.network.getNodeGraph().invalidate(Action.PERFORM, this.network.getWorld(), this.network.getPosition());
                    }
                }
            }
        } else {
            this.ticksSinceUpdateChanged = 0;
        }
    }

    @Override
    public CompoundNBT write(CompoundNBT tag) {
        if (this.owner != null) {
            tag.func_186854_a(NBT_OWNER, this.owner);
        }
        tag.func_74768_a(NBT_VERSION, 1);
        this.writeConfiguration(tag);
        return tag;
    }

    public CompoundNBT writeConfiguration(CompoundNBT tag) {
        this.redstoneMode.write(tag);
        return tag;
    }

    public void read(CompoundNBT tag) {
        if (tag.func_186855_b(NBT_OWNER)) {
            this.owner = tag.func_186857_a(NBT_OWNER);
        }
        if (tag.func_74764_b(NBT_VERSION)) {
            this.version = tag.func_74779_i(NBT_VERSION);
        }
        this.readConfiguration(tag);
    }

    public void readConfiguration(CompoundNBT tag) {
        this.redstoneMode = RedstoneMode.read(tag);
    }

    @Override
    @Nullable
    public INetwork getNetwork() {
        return this.network;
    }

    @Override
    public BlockPos getPos() {
        return this.pos;
    }

    @Override
    public World getWorld() {
        return this.world;
    }

    public boolean canConduct(@Nullable Direction direction) {
        return true;
    }

    @Override
    public void visit(INetworkNodeVisitor.Operator operator) {
        for (Direction facing : Direction.values()) {
            if (!this.canConduct(facing)) continue;
            operator.apply(this.world, this.pos.func_177972_a(facing), facing.func_176734_d());
        }
    }

    @Nullable
    public TileEntity getFacingTile() {
        return this.world.func_175625_s(this.pos.func_177972_a(this.getDirection()));
    }

    public Direction getDirection() {
        BlockState state;
        if (this.direction == null && (state = this.world.func_180495_p(this.pos)).func_177230_c() instanceof BaseBlock) {
            this.direction = (Direction)state.func_177229_b((IProperty)((BaseBlock)state.func_177230_c()).getDirection().getProperty());
        }
        return this.direction;
    }

    public void onDirectionChanged(Direction direction) {
        this.direction = direction;
    }

    @Nullable
    public IItemHandler getDrops() {
        return null;
    }

    public boolean shouldRebuildGraphOnChange() {
        return false;
    }

    @Override
    public void setOwner(@Nullable UUID owner) {
        this.owner = owner;
        this.markDirty();
    }

    @Override
    @Nullable
    public UUID getOwner() {
        return this.owner;
    }

    public boolean equals(Object o) {
        return API.instance().isNetworkNodeEqual(this, o);
    }

    public int hashCode() {
        return API.instance().getNetworkNodeHashCode(this);
    }
}

