/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.autocrafting;

import com.raoulvdberge.refinedstorage.api.autocrafting.ICraftingManager;
import com.raoulvdberge.refinedstorage.api.autocrafting.ICraftingPattern;
import com.raoulvdberge.refinedstorage.api.autocrafting.ICraftingPatternChainList;
import com.raoulvdberge.refinedstorage.api.autocrafting.ICraftingPatternContainer;
import com.raoulvdberge.refinedstorage.api.autocrafting.craftingmonitor.ICraftingMonitorListener;
import com.raoulvdberge.refinedstorage.api.autocrafting.task.CraftingTaskReadException;
import com.raoulvdberge.refinedstorage.api.autocrafting.task.ICraftingTask;
import com.raoulvdberge.refinedstorage.api.autocrafting.task.ICraftingTaskError;
import com.raoulvdberge.refinedstorage.api.autocrafting.task.ICraftingTaskFactory;
import com.raoulvdberge.refinedstorage.api.network.INetwork;
import com.raoulvdberge.refinedstorage.api.network.node.INetworkNode;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import com.raoulvdberge.refinedstorage.apiimpl.autocrafting.CraftingPatternChainList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CraftingManager
implements ICraftingManager {
    private static final int THROTTLE_DELAY_MS = 3000;
    private static final Logger LOGGER = LogManager.getLogger(CraftingManager.class);
    private static final String NBT_TASKS = "Tasks";
    private static final String NBT_TASK_TYPE = "Type";
    private static final String NBT_TASK_DATA = "Task";
    private INetwork network;
    private Map<ITextComponent, List<IItemHandlerModifiable>> containerInventories = new LinkedHashMap<ITextComponent, List<IItemHandlerModifiable>>();
    private Map<ICraftingPattern, Set<ICraftingPatternContainer>> patternToContainer = new HashMap<ICraftingPattern, Set<ICraftingPatternContainer>>();
    private List<ICraftingPattern> patterns = new ArrayList<ICraftingPattern>();
    private Map<UUID, ICraftingTask> tasks = new LinkedHashMap<UUID, ICraftingTask>();
    private List<ICraftingTask> tasksToAdd = new ArrayList<ICraftingTask>();
    private List<UUID> tasksToCancel = new ArrayList<UUID>();
    private ListNBT tasksToRead;
    private Map<Object, Long> throttledRequesters = new HashMap<Object, Long>();
    private Set<ICraftingMonitorListener> listeners = new HashSet<ICraftingMonitorListener>();

    public CraftingManager(INetwork network) {
        this.network = network;
    }

    @Override
    public Collection<ICraftingTask> getTasks() {
        return this.tasks.values();
    }

    @Override
    @Nullable
    public ICraftingTask getTask(UUID id) {
        return this.tasks.get(id);
    }

    @Override
    public Map<ITextComponent, List<IItemHandlerModifiable>> getNamedContainers() {
        return this.containerInventories;
    }

    @Override
    public void add(@Nonnull ICraftingTask task) {
        this.tasksToAdd.add(task);
        this.network.markDirty();
    }

    @Override
    public void cancel(@Nullable UUID id) {
        if (id == null) {
            this.tasksToCancel.addAll(this.tasks.keySet());
        } else {
            this.tasksToCancel.add(id);
        }
        this.network.markDirty();
    }

    @Override
    @Nullable
    public ICraftingTask create(ItemStack stack, int quantity) {
        ICraftingPattern pattern = this.getPattern(stack);
        if (pattern == null) {
            return null;
        }
        ICraftingTaskFactory factory = API.instance().getCraftingTaskRegistry().get(pattern.getCraftingTaskFactoryId());
        if (factory == null) {
            return null;
        }
        return factory.create(this.network, API.instance().createCraftingRequestInfo(stack), quantity, pattern);
    }

    @Override
    @Nullable
    public ICraftingTask create(FluidStack stack, int quantity) {
        ICraftingPattern pattern = this.getPattern(stack);
        if (pattern == null) {
            return null;
        }
        ICraftingTaskFactory factory = API.instance().getCraftingTaskRegistry().get(pattern.getCraftingTaskFactoryId());
        if (factory == null) {
            return null;
        }
        return factory.create(this.network, API.instance().createCraftingRequestInfo(stack), quantity, pattern);
    }

    @Override
    public ICraftingPatternChainList createPatternChainList() {
        return new CraftingPatternChainList(this.patterns);
    }

    @Override
    public void update() {
        if (this.network.canRun()) {
            if (this.tasksToRead != null) {
                for (int i = 0; i < this.tasksToRead.size(); ++i) {
                    CompoundNBT taskTag = this.tasksToRead.func_150305_b(i);
                    ResourceLocation taskType = new ResourceLocation(taskTag.func_74779_i(NBT_TASK_TYPE));
                    CompoundNBT taskData = taskTag.func_74775_l(NBT_TASK_DATA);
                    ICraftingTaskFactory factory = API.instance().getCraftingTaskRegistry().get(taskType);
                    if (factory == null) continue;
                    try {
                        ICraftingTask task = factory.createFromNbt(this.network, taskData);
                        this.tasks.put(task.getId(), task);
                        continue;
                    }
                    catch (CraftingTaskReadException e) {
                        LOGGER.error("Could not deserialize crafting task", (Throwable)e);
                    }
                }
                this.tasksToRead = null;
            }
            boolean changed = !this.tasksToCancel.isEmpty() || !this.tasksToAdd.isEmpty();
            for (UUID idToCancel : this.tasksToCancel) {
                if (!this.tasks.containsKey(idToCancel)) continue;
                this.tasks.get(idToCancel).onCancelled();
                this.tasks.remove(idToCancel);
            }
            this.tasksToCancel.clear();
            for (ICraftingTask task : this.tasksToAdd) {
                this.tasks.put(task.getId(), task);
            }
            this.tasksToAdd.clear();
            boolean anyFinished = false;
            Iterator<Map.Entry<UUID, ICraftingTask>> it = this.tasks.entrySet().iterator();
            while (it.hasNext()) {
                ICraftingTask task = it.next().getValue();
                if (!task.update()) continue;
                anyFinished = true;
                it.remove();
            }
            if (changed || anyFinished) {
                this.onTaskChanged();
            }
            if (!this.tasks.isEmpty()) {
                this.network.markDirty();
            }
        }
    }

    @Override
    public void readFromNbt(CompoundNBT tag) {
        this.tasksToRead = tag.func_150295_c(NBT_TASKS, 10);
    }

    @Override
    public CompoundNBT writeToNbt(CompoundNBT tag) {
        ListNBT list = new ListNBT();
        for (ICraftingTask task : this.tasks.values()) {
            CompoundNBT taskTag = new CompoundNBT();
            taskTag.func_74778_a(NBT_TASK_TYPE, task.getPattern().getCraftingTaskFactoryId().toString());
            taskTag.func_218657_a(NBT_TASK_DATA, (INBT)task.writeToNbt(new CompoundNBT()));
            list.add((Object)taskTag);
        }
        tag.func_218657_a(NBT_TASKS, (INBT)list);
        return tag;
    }

    @Override
    public void addListener(ICraftingMonitorListener listener) {
        this.listeners.add(listener);
        listener.onAttached();
    }

    @Override
    public void removeListener(ICraftingMonitorListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void onTaskChanged() {
        this.listeners.forEach(ICraftingMonitorListener::onChanged);
    }

    @Override
    @Nullable
    public ICraftingTask request(Object source, ItemStack stack, int amount) {
        if (this.isThrottled(source)) {
            return null;
        }
        for (ICraftingTask task : this.getTasks()) {
            if (task.getRequested().getItem() == null || !API.instance().getComparer().isEqualNoQuantity(task.getRequested().getItem(), stack)) continue;
            amount -= task.getQuantity();
        }
        if (amount > 0) {
            ICraftingTask task = this.create(stack, amount);
            if (task != null) {
                ICraftingTaskError error = task.calculate();
                if (error == null && !task.hasMissing()) {
                    this.add(task);
                    return task;
                }
                this.throttle(source);
            } else {
                this.throttle(source);
            }
        }
        return null;
    }

    @Override
    @Nullable
    public ICraftingTask request(Object source, FluidStack stack, int amount) {
        if (this.isThrottled(source)) {
            return null;
        }
        for (ICraftingTask task : this.getTasks()) {
            if (task.getRequested().getFluid() == null || !API.instance().getComparer().isEqual(task.getRequested().getFluid(), stack, 1)) continue;
            amount -= task.getQuantity();
        }
        if (amount > 0) {
            ICraftingTask task = this.create(stack, amount);
            if (task != null) {
                ICraftingTaskError error = task.calculate();
                if (error == null && !task.hasMissing()) {
                    this.add(task);
                    return task;
                }
                this.throttle(source);
            } else {
                this.throttle(source);
            }
        }
        return null;
    }

    private void throttle(Object source) {
        if (source != null) {
            this.throttledRequesters.put(source, System.currentTimeMillis());
        }
    }

    private boolean isThrottled(Object source) {
        if (source == null) {
            return false;
        }
        Long throttledSince = this.throttledRequesters.get(source);
        if (throttledSince == null) {
            return false;
        }
        return System.currentTimeMillis() - throttledSince < 3000L;
    }

    @Override
    public int track(@Nonnull ItemStack stack, int size) {
        if (stack.func_190926_b()) {
            return 0;
        }
        for (ICraftingTask task : this.tasks.values()) {
            size = task.onTrackedInsert(stack, size);
            if (size != 0) continue;
            return 0;
        }
        return size;
    }

    @Override
    public int track(@Nonnull FluidStack stack, int size) {
        if (stack.isEmpty()) {
            return 0;
        }
        for (ICraftingTask task : this.tasks.values()) {
            size = task.onTrackedInsert(stack, size);
            if (size != 0) continue;
            return 0;
        }
        return size;
    }

    @Override
    public List<ICraftingPattern> getPatterns() {
        return this.patterns;
    }

    @Override
    public void invalidate() {
        this.network.getItemStorageCache().getCraftablesList().clear();
        this.network.getFluidStorageCache().getCraftablesList().clear();
        this.patterns.clear();
        this.containerInventories.clear();
        this.patternToContainer.clear();
        ArrayList<ICraftingPatternContainer> containers = new ArrayList<ICraftingPatternContainer>();
        for (INetworkNode node : this.network.getNodeGraph().all()) {
            if (!(node instanceof ICraftingPatternContainer) || !node.isActive()) continue;
            containers.add((ICraftingPatternContainer)((Object)node));
        }
        containers.sort((a, b) -> b.getPosition().compareTo((Vec3i)a.getPosition()));
        for (ICraftingPatternContainer container : containers) {
            for (ICraftingPattern pattern : container.getPatterns()) {
                this.patterns.add(pattern);
                for (ItemStack output : pattern.getOutputs()) {
                    this.network.getItemStorageCache().getCraftablesList().add(output);
                }
                for (ItemStack output : pattern.getFluidOutputs()) {
                    this.network.getFluidStorageCache().getCraftablesList().add((FluidStack)output);
                }
                Set<ICraftingPatternContainer> list = this.patternToContainer.get(pattern);
                if (list == null) {
                    list = new LinkedHashSet<ICraftingPatternContainer>();
                }
                list.add(container);
                this.patternToContainer.put(pattern, list);
            }
            IItemHandlerModifiable handler = container.getPatternInventory();
            if (handler == null) continue;
            this.containerInventories.computeIfAbsent(container.getName(), k -> new ArrayList()).add(handler);
        }
        this.network.getItemStorageCache().reAttachListeners();
        this.network.getFluidStorageCache().reAttachListeners();
    }

    @Override
    public Set<ICraftingPatternContainer> getAllContainer(ICraftingPattern pattern) {
        return this.patternToContainer.getOrDefault(pattern, new LinkedHashSet());
    }

    @Override
    @Nullable
    public ICraftingPattern getPattern(ItemStack pattern) {
        for (ICraftingPattern patternInList : this.patterns) {
            for (ItemStack output : patternInList.getOutputs()) {
                if (!API.instance().getComparer().isEqualNoQuantity(output, pattern)) continue;
                return patternInList;
            }
        }
        return null;
    }

    @Override
    @Nullable
    public ICraftingPattern getPattern(FluidStack pattern) {
        for (ICraftingPattern patternInList : this.patterns) {
            for (FluidStack output : patternInList.getFluidOutputs()) {
                if (!API.instance().getComparer().isEqual(output, pattern, 1)) continue;
                return patternInList;
            }
        }
        return null;
    }
}

