/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.netherportalfix;

import javax.annotation.Nullable;
import net.minecraft.block.Blocks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SPlayEntityEffectPacket;
import net.minecraft.potion.EffectInstance;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityTravelToDimensionEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="netherportalfix")
public class NetherPortalFix {
    private static final Logger logger = LogManager.getLogger();
    private static final int MAX_PORTAL_DISTANCE_SQ = 16;
    private static final String NETHER_PORTAL_FIX = "NetherPortalFix";
    private static final String SCHEDULED_TELEPORT = "NPFScheduledTeleport";
    private static final String FROM = "From";
    private static final String FROM_DIM = "FromDim";
    private static final String TO = "To";
    private static final String TO_DIM = "ToDim";

    public NetherPortalFix() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onEntityTravelToDimension(EntityTravelToDimensionEvent event) {
        if (event.getEntity() instanceof ServerPlayerEntity) {
            boolean isTeleportBetweenNetherAndOverworld;
            PlayerEntity player = (PlayerEntity)event.getEntity();
            if (player.getPersistentData().func_74764_b(SCHEDULED_TELEPORT)) {
                logger.debug("Skipping EntityTravelToDimensionEvent as we triggered it");
                return;
            }
            BlockPos fromPos = player.field_184620_bC;
            DimensionType fromDim = event.getEntity().field_71093_bK;
            DimensionType toDim = event.getDimension();
            boolean isPlayerCurrentlyInPortal = player.field_71087_bX;
            boolean bl = isTeleportBetweenNetherAndOverworld = fromDim == DimensionType.field_223227_a_ && toDim == DimensionType.field_223228_b_ || fromDim == DimensionType.field_223228_b_ && toDim == DimensionType.field_223227_a_;
            if (isPlayerCurrentlyInPortal && isTeleportBetweenNetherAndOverworld) {
                ListNBT portalList = this.getPlayerPortalList(player);
                CompoundNBT returnPortal = this.findReturnPortal(portalList, fromPos, fromDim);
                if (returnPortal != null) {
                    MinecraftServer server = player.func_130014_f_().func_73046_m();
                    if (server != null) {
                        boolean foundNetherPortalAtTargetLocation;
                        BlockPos tryPos;
                        ServerWorld toWorld = server.func_71218_a(toDim);
                        BlockPos toPos = BlockPos.func_218283_e((long)returnPortal.func_74763_f(TO));
                        while (toWorld.func_180495_p(tryPos = toPos.func_177972_a(Direction.DOWN)).func_177230_c() == Blocks.field_150427_aO) {
                            toPos = tryPos;
                        }
                        boolean bl2 = foundNetherPortalAtTargetLocation = toWorld.func_180495_p(toPos).func_177230_c() == Blocks.field_150427_aO;
                        if (foundNetherPortalAtTargetLocation) {
                            CompoundNBT tagCompound = new CompoundNBT();
                            ResourceLocation dimensionRegistryName = DimensionType.func_212678_a((DimensionType)toDim);
                            tagCompound.func_74778_a(TO_DIM, String.valueOf(dimensionRegistryName));
                            tagCompound.func_74772_a(TO, toPos.func_218275_a());
                            player.getPersistentData().func_218657_a(SCHEDULED_TELEPORT, (INBT)tagCompound);
                            logger.debug("Found return portal, scheduling teleport");
                            event.setCanceled(true);
                        } else {
                            player.func_146105_b((ITextComponent)new TranslationTextComponent("netherportalfix:portal_destroyed", new Object[0]), true);
                            this.removeReturnPortal(portalList, returnPortal);
                        }
                    }
                } else {
                    logger.debug("No return portal found");
                }
            }
        }
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        CompoundNBT entityData;
        if (event.phase == TickEvent.Phase.END && event.side == LogicalSide.SERVER && (entityData = event.player.getPersistentData()).func_74764_b(SCHEDULED_TELEPORT)) {
            MinecraftServer server;
            CompoundNBT data = entityData.func_74775_l(SCHEDULED_TELEPORT);
            DimensionType toDim = DimensionType.func_193417_a((ResourceLocation)new ResourceLocation(data.func_74779_i(TO_DIM)));
            if (toDim == null) {
                toDim = DimensionType.field_223227_a_;
            }
            if ((server = event.player.func_130014_f_().func_73046_m()) != null) {
                BlockPos pos = BlockPos.func_218283_e((long)data.func_74763_f(TO));
                ServerWorld toWorld = server.func_71218_a(toDim);
                this.teleport((ServerPlayerEntity)event.player, pos, toWorld);
                event.player.field_71087_bX = false;
            }
            entityData.func_82580_o(SCHEDULED_TELEPORT);
        }
    }

    private void teleport(ServerPlayerEntity player, BlockPos pos, ServerWorld toWorld) {
        player.func_200619_a(toWorld, (double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 0.5f), (double)((float)pos.func_177952_p() + 0.5f), player.field_70177_z, player.field_70125_A);
        for (EffectInstance effectinstance : player.func_70651_bq()) {
            player.field_71135_a.func_147359_a((IPacket)new SPlayEntityEffectPacket(player.func_145782_y(), effectinstance));
        }
        player.func_195399_b(player.field_71068_ca);
    }

    @SubscribeEvent
    public void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        if (event.getFrom() == DimensionType.field_223227_a_ && event.getTo() == DimensionType.field_223228_b_ || event.getFrom() == DimensionType.field_223228_b_ && event.getTo() == DimensionType.field_223227_a_) {
            PlayerEntity player = event.getPlayer();
            BlockPos fromPos = this.findPortalAt(player, event.getFrom(), player.field_184620_bC);
            BlockPos toPos = player.func_180425_c();
            if (fromPos != null) {
                ListNBT portalList = this.getPlayerPortalList(player);
                this.storeReturnPortal(portalList, toPos, event.getTo(), fromPos);
                logger.debug("Storing return portal from " + event.getTo() + " to " + fromPos + " in " + event.getFrom());
            } else {
                logger.debug("Not storing return portal because I'm not in a portal.");
            }
        } else {
            logger.debug("Not storing return portal because it's from " + event.getFrom() + " to " + event.getTo());
        }
    }

    private BlockPos findPortalAt(PlayerEntity player, DimensionType dimensionType, BlockPos pos) {
        MinecraftServer server = player.field_70170_p.func_73046_m();
        if (server != null) {
            ServerWorld fromWorld = server.func_71218_a(dimensionType);
            if (fromWorld.func_180495_p(pos).func_177230_c() == Blocks.field_150427_aO) {
                return pos;
            }
            for (Direction value : Direction.values()) {
                BlockPos offsetPos = pos.func_177972_a(value);
                if (fromWorld.func_180495_p(offsetPos).func_177230_c() != Blocks.field_150427_aO) continue;
                return offsetPos;
            }
        }
        return null;
    }

    private ListNBT getPlayerPortalList(PlayerEntity player) {
        CompoundNBT data = player.getPersistentData().func_74775_l("PlayerPersisted");
        ListNBT list = data.func_150295_c(NETHER_PORTAL_FIX, 10);
        data.func_218657_a(NETHER_PORTAL_FIX, (INBT)list);
        player.getPersistentData().func_218657_a("PlayerPersisted", (INBT)data);
        return list;
    }

    @Nullable
    private CompoundNBT findReturnPortal(ListNBT portalList, BlockPos triggerPos, DimensionType triggerDim) {
        for (INBT entry : portalList) {
            BlockPos portalTrigger;
            CompoundNBT portal = (CompoundNBT)entry;
            DimensionType fromDim = DimensionType.func_193417_a((ResourceLocation)new ResourceLocation(portal.func_74779_i(FROM_DIM)));
            if (fromDim != triggerDim || !((portalTrigger = BlockPos.func_218283_e((long)portal.func_74763_f(FROM))).func_177951_i((Vec3i)triggerPos) <= 16.0)) continue;
            return portal;
        }
        return null;
    }

    private void storeReturnPortal(ListNBT portalList, BlockPos triggerPos, DimensionType triggerDim, BlockPos returnPos) {
        CompoundNBT found = this.findReturnPortal(portalList, triggerPos, triggerDim);
        if (found == null) {
            CompoundNBT portalCompound = new CompoundNBT();
            portalCompound.func_74772_a(FROM, triggerPos.func_218275_a());
            ResourceLocation dimensionRegistryName = DimensionType.func_212678_a((DimensionType)triggerDim);
            portalCompound.func_74778_a(FROM_DIM, String.valueOf(dimensionRegistryName));
            portalCompound.func_74772_a(TO, returnPos.func_218275_a());
            portalList.add((Object)portalCompound);
        } else {
            BlockPos portalReturnPos = BlockPos.func_218283_e((long)found.func_74763_f(TO));
            if (portalReturnPos.func_177951_i((Vec3i)returnPos) > 16.0) {
                found.func_74772_a(TO, returnPos.func_218275_a());
            }
        }
    }

    private void removeReturnPortal(ListNBT portalList, CompoundNBT portal) {
        for (int i = 0; i < portalList.size(); ++i) {
            if (portalList.get(i) != portal) continue;
            portalList.remove(i);
            break;
        }
    }
}

