/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.various;

import java.util.ArrayList;
import java.util.List;
import mcjty.rftoolsutility.modules.logic.blocks.SequencerTileEntity;
import mcjty.rftoolsutility.modules.logic.blocks.TimerTileEntity;
import net.minecraft.world.dimension.DimensionType;

public class TickOrderHandler {
    private static List<SequencerTileEntity> sequencers = new ArrayList<SequencerTileEntity>();
    private static List<TimerTileEntity> timers = new ArrayList<TimerTileEntity>();

    private TickOrderHandler() {
    }

    public static void clean() {
        sequencers.clear();
        timers.clear();
    }

    public static void queueSequencer(SequencerTileEntity sequencer) {
        sequencers.add(sequencer);
    }

    public static void queueTimer(TimerTileEntity timer) {
        timers.add(timer);
    }

    private static <T extends ICheckStateServer> List<T> checkStateServer(DimensionType dimension, List<T> tileEntities) {
        ArrayList<ICheckStateServer> remainingTes = new ArrayList<ICheckStateServer>();
        for (ICheckStateServer tileEntity : tileEntities) {
            if (tileEntity.getDimension() == dimension) {
                tileEntity.checkStateServer();
                continue;
            }
            remainingTes.add(tileEntity);
        }
        return remainingTes;
    }

    public static void postWorldTick(DimensionType dimension) {
        timers = TickOrderHandler.checkStateServer(dimension, timers);
        sequencers = TickOrderHandler.checkStateServer(dimension, sequencers);
    }

    public static interface ICheckStateServer {
        public void checkStateServer();

        public DimensionType getDimension();
    }
}

