/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.logic.blocks;

import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.api.container.CapabilityContainerProvider;
import mcjty.lib.api.container.DefaultContainerProvider;
import mcjty.lib.blocks.LogicSlabBlock;
import mcjty.lib.builder.BlockBuilder;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.compat.theoneprobe.TOPDriver;
import mcjty.lib.container.ContainerFactory;
import mcjty.lib.container.EmptyContainer;
import mcjty.lib.container.GenericContainer;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.tileentity.LogicTileEntity;
import mcjty.lib.typed.Key;
import mcjty.lib.typed.Type;
import mcjty.lib.typed.TypedMap;
import mcjty.lib.varia.LogicFacing;
import mcjty.rftoolsutility.compat.RFToolsUtilityTOPDriver;
import mcjty.rftoolsutility.modules.logic.LogicBlockSetup;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;

public class ThreeLogicTileEntity
extends LogicTileEntity {
    public static final String CMD_SETSTATE = "logic.setState";
    public static final Key<Integer> PARAM_INDEX = new Key("index", Type.INTEGER);
    public static final Key<Integer> PARAM_STATE = new Key("state", Type.INTEGER);
    private int[] logicTable = new int[]{0, 0, 0, 0, 0, 0, 0, 0};
    private LazyOptional<INamedContainerProvider> screenHandler = LazyOptional.of(() -> new DefaultContainerProvider("Logic").containerSupplier((windowId, player) -> new GenericContainer((ContainerType)LogicBlockSetup.CONTAINER_LOGIC.get(), windowId.intValue(), (ContainerFactory)EmptyContainer.CONTAINER_FACTORY.get(), this.func_174877_v(), (GenericTileEntity)this)));
    private static Set<BlockPos> loopDetector = new HashSet<BlockPos>();

    public static LogicSlabBlock createBlock() {
        return new LogicSlabBlock(new BlockBuilder().topDriver((TOPDriver)RFToolsUtilityTOPDriver.DRIVER).info(new InfoLine[]{TooltipBuilder.key((String)"message.rftoolsutility.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header()}).tileEntitySupplier(ThreeLogicTileEntity::new));
    }

    public ThreeLogicTileEntity() {
        super((TileEntityType)LogicBlockSetup.TYPE_LOGIC.get());
    }

    public int getState(int index) {
        return this.logicTable[index];
    }

    public void checkRedstone() {
        int s = this.logicTable[this.powerLevel];
        if (s == -1) {
            return;
        }
        this.setRedstoneState(s == 1 ? 15 : 0);
    }

    public void func_145839_a(CompoundNBT tagCompound) {
        super.func_145839_a(tagCompound);
        this.powerOutput = tagCompound.func_74767_n("rs") ? 15 : 0;
    }

    public void readInfo(CompoundNBT tagCompound) {
        super.readInfo(tagCompound);
        CompoundNBT info = tagCompound.func_74775_l("Info");
        for (int i = 0; i < 8; ++i) {
            this.logicTable[i] = info.func_74762_e("state" + i);
        }
    }

    public CompoundNBT func_189515_b(CompoundNBT tagCompound) {
        super.func_189515_b(tagCompound);
        tagCompound.func_74757_a("rs", this.powerOutput > 0);
        return tagCompound;
    }

    public void writeInfo(CompoundNBT tagCompound) {
        super.writeInfo(tagCompound);
        CompoundNBT info = this.getOrCreateInfo(tagCompound);
        for (int i = 0; i < 8; ++i) {
            info.func_74768_a("state" + i, this.logicTable[i]);
        }
    }

    public boolean execute(PlayerEntity playerMP, String command, TypedMap params) {
        boolean rc = super.execute(playerMP, command, params);
        if (rc) {
            return true;
        }
        if (CMD_SETSTATE.equals(command)) {
            this.logicTable[((Integer)params.get(ThreeLogicTileEntity.PARAM_INDEX)).intValue()] = (Integer)params.get(PARAM_STATE);
            this.markDirtyClient();
            this.checkRedstone(this.field_145850_b, this.field_174879_c);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkRedstone(World world, BlockPos pos) {
        BlockState state = world.func_180495_p(pos);
        if (loopDetector.add(pos)) {
            try {
                LogicFacing facing = this.getFacing(state);
                Direction downSide = facing.getSide();
                Direction inputSide = facing.getInputSide();
                Direction leftSide = LogicSlabBlock.rotateLeft((Direction)downSide, (Direction)inputSide);
                Direction rightSide = LogicSlabBlock.rotateRight((Direction)downSide, (Direction)inputSide);
                int powered1 = this.getInputStrength(world, pos, leftSide) > 0 ? 1 : 0;
                int powered2 = this.getInputStrength(world, pos, inputSide) > 0 ? 2 : 0;
                int powered3 = this.getInputStrength(world, pos, rightSide) > 0 ? 4 : 0;
                this.setPowerInput(powered1 + powered2 + powered3);
                this.checkRedstone();
            }
            finally {
                loopDetector.remove(pos);
            }
        }
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction facing) {
        if (cap == CapabilityContainerProvider.CONTAINER_PROVIDER_CAPABILITY) {
            return this.screenHandler.cast();
        }
        return super.getCapability(cap, facing);
    }
}

