/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolscontrol.modules.processor.logic.editors;

import mcjty.lib.gui.Window;
import mcjty.lib.gui.widgets.ChoiceLabel;
import mcjty.lib.gui.widgets.Panel;
import mcjty.lib.gui.widgets.TextField;
import mcjty.lib.gui.widgets.Widget;
import mcjty.lib.gui.widgets.Widgets;
import mcjty.rftoolsbase.api.control.parameters.ParameterType;
import mcjty.rftoolsbase.api.control.parameters.ParameterValue;
import mcjty.rftoolscontrol.modules.processor.logic.TypeConverters;
import mcjty.rftoolscontrol.modules.processor.logic.editors.AbstractParameterEditor;
import mcjty.rftoolscontrol.modules.processor.logic.editors.ParameterEditorCallback;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;

public class NumberEditor
extends AbstractParameterEditor {
    private ChoiceLabel typeLabel;
    private TextField field;

    @Override
    public int getHeight() {
        return 40;
    }

    @Override
    public void build(Minecraft mc, Screen gui, Panel panel, ParameterEditorCallback callback) {
        Panel constantPanel = Widgets.vertical();
        this.typeLabel = (ChoiceLabel)new ChoiceLabel().choices(new String[]{"Integer", "Long", "Float", "Double"}).event(newChoice -> callback.valueChanged(this.readValue())).desiredWidth(60);
        this.field = new TextField().event(newText -> callback.valueChanged(this.readValue())).addTextEnterEvent(newText -> this.closeWindow());
        constantPanel.children(new Widget[]{this.field, this.createLabeledPanel(mc, gui, "Type:", (Widget<?>)this.typeLabel, "Type of the number")});
        this.createEditorPanel(mc, gui, panel, callback, constantPanel, ParameterType.PAR_NUMBER);
    }

    @Override
    public void initialFocusInternal(Window window) {
        window.setTextFocus((Widget)this.field);
    }

    @Override
    protected ParameterValue readConstantValue() {
        String choice = this.typeLabel.getCurrentChoice().toLowerCase();
        if (choice.startsWith("i")) {
            return ParameterValue.constant((Object)NumberEditor.parseIntSafe(this.field.getText()));
        }
        if (choice.startsWith("l")) {
            return ParameterValue.constant((Object)NumberEditor.parseLongSafe(this.field.getText()));
        }
        if (choice.startsWith("f")) {
            return ParameterValue.constant((Object)NumberEditor.parseFloatSafe(this.field.getText()));
        }
        if (choice.startsWith("d")) {
            return ParameterValue.constant((Object)NumberEditor.parseDoubleSafe(this.field.getText()));
        }
        return ParameterValue.constant((Object)0);
    }

    @Override
    protected void writeConstantValue(ParameterValue value) {
        if (value == null || value.getValue() == null) {
            this.field.text("");
        } else {
            Object v = value.getValue();
            if (v instanceof Integer || v == null) {
                this.typeLabel.choice("Integer");
            } else if (v instanceof Long) {
                this.typeLabel.choice("Long");
            } else if (v instanceof Float) {
                this.typeLabel.choice("Float");
            } else if (v instanceof Double) {
                this.typeLabel.choice("Double");
            }
            String s = TypeConverters.castNumberToString(v);
            this.field.text(s);
        }
    }
}

