/*
 * Decompiled with CFR 0.152.
 */
package me.dags.noise.source;

import me.dags.noise.Module;
import me.dags.noise.util.NoiseUtil;

public class Line
implements Module {
    private final float x1;
    private final float y1;
    private final float x2;
    private final float y2;
    private final float dx;
    private final float dy;
    private final float orthX1;
    private final float orthY1;
    private final float orthX2;
    private final float orthY2;
    private final float length2;
    private final float featherBias;
    private final float featherScale;
    private final Module fadeIn;
    private final Module fadeOut;
    private final Module radius;

    public Line(float x1, float y1, float x2, float y2, Module radius2, Module fadeIn, Module fadeOut, float feather) {
        this.x1 = x1;
        this.y1 = y1;
        this.x2 = x2;
        this.y2 = y2;
        this.orthX1 = x1 + (y2 - y1);
        this.orthY1 = y1 + (x1 - x2);
        this.orthX2 = x2 + (y2 - y1);
        this.orthY2 = y2 + (x1 - x2);
        this.dx = x2 - x1;
        this.dy = y2 - y1;
        this.fadeIn = fadeIn;
        this.fadeOut = fadeOut;
        this.radius = radius2;
        this.featherScale = feather;
        this.featherBias = 1.0f - feather;
        this.length2 = this.dx * this.dx + this.dy * this.dy;
    }

    @Override
    public float getValue(float x, float y) {
        float widthMod = this.getWidthModifier(x, y);
        return this.getValue(x, y, widthMod);
    }

    public float getValue(float x, float y, float widthModifier) {
        float radius2;
        float dist2 = this.getDistance2(x, y);
        if (dist2 > (radius2 = this.radius.getValue(x, y) * widthModifier)) {
            return 0.0f;
        }
        float value = dist2 / radius2;
        if (this.featherScale == 0.0f) {
            return 1.0f - value;
        }
        float feather = this.featherBias + widthModifier * this.featherScale;
        return (1.0f - value) * feather;
    }

    public boolean clipStart(float x, float y) {
        return Line.sign(x, y, this.x1, this.y1, this.orthX1, this.orthY1) > 0;
    }

    public boolean clipEnd(float x, float y) {
        return Line.sign(x, y, this.x2, this.y2, this.orthX2, this.orthY2) < 0;
    }

    public float getWidthModifier(float x, float y) {
        float dist;
        float d1 = Line.dist2(x, y, this.x1, this.y1);
        if (d1 == 0.0f) {
            return 0.0f;
        }
        float d2 = Line.dist2(x, y, this.x2, this.y2);
        if (d2 == 0.0f) {
            return 0.0f;
        }
        float fade = 1.0f;
        float in = this.fadeIn.getValue(x, y);
        float out = this.fadeOut.getValue(x, y);
        if (in > 0.0f && d1 < (dist = in * this.length2)) {
            fade *= d1 / dist;
        }
        if (out > 0.0f && d2 < (dist = out * this.length2)) {
            fade *= d2 / dist;
        }
        return fade;
    }

    private float getDistance2(float x, float y) {
        float t = (x - this.x1) * this.dx + (y - this.y1) * this.dy;
        float s = NoiseUtil.clamp(t / this.length2, 0.0f, 1.0f);
        float ix = this.x1 + s * this.dx;
        float iy = this.y1 + s * this.dy;
        return Line.dist2(x, y, ix, iy);
    }

    public static float dist2(float x1, float y1, float x2, float y2) {
        float dx = x2 - x1;
        float dy = y2 - y1;
        return dx * dx + dy * dy;
    }

    public static int sign(float x, float y, float x1, float y1, float x2, float y2) {
        float value = (x - x1) * (y2 - y1) - (y - y1) * (x2 - x1);
        if (value == 0.0f) {
            return 0;
        }
        if (value < 0.0f) {
            return -1;
        }
        return 1;
    }
}

