/*
 * Decompiled with CFR 0.152.
 */
package me.dags.noise.source;

import me.dags.noise.source.Builder;
import me.dags.noise.source.FastSource;
import me.dags.noise.util.Noise;
import me.dags.noise.util.NoiseUtil;

public class FastCubic
extends FastSource {
    private final float min;
    private final float max;
    private final float range;

    public FastCubic(Builder builder) {
        super(builder);
        this.min = this.calculateBound(-0.75f, builder.getOctaves(), builder.getGain());
        this.max = this.calculateBound(0.75f, builder.getOctaves(), builder.getGain());
        this.range = this.max - this.min;
    }

    @Override
    public float minValue() {
        return this.min;
    }

    @Override
    public float maxValue() {
        return this.max;
    }

    @Override
    public float getValue(float x, float y, int seed) {
        float sum = Noise.singleCubic(x *= this.frequency, y *= this.frequency, seed);
        float amp = 1.0f;
        int i = 0;
        while (++i < this.octaves) {
            sum += Noise.singleCubic(x *= this.lacunarity, y *= this.lacunarity, ++seed) * (amp *= this.gain);
        }
        return NoiseUtil.map(sum, this.min, this.max, this.range);
    }

    private float calculateBound(float signal, int octaves, float gain) {
        float amp = 1.0f;
        float value = signal;
        for (int i = 1; i < octaves; ++i) {
            value += signal * (amp *= gain);
        }
        return value;
    }
}

