/*
 * Decompiled with CFR 0.152.
 */
package me.dags.noise.domain;

import me.dags.noise.Module;
import me.dags.noise.domain.Domain;

public class DomainWarp
implements Domain {
    private final Module x;
    private final Module y;
    private final Module distance;

    public DomainWarp(Module x, Module y, Module distance) {
        this.x = DomainWarp.map(x);
        this.y = DomainWarp.map(y);
        this.distance = distance;
    }

    @Override
    public float getOffsetX(float x, float y) {
        return this.x.getValue(x, y) * this.distance.getValue(x, y);
    }

    @Override
    public float getOffsetY(float x, float y) {
        return this.y.getValue(x, y) * this.distance.getValue(x, y);
    }

    private static Module map(Module in) {
        if (in.minValue() == -0.5f && in.maxValue() == 0.5f) {
            return in;
        }
        float range = in.maxValue() - in.minValue();
        if (range == 1.0f) {
            float bias = -0.5f - in.minValue();
            return in.bias(bias);
        }
        return in.map(-0.5, 0.5);
    }
}

