/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandExceptionType;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.terraforged.core.cell.Cell;
import com.terraforged.core.world.WorldGenerator;
import com.terraforged.core.world.terrain.Terrain;
import com.terraforged.core.world.terrain.Terrains;
import com.terraforged.mod.Log;
import com.terraforged.mod.biome.provider.BiomeProvider;
import com.terraforged.mod.chunk.TerraChunkGenerator;
import com.terraforged.mod.chunk.TerraContext;
import com.terraforged.mod.command.arg.BiomeArgType;
import com.terraforged.mod.command.arg.TerrainArgType;
import com.terraforged.mod.command.search.BiomeSearchTask;
import com.terraforged.mod.command.search.BothSearchTask;
import com.terraforged.mod.command.search.TerrainSearchTask;
import com.terraforged.mod.data.DataGen;
import com.terraforged.mod.settings.SettingsHelper;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.ArgumentTypes;
import net.minecraft.command.arguments.IArgumentSerializer;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextComponentUtils;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeManager;
import net.minecraft.world.biome.ColumnFuzzedBiomeMagnifier;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.server.permission.DefaultPermissionLevel;
import net.minecraftforge.server.permission.PermissionAPI;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class TerraCommand {
    public static void init() {
        ArgumentTypes.func_218136_a((String)"terraforged:biome", BiomeArgType.class, (IArgumentSerializer)new BiomeArgType.Serializer());
        ArgumentTypes.func_218136_a((String)"terraforged:terrain", TerrainArgType.class, (IArgumentSerializer)new TerrainArgType.Serializer());
    }

    @SubscribeEvent
    public static void register(FMLServerStartingEvent event) {
        Log.info("Registering /terra command", new Object[0]);
        TerraCommand.register((CommandDispatcher<CommandSource>)event.getCommandDispatcher());
    }

    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        TerraCommand.registerSimple(dispatcher);
        TerraCommand.registerLocate(dispatcher);
        PermissionAPI.registerNode((String)"terraforged.command.terra.query", (DefaultPermissionLevel)DefaultPermissionLevel.OP, (String)"Allows use of the query command");
        PermissionAPI.registerNode((String)"terraforged.command.terra.data", (DefaultPermissionLevel)DefaultPermissionLevel.OP, (String)"Allows use of the data command");
        PermissionAPI.registerNode((String)"terraforged.command.terra.defaults", (DefaultPermissionLevel)DefaultPermissionLevel.OP, (String)"Allows use of the defaults command");
        PermissionAPI.registerNode((String)"terraforged.command.terra.debug", (DefaultPermissionLevel)DefaultPermissionLevel.OP, (String)"Allows use of the debug command");
        PermissionAPI.registerNode((String)"terraforged.command.terra.locate", (DefaultPermissionLevel)DefaultPermissionLevel.OP, (String)"Allows use of the locate command");
    }

    private static void registerSimple(CommandDispatcher<CommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"terra").then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"query").requires(TerraCommand.perm("terraforged.command.terra.query"))).executes(TerraCommand::query))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"data").requires(TerraCommand.perm("terraforged.command.terra.data"))).then(Commands.func_197057_a((String)"dump").executes(TerraCommand::dump)))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"defaults").requires(TerraCommand.perm("terraforged.command.terra.defaults"))).then(Commands.func_197057_a((String)"set").executes(TerraCommand::setDefaults)))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"debug").requires(TerraCommand.perm("terraforged.command.terra.debug"))).executes(TerraCommand::debugBiome)));
    }

    private static void registerLocate(CommandDispatcher<CommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)Commands.func_197057_a((String)"terra").then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"locate").requires(TerraCommand.perm("terraforged.command.terra.locate"))).then(Commands.func_197056_a((String)"biome", BiomeArgType.biome()).executes(TerraCommand::findBiome))));
        dispatcher.register((LiteralArgumentBuilder)Commands.func_197057_a((String)"terra").then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"locate").requires(TerraCommand.perm("terraforged.command.terra.locate"))).then(Commands.func_197056_a((String)"terrain", TerrainArgType.terrain()).executes(TerraCommand::findTerrain))));
        dispatcher.register((LiteralArgumentBuilder)Commands.func_197057_a((String)"terra").then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"locate").requires(TerraCommand.perm("terraforged.command.terra.locate"))).then(Commands.func_197056_a((String)"biome", BiomeArgType.biome()).then(Commands.func_197056_a((String)"terrain", TerrainArgType.terrain()).executes(TerraCommand::findTerrainAndBiome)))));
        dispatcher.register((LiteralArgumentBuilder)Commands.func_197057_a((String)"terra").then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"locate").requires(TerraCommand.perm("terraforged.command.terra.locate"))).then(Commands.func_197056_a((String)"terrain", TerrainArgType.terrain()).then(Commands.func_197056_a((String)"biome", BiomeArgType.biome()).executes(TerraCommand::findTerrainAndBiome)))));
    }

    private static int query(CommandContext<CommandSource> context) throws CommandSyntaxException {
        TerraCommand.getContext(context).orElseThrow(() -> TerraCommand.createException("Invalid world type", "This command can only be run in a TerraForged world!", new Object[0]));
        BlockPos pos = ((CommandSource)context.getSource()).func_197035_h().func_180425_c();
        BiomeProvider biomeProvider = TerraCommand.getBiomeProvider(context);
        Cell<Terrain> cell = biomeProvider.lookupPos(pos.func_177958_n(), pos.func_177952_p());
        Biome biome = biomeProvider.getBiome(cell, pos.func_177958_n(), pos.func_177952_p());
        ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new StringTextComponent("Terrain=" + ((Terrain)cell.tag).getName() + ", Biome=" + biome.getRegistryName()), false);
        return 1;
    }

    private static int dump(CommandContext<CommandSource> context) throws CommandSyntaxException {
        ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new StringTextComponent("Exporting data"), true);
        DataGen.dumpData();
        return 1;
    }

    private static int setDefaults(CommandContext<CommandSource> context) throws CommandSyntaxException {
        TerraContext terraContext = TerraCommand.getContext(context).orElseThrow(() -> TerraCommand.createException("Invalid world type", "This command can only be run in a TerraForged world!", new Object[0]));
        ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new StringTextComponent("Setting generator defaults"), true);
        SettingsHelper.exportDefaults(terraContext.terraSettings);
        return 1;
    }

    private static int debugBiome(CommandContext<CommandSource> context) throws CommandSyntaxException {
        ServerPlayerEntity player = ((CommandSource)context.getSource()).func_197035_h();
        BlockPos position = player.func_180425_c();
        int x = position.func_177958_n();
        int y = position.func_177956_o();
        int z = position.func_177952_p();
        long seed = player.func_71121_q().func_72905_C();
        Biome actual = player.func_71121_q().func_226691_t_(position);
        Biome biome2 = ColumnFuzzedBiomeMagnifier.INSTANCE.func_225532_a_(seed, x, 0, z, (BiomeManager.IBiomeReader)player.func_71121_q().getWorldServer().func_72863_F().field_186029_c.func_202090_b());
        ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new StringTextComponent("Actual Biome = " + actual.getRegistryName() + "\nLookup Biome = " + biome2.getRegistryName()), false);
        return 1;
    }

    private static int findTerrain(CommandContext<CommandSource> context) throws CommandSyntaxException {
        TerraContext terraContext = TerraCommand.getContext(context).orElseThrow(() -> TerraCommand.createException("Invalid world type", "This command can only be run in a TerraForged world!", new Object[0]));
        Terrain terrain = TerrainArgType.getTerrain(context, "terrain");
        Terrain target = TerraCommand.getTerrainInstance(terrain, terraContext.terrain);
        BlockPos pos = ((CommandSource)context.getSource()).func_197035_h().func_180425_c();
        UUID playerID = ((CommandSource)context.getSource()).func_197035_h().func_110124_au();
        MinecraftServer server = ((CommandSource)context.getSource()).func_197028_i();
        WorldGenerator worldGenerator = terraContext.factory.get();
        TerrainSearchTask search = new TerrainSearchTask(pos, worldGenerator, target);
        TerraCommand.doSearch(server, playerID, search);
        ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new StringTextComponent("Locating terrain..."), false);
        return 1;
    }

    private static int findBiome(CommandContext<CommandSource> context) throws CommandSyntaxException {
        TerraContext terraContext = TerraCommand.getContext(context).orElseThrow(() -> TerraCommand.createException("Invalid world type", "This command can only be run in a TerraForged world!", new Object[0]));
        Biome biome = BiomeArgType.getBiome(context, "biome");
        BlockPos pos = ((CommandSource)context.getSource()).func_197035_h().func_180425_c();
        UUID playerID = ((CommandSource)context.getSource()).func_197035_h().func_110124_au();
        MinecraftServer server = ((CommandSource)context.getSource()).func_197028_i();
        ServerWorld reader = ((CommandSource)context.getSource()).func_197035_h().func_71121_q();
        BiomeSearchTask search = new BiomeSearchTask(pos, (IWorldReader)reader, biome);
        TerraCommand.doSearch(server, playerID, search);
        ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new StringTextComponent("Locating biome..."), false);
        return 1;
    }

    private static int findTerrainAndBiome(CommandContext<CommandSource> context) throws CommandSyntaxException {
        TerraContext terraContext = TerraCommand.getContext(context).orElseThrow(() -> TerraCommand.createException("Invalid world type", "This command can only be run in a TerraForged world!", new Object[0]));
        Terrain terrain = TerrainArgType.getTerrain(context, "terrain");
        Terrain target = TerraCommand.getTerrainInstance(terrain, terraContext.terrain);
        Biome biome = BiomeArgType.getBiome(context, "biome");
        BlockPos pos = ((CommandSource)context.getSource()).func_197035_h().func_180425_c();
        ServerWorld world = ((CommandSource)context.getSource()).func_197035_h().func_71121_q();
        UUID playerID = ((CommandSource)context.getSource()).func_197035_h().func_110124_au();
        MinecraftServer server = ((CommandSource)context.getSource()).func_197028_i();
        WorldGenerator worldGenerator = terraContext.factory.get();
        BiomeSearchTask biomeSearch = new BiomeSearchTask(pos, (IWorldReader)world, biome);
        TerrainSearchTask terrainSearch = new TerrainSearchTask(pos, worldGenerator, target);
        BothSearchTask search = new BothSearchTask(pos, biomeSearch, terrainSearch);
        TerraCommand.doSearch(server, playerID, search);
        ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new StringTextComponent("Locating biome & terrain..."), false);
        return 1;
    }

    private static void doSearch(MinecraftServer server, UUID userId, Supplier<BlockPos> supplier) {
        CompletableFuture.supplyAsync(supplier).thenAccept(pos -> server.func_213165_a(() -> {
            ServerPlayerEntity player = server.func_184103_al().func_177451_a(userId);
            if (player == null) {
                return;
            }
            if (pos.func_177958_n() == 0 && pos.func_177952_p() == 0) {
                player.func_145747_a((ITextComponent)new StringTextComponent("Location not found :["));
                return;
            }
            ITextComponent result = new StringTextComponent("Nearest match: ").func_150257_a(TerraCommand.createTeleportMessage(pos));
            player.func_145747_a(result);
        }));
    }

    private static Optional<TerraContext> getContext(CommandContext<CommandSource> context) throws CommandSyntaxException {
        DimensionType dimension;
        MinecraftServer server = ((CommandSource)context.getSource()).func_197028_i();
        ChunkGenerator generator = server.func_71218_a(dimension = ((CommandSource)context.getSource()).func_197035_h().field_71093_bK).func_72863_F().func_201711_g();
        if (generator instanceof TerraChunkGenerator) {
            TerraChunkGenerator gen = (TerraChunkGenerator)generator;
            return Optional.of(gen.getContext());
        }
        return Optional.empty();
    }

    private static Terrain getTerrainInstance(Terrain find, Terrains terrains) {
        for (Terrain t : terrains.index) {
            if (!t.getName().equals(find.getName())) continue;
            return t;
        }
        for (Terrain t : terrains.index) {
            if (!t.getName().contains("-") || !t.getName().contains(find.getName())) continue;
            return t;
        }
        return find;
    }

    private static Predicate<CommandSource> perm(String node) {
        return source -> {
            try {
                return PermissionAPI.hasPermission((PlayerEntity)source.func_197035_h(), (String)node);
            }
            catch (Throwable t) {
                return source.func_197034_c(2);
            }
        };
    }

    private static BiomeProvider getBiomeProvider(CommandContext<CommandSource> context) {
        return (BiomeProvider)((CommandSource)context.getSource()).func_197023_e().func_72863_F().func_201711_g().func_202090_b();
    }

    private static CommandSyntaxException createException(String type, String message, Object ... args) {
        return new CommandSyntaxException((CommandExceptionType)new SimpleCommandExceptionType((Message)new StringTextComponent(type)), (Message)new StringTextComponent(String.format(message, args)));
    }

    private static ITextComponent createTeleportMessage(BlockPos pos) {
        return TextComponentUtils.func_197676_a((ITextComponent)new TranslationTextComponent("chat.coordinates", new Object[]{pos.func_177958_n(), "~", pos.func_177952_p()})).func_211710_a(style -> style.func_150238_a(TextFormatting.GREEN).func_150241_a(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/tp @s " + pos.func_177958_n() + " ~ " + pos.func_177952_p())).func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new TranslationTextComponent("chat.coordinates.tooltip", new Object[0]))));
    }
}

