/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.feature.data;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.terraforged.feature.data.ResourceVisitor;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.LogicalSidedProvider;

public class DataHelper {
    public static final Predicate<String> ANY = s -> true;
    public static final Predicate<String> NBT = s -> s.endsWith(".nbt");
    public static final Predicate<String> JSON = s -> s.endsWith(".json");
    private static final Supplier<IResourceManager> resourceManager = () -> {
        MinecraftServer server = (MinecraftServer)LogicalSidedProvider.INSTANCE.get(LogicalSide.SERVER);
        return server.func_195570_aG();
    };

    public static void iterateData(String path, ResourceVisitor<InputStream> consumer) {
        IResourceManager manager = DataHelper.getResourceManager();
        for (ResourceLocation location : manager.func_199003_a(path, JSON)) {
            try {
                IResource resource = manager.func_199002_a(location);
                Throwable throwable = null;
                try {
                    consumer.accept(location, resource.func_199027_b());
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (resource == null) continue;
                    if (throwable != null) {
                        try {
                            resource.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    resource.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void iterateJson(String path, ResourceVisitor<JsonElement> consumer) {
        IResourceManager manager = DataHelper.getResourceManager();
        JsonParser parser = new JsonParser();
        for (ResourceLocation location : manager.func_199003_a(path, JSON)) {
            try {
                IResource resource = manager.func_199002_a(location);
                Throwable throwable = null;
                try {
                    BufferedReader reader = new BufferedReader(new InputStreamReader(resource.func_199027_b()));
                    JsonElement element = parser.parse((Reader)reader);
                    consumer.accept(location, element);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (resource == null) continue;
                    if (throwable != null) {
                        try {
                            resource.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    resource.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static IResourceManager getResourceManager() {
        return resourceManager.get();
    }
}

