/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.core.world.climate;

import com.terraforged.core.cell.Cell;
import com.terraforged.core.settings.Settings;
import com.terraforged.core.util.Seed;
import com.terraforged.core.world.biome.BiomeType;
import com.terraforged.core.world.climate.Compressor;
import com.terraforged.core.world.terrain.Terrain;
import me.dags.noise.Module;
import me.dags.noise.Source;
import me.dags.noise.func.DistanceFunc;
import me.dags.noise.func.EdgeFunc;
import me.dags.noise.util.NoiseUtil;
import me.dags.noise.util.Vec2f;

public class ClimateModule {
    private final int seed;
    private final float edgeClamp;
    private final float edgeScale;
    private final float biomeFreq;
    private final float warpStrength;
    private final Module warpX;
    private final Module warpZ;
    private final Module moisture;
    private final Module temperature;

    public ClimateModule(Seed seed, Settings settings) {
        int biomeSize = settings.generator.biome.biomeSize;
        int tempScaler = biomeSize > 500 ? 8 : 10;
        int moistScaler = biomeSize > 500 ? 20 : 40;
        float biomeFreq = 1.0f / (float)biomeSize;
        int moistureSize = moistScaler * biomeSize;
        int temperatureSize = tempScaler * biomeSize;
        int moistScale = NoiseUtil.round((float)moistureSize * biomeFreq);
        int tempScale = NoiseUtil.round((float)temperatureSize * biomeFreq);
        int warpScale = settings.generator.biome.biomeWarpScale;
        this.seed = seed.next();
        this.edgeClamp = 1.0f;
        this.edgeScale = 1.0f / this.edgeClamp;
        this.biomeFreq = 1.0f / (float)biomeSize;
        this.warpStrength = settings.generator.biome.biomeWarpStrength;
        this.warpX = Source.perlin(seed.next(), warpScale, 2).bias(-0.5);
        this.warpZ = Source.perlin(seed.next(), warpScale, 2).bias(-0.5);
        Module moisture = Source.simplex(seed.next(), moistScale, 2).clamp(0.15, 0.85).map(0.0, 1.0);
        this.moisture = settings.climate.moisture.clamp(moisture).warp(seed.next(), moistScale / 2, 1, (double)moistScale / 4.0).warp(seed.next(), moistScale / 6, 2, (double)moistScale / 12.0);
        Module temperature = Source.sin(tempScale, Source.constant(0.9)).clamp(0.05, 0.95).map(0.0, 1.0);
        this.temperature = new Compressor(settings.climate.temperature.clamp(temperature), 0.1f, 0.2f).warp(seed.next(), tempScale * 4, 2, tempScale * 4).warp(seed.next(), tempScale, 1, tempScale).warp(seed.next(), tempScale / 8, 1, (double)tempScale / 8.0);
    }

    public void apply(Cell<Terrain> cell, float x, float y, boolean mask) {
        float ox = this.warpX.getValue(x, y) * this.warpStrength;
        float oz = this.warpZ.getValue(x, y) * this.warpStrength;
        x += ox;
        y += oz;
        int cellX = 0;
        int cellY = 0;
        Vec2f vec2f = null;
        int xr = NoiseUtil.round(x *= this.biomeFreq);
        int yr = NoiseUtil.round(y *= this.biomeFreq);
        float edgeDistance = 999999.0f;
        float edgeDistance2 = 999999.0f;
        float valueDistance = Float.MAX_VALUE;
        DistanceFunc dist = DistanceFunc.NATURAL;
        for (int dy = -1; dy <= 1; ++dy) {
            for (int dx = -1; dx <= 1; ++dx) {
                int xi = xr + dx;
                int yi = yr + dy;
                Vec2f vec = NoiseUtil.CELL_2D[NoiseUtil.hash2D(this.seed, xi, yi) & 0xFF];
                float vecX = (float)xi - x + vec.x;
                float vecY = (float)yi - y + vec.y;
                float distance = dist.apply(vecX, vecY);
                if (distance < valueDistance) {
                    valueDistance = distance;
                    vec2f = vec;
                    cellX = xi;
                    cellY = yi;
                }
                edgeDistance2 = distance < edgeDistance2 ? Math.max(edgeDistance, distance) : Math.max(edgeDistance, edgeDistance2);
                edgeDistance = Math.min(edgeDistance, distance);
            }
        }
        if (mask) {
            cell.biomeEdge = this.edgeValue(edgeDistance, edgeDistance2);
        } else {
            cell.biome = this.cellValue(this.seed, cellX, cellY);
            cell.biomeEdge = this.edgeValue(edgeDistance, edgeDistance2);
            cell.biomeMoisture = this.moisture.getValue((float)cellX + vec2f.x, (float)cellY + vec2f.y);
            cell.biomeTemperature = this.temperature.getValue((float)cellX + vec2f.x, (float)cellY + vec2f.y);
            cell.moisture = this.moisture.getValue(x, y);
            cell.temperature = this.temperature.getValue(x, y);
            BiomeType.apply(cell);
        }
    }

    private float cellValue(int seed, int cellX, int cellY) {
        float value = NoiseUtil.valCoord2D(seed, cellX, cellY);
        return NoiseUtil.map(value, -1.0f, 1.0f, 2.0f);
    }

    private float edgeValue(float distance, float distance2) {
        EdgeFunc edge = EdgeFunc.DISTANCE_2_DIV;
        float value = edge.apply(distance, distance2);
        if ((value = 1.0f - NoiseUtil.map(value, edge.min(), edge.max(), edge.range())) > this.edgeClamp) {
            return 1.0f;
        }
        return value * this.edgeScale;
    }
}

