/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.core.settings;

import com.terraforged.core.util.serialization.annotation.Comment;
import com.terraforged.core.util.serialization.annotation.Range;
import com.terraforged.core.util.serialization.annotation.Serializable;

@Serializable
public class RiverSettings {
    @Range(min=0.0f, max=5.0f)
    @Comment(value={"Controls how frequently rivers generate"})
    public float riverFrequency = 1.0f;
    public River primaryRivers = new River(5, 2, 8, 25, 8, 0.75f);
    public River secondaryRiver = new River(4, 1, 6, 15, 5, 0.75f);
    public River tertiaryRivers = new River(3, 0, 4, 10, 4, 0.75f);
    public Lake lake = new Lake();

    public static class Lake {
        @Range(min=0.0f, max=1.0f)
        @Comment(value={"Controls the chance of a lake spawning"})
        public float chance = 0.2f;
        @Range(min=0.0f, max=1.0f)
        @Comment(value={"The minimum distance along a river that a lake will spawn"})
        public float minStartDistance = 0.03f;
        @Range(min=0.0f, max=1.0f)
        @Comment(value={"The maximum distance along a river that a lake will spawn"})
        public float maxStartDistance = 0.07f;
        @Range(min=1.0f, max=20.0f)
        @Comment(value={"The max depth of the lake"})
        public int depth = 10;
        @Range(min=10.0f, max=50.0f)
        @Comment(value={"The minimum size of the lake"})
        public int sizeMin = 50;
        @Range(min=50.0f, max=150.0f)
        @Comment(value={"The maximum size of the lake"})
        public int sizeMax = 100;
        @Range(min=1.0f, max=10.0f)
        @Comment(value={"The minimum bank height"})
        public int minBankHeight = 2;
        @Range(min=1.0f, max=10.0f)
        @Comment(value={"The maximum bank height"})
        public int maxBankHeight = 10;
    }

    @Serializable
    public static class River {
        @Range(min=1.0f, max=10.0f)
        @Comment(value={"Controls the depth of the river"})
        public int bedDepth;
        @Range(min=0.0f, max=10.0f)
        @Comment(value={"Controls the height of river banks"})
        public int minBankHeight;
        @Range(min=1.0f, max=10.0f)
        @Comment(value={"Controls the height of river banks"})
        public int maxBankHeight;
        @Range(min=1.0f, max=20.0f)
        @Comment(value={"Controls the river-bed width"})
        public int bedWidth;
        @Range(min=1.0f, max=50.0f)
        @Comment(value={"Controls the river-banks width"})
        public int bankWidth;
        @Range(min=0.0f, max=1.0f)
        @Comment(value={"Controls how much rivers taper"})
        public float fade;

        public River() {
        }

        public River(int depth, int minBank, int maxBank, int outer, int inner, float fade) {
            this.minBankHeight = minBank;
            this.maxBankHeight = maxBank;
            this.bankWidth = outer;
            this.bedWidth = inner;
            this.bedDepth = depth;
            this.fade = fade;
        }
    }
}

