/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.core.region.gen;

import com.terraforged.core.region.Region;
import com.terraforged.core.region.chunk.ChunkReader;
import com.terraforged.core.region.gen.RegionGenerator;
import com.terraforged.core.util.concurrent.Disposable;
import com.terraforged.core.util.concurrent.cache.Cache;
import com.terraforged.core.util.concurrent.cache.CacheEntry;
import com.terraforged.core.world.heightmap.RegionExtent;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import me.dags.noise.util.NoiseUtil;

public class RegionCache
implements RegionExtent,
Disposable.Listener<Region> {
    private final boolean queuing;
    private final RegionGenerator generator;
    private final Cache<CacheEntry<Region>> cache;

    public RegionCache(boolean queueNeighbours, RegionGenerator generator) {
        this.queuing = queueNeighbours;
        this.generator = new RegionGenerator(generator, this);
        this.cache = new Cache(60L, 30L, TimeUnit.SECONDS);
    }

    @Override
    public void onDispose(Region region) {
        this.cache.remove(region.getRegionId());
    }

    @Override
    public int chunkToRegion(int coord) {
        return this.generator.chunkToRegion(coord);
    }

    @Override
    public CompletableFuture<Region> getRegionAsync(int regionX, int regionZ) {
        return this.generator.generate(regionX, regionZ);
    }

    @Override
    public ChunkReader getChunk(int chunkX, int chunkZ) {
        int regionX = this.generator.chunkToRegion(chunkX);
        int regionZ = this.generator.chunkToRegion(chunkZ);
        Region region = this.getRegion(regionX, regionZ);
        return region.getChunk(chunkX, chunkZ);
    }

    @Override
    public Region getRegion(int regionX, int regionZ) {
        Region region = this.computeRegion(regionX, regionZ).get();
        if (this.queuing) {
            this.queueNeighbours(regionX, regionZ);
        }
        return region;
    }

    private CacheEntry<Region> computeRegion(int regionX, int regionZ) {
        long id = NoiseUtil.seed(regionX, regionZ);
        return this.cache.computeIfAbsent(id, l -> this.generator.compute(regionX, regionZ));
    }

    public CacheEntry<Region> queueRegion(int regionX, int regionZ) {
        long id = NoiseUtil.seed(regionX, regionZ);
        return this.cache.computeIfAbsent(id, l -> this.generator.queue(regionX, regionZ));
    }

    private void queueNeighbours(int regionX, int regionZ) {
        for (int z = -1; z <= 1; ++z) {
            for (int x = -1; x <= 1; ++x) {
                if (x == 0 && z == 0) continue;
                this.queueRegion(regionX + x, regionZ + z);
            }
        }
    }
}

