/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.dungeon;

import com.google.common.collect.Lists;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import net.minecraft.util.Direction;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import xiroc.dungeoncrawl.dungeon.Dungeon;
import xiroc.dungeoncrawl.dungeon.DungeonBuilder;
import xiroc.dungeoncrawl.dungeon.DungeonLayer;
import xiroc.dungeoncrawl.dungeon.DungeonPieces;
import xiroc.dungeoncrawl.dungeon.RandomFeature;
import xiroc.dungeoncrawl.util.Position2D;
import xiroc.dungeoncrawl.util.RotationHelper;
import xiroc.dungeoncrawl.util.Triple;

public class DungeonFeatures {
    public static final HashMap<Integer, Triple<Integer, Integer, Integer>> OFFSET_DATA;
    public static final Triple<Integer, Integer, Integer> DEFAULT_OFFSET;
    public static final List<CorridorFeature> CORRIDOR_FEATURES;

    public static void processCorridor(DungeonBuilder builder, DungeonLayer layer, int x, int z, Random rand, int lyr, int stage, BlockPos startPos) {
        for (CorridorFeature corridorFeature : CORRIDOR_FEATURES) {
            if (!corridorFeature.process(builder, layer, x, z, rand, lyr, stage, startPos)) continue;
            return;
        }
    }

    public static boolean canPlacePieceWithHeight(DungeonBuilder builder, int layer, int x, int z, int width, int length, int layerHeight, boolean ignoreStartPosition) {
        int layers = builder.layers.length;
        int lh = layer - layerHeight;
        if (layer > layers - 1 || layer < 0 || lh > layers || lh < 0) {
            return false;
        }
        if (x + width > Dungeon.SIZE - 1 || z + length > Dungeon.SIZE - 1) {
            return false;
        }
        boolean up = layerHeight > 0;
        int c = up ? -1 : 1;
        int k = lh + c;
        int lyr = layer;
        while (up ? lyr > k : lyr < k) {
            if (layers - lyr != 0) {
                if (layers - lyr < 0) {
                    return false;
                }
                for (int x0 = 0; x0 < width; ++x0) {
                    for (int z0 = 0; z0 < length; ++z0) {
                        if (ignoreStartPosition && lyr == layer && x0 == 0 && z0 == 0 || builder.layers[lyr].segments[x + x0][z + z0] == null && builder.maps[lyr].isPositionFree(x + x0, z + z0)) continue;
                        return false;
                    }
                }
            }
            lyr += c;
        }
        return true;
    }

    public static void mark(DungeonBuilder builder, int layer, int x, int z, int width, int length, int layerHeight) {
        int layers = builder.layers.length;
        boolean up = layerHeight > 0;
        int c = up ? -1 : 1;
        int k = layer - layerHeight + c;
        int lyr = layer;
        while (up ? lyr > k : lyr < k) {
            if (layers - lyr != 0) {
                for (int x0 = 0; x0 < width; ++x0) {
                    for (int z0 = 0; z0 < length; ++z0) {
                        builder.maps[lyr].markPositionAsOccupied(new Position2D(x + x0, z + z0));
                    }
                }
            }
            lyr += c;
        }
    }

    static {
        DEFAULT_OFFSET = new Triple<Integer, Integer, Integer>(0, 0, 0);
        OFFSET_DATA = new HashMap();
        OFFSET_DATA.put(33, new Triple<Integer, Integer, Integer>(0, -1, 0));
        CORRIDOR_FEATURES = Lists.newArrayList();
        CORRIDOR_FEATURES.add((builder, layer, x, z, rand, lyr, stage, startPos) -> {
            if (rand.nextDouble() < 0.06 && DungeonFeatures.canPlacePieceWithHeight(builder, lyr, x, z, 1, 1, -2, true)) {
                DungeonPieces.Hole hole = new DungeonPieces.Hole(null, DungeonPieces.DEFAULT_NBT);
                hole.sides = layer.segments[x][z].sides;
                hole.connectedSides = layer.segments[x][z].connectedSides;
                hole.setRealPosition(startPos.func_177958_n() + x * 8, startPos.func_177956_o() - lyr * 8, startPos.func_177952_p() + z * 8);
                hole.stage = stage;
                hole.lava = stage == 2;
                layer.segments[x][z] = hole;
                DungeonFeatures.mark(builder, lyr, x, z, 1, 1, -2);
                return true;
            }
            return false;
        });
        CORRIDOR_FEATURES.add((builder, layer, x, z, rand, lyr, stage, startPos) -> {
            if (layer.segments[x][z].connectedSides == 2 && (layer.segments[x][z].sides[0] && layer.segments[x][z].sides[2] || layer.segments[x][z].sides[1] && layer.segments[x][z].sides[3]) && rand.nextDouble() < 0.08) {
                ((DungeonPieces.Corridor)layer.segments[x][z]).specialType = lyr > 0 ? 1 : 2;
                return true;
            }
            return false;
        });
        CORRIDOR_FEATURES.add((builder, layer, x, z, rand, lyr, stage, startPos) -> {
            Direction facing;
            Position2D pos;
            Position2D roomPos;
            if (layer.segments[x][z].getType() == 0 && layer.segments[x][z].connectedSides < 4 && (lyr == 0 || builder.layers[lyr - 1].segments[x][z] == null || builder.layers[lyr - 1].segments[x][z].getType() != 8) && (roomPos = (pos = new Position2D(x, z)).shift(RotationHelper.translateDirectionLeft(facing = RotationHelper.translateDirection(Direction.EAST, layer.segments[x][z].field_186169_c)), 1)).isValid(layer.width, layer.length) && layer.segments[roomPos.x][roomPos.z] == null && builder.maps[lyr].isPositionFree(roomPos.x, roomPos.z) && rand.nextDouble() < 0.09) {
                layer.segments[x][z].openSide(RotationHelper.translateDirectionLeft(facing));
                DungeonPieces.SideRoom sideRoom = (DungeonPieces.SideRoom)RandomFeature.SIDE_ROOM.roll(rand);
                sideRoom.setOffset(OFFSET_DATA.getOrDefault(sideRoom.modelID, DEFAULT_OFFSET));
                sideRoom.setPosition(roomPos.x, roomPos.z);
                sideRoom.stage = stage;
                sideRoom.connectedSides = 1;
                sideRoom.setRealPosition(startPos.func_177958_n() + roomPos.x * 8, startPos.func_177956_o() - lyr * 8, startPos.func_177952_p() + roomPos.z * 8);
                sideRoom.field_186169_c = layer.segments[x][z].field_186169_c.func_185830_a(Rotation.COUNTERCLOCKWISE_90);
                layer.rotatePiece(layer.segments[x][z]);
                layer.segments[roomPos.x][roomPos.z] = sideRoom;
                builder.maps[lyr].markPositionAsOccupied(roomPos);
                return true;
            }
            return false;
        });
        CORRIDOR_FEATURES.add((builder, layer, x, z, rand, lyr, stage, startPos) -> {
            if (layer.segments[x][z].connectedSides == 2 && rand.nextDouble() < 0.07 && (layer.segments[x][z].sides[0] && layer.segments[x][z].sides[2] || layer.segments[x][z].sides[1] && layer.segments[x][z].sides[3])) {
                DungeonPieces.DungeonPiece feature = RandomFeature.CORRIDOR_FEATURE.roll(rand);
                if (feature.getType() == 7 && !DungeonFeatures.canPlacePieceWithHeight(builder, lyr, x, z, 1, 1, -1, true)) {
                    feature = new DungeonPieces.CorridorTrap(null, DungeonPieces.DEFAULT_NBT);
                }
                feature.sides = layer.segments[x][z].sides;
                feature.connectedSides = layer.segments[x][z].connectedSides;
                feature.setRealPosition(startPos.func_177958_n() + x * 8, startPos.func_177956_o() - lyr * 8, startPos.func_177952_p() + z * 8);
                feature.stage = stage;
                feature.field_186169_c = layer.segments[x][z].field_186169_c;
                layer.segments[x][z] = feature;
                return true;
            }
            return false;
        });
        CORRIDOR_FEATURES.add((builder, layer, x, z, rand, lyr, stage, startPos) -> {
            if (layer.segments[x][z].getType() == 0 && layer.segments[x][z].connectedSides < 4) {
                Direction facing = RotationHelper.translateDirection(Direction.EAST, layer.segments[x][z].field_186169_c);
                Position2D pos = new Position2D(x, z);
                Position2D part1Pos = pos.shift(RotationHelper.translateDirectionLeft(facing), 1);
                Position2D part2Pos = part1Pos.shift(facing, 1);
                if (part1Pos.isValid(layer.width, layer.length) && part2Pos.isValid(layer.width, layer.length) && layer.canPutDoubleRoom(part1Pos, facing) && rand.nextDouble() < 0.023) {
                    layer.segments[x][z].openSide(RotationHelper.translateDirectionLeft(facing));
                    DungeonPieces.Part part1 = new DungeonPieces.Part(null, DungeonPieces.DEFAULT_NBT);
                    DungeonPieces.Part part2 = new DungeonPieces.Part(null, DungeonPieces.DEFAULT_NBT);
                    part1.connectedSides = 1;
                    part2.connectedSides = 1;
                    part1.treasureType = 1;
                    part2.treasureType = 1;
                    part1.stage = stage;
                    part2.stage = stage;
                    part1.setPosition(part1Pos.x, part1Pos.z);
                    part2.setPosition(part2Pos.x, part2Pos.z);
                    part1.setRotation(layer.segments[x][z].field_186169_c.func_185830_a(Rotation.COUNTERCLOCKWISE_90));
                    part2.setRotation(layer.segments[x][z].field_186169_c.func_185830_a(Rotation.COUNTERCLOCKWISE_90));
                    layer.rotatePiece(layer.segments[x][z]);
                    int id = 27;
                    part1.set(id, 0, 0, 0, 8, 8, 8);
                    part2.set(id, 0, 0, 8, 8, 8, 8);
                    part1.setRealPosition(startPos.func_177958_n() + part1Pos.x * 8, startPos.func_177956_o() - lyr * 8, startPos.func_177952_p() + part1Pos.z * 8);
                    part2.setRealPosition(startPos.func_177958_n() + part2Pos.x * 8, startPos.func_177956_o() - lyr * 8, startPos.func_177952_p() + part2Pos.z * 8);
                    layer.segments[part1Pos.x][part1Pos.z] = part1;
                    layer.segments[part2Pos.x][part2Pos.z] = part2;
                    return true;
                }
                return false;
            }
            return false;
        });
    }

    @FunctionalInterface
    public static interface CorridorFeature {
        public boolean process(DungeonBuilder var1, DungeonLayer var2, int var3, int var4, Random var5, int var6, int var7, BlockPos var8);
    }
}

