/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.block.resourceproduction.tile;

import com.buuz135.industrial.block.tile.IndustrialWorkingTile;
import com.buuz135.industrial.config.machine.resourceproduction.MechanicalDirtConfig;
import com.buuz135.industrial.module.ModuleCore;
import com.buuz135.industrial.module.ModuleResourceProduction;
import com.hrznstudio.titanium.annotation.Save;
import com.hrznstudio.titanium.api.IFactory;
import com.hrznstudio.titanium.block.tile.BasicTile;
import com.hrznstudio.titanium.component.IComponentHarness;
import com.hrznstudio.titanium.component.fluid.FluidTankComponent;
import com.hrznstudio.titanium.component.fluid.SidedFluidTankComponent;
import com.hrznstudio.titanium.energy.NBTEnergyHandler;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.DyeColor;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Difficulty;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.server.ServerChunkProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class MechanicalDirtTile
extends IndustrialWorkingTile<MechanicalDirtTile> {
    private int getPowerPerOperation;
    @Save
    private SidedFluidTankComponent<MechanicalDirtTile> meat = (SidedFluidTankComponent)new SidedFluidTankComponent("meat", MechanicalDirtConfig.maxMeatTankSize, 43, 20, 0).setColor(DyeColor.BROWN).setComponentHarness((IComponentHarness)this).setTankAction(FluidTankComponent.Action.FILL).setValidator(fluidStack -> fluidStack.getFluid().func_207187_a((Fluid)ModuleCore.MEAT.getSourceFluid()));

    public MechanicalDirtTile() {
        super(ModuleResourceProduction.MECHANICAL_DIRT);
        this.addTank((FluidTankComponent)this.meat);
        this.getPowerPerOperation = MechanicalDirtConfig.powerPerOperation;
    }

    @Override
    public IndustrialWorkingTile.WorkAction work() {
        MobEntity entity;
        if (this.field_145850_b.field_73012_v.nextDouble() > 0.1 || this.field_145850_b.func_175659_aa() == Difficulty.PEACEFUL || this.field_145850_b.func_72935_r() && this.field_145850_b.func_205052_D(this.field_174879_c.func_177984_a()) > 0.5f && this.field_145850_b.func_175710_j(this.field_174879_c.func_177984_a()) || this.field_145850_b.func_217357_a(MobEntity.class, new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0).func_186670_a(this.field_174879_c).func_186662_g(3.0)).size() > 10) {
            if (this.hasEnergy(this.getPowerPerOperation / 10)) {
                return new IndustrialWorkingTile.WorkAction(0.5f, this.getPowerPerOperation / 10);
            }
            return new IndustrialWorkingTile.WorkAction(1.0f, 0);
        }
        if (this.meat.getFluidAmount() > 100 && (entity = this.getMobToSpawn()) != null) {
            this.field_145850_b.func_217376_c((Entity)entity);
            this.meat.drainForced(100, IFluidHandler.FluidAction.EXECUTE);
            if (this.hasEnergy(this.getPowerPerOperation)) {
                return new IndustrialWorkingTile.WorkAction(0.5f, this.getPowerPerOperation);
            }
        }
        return new IndustrialWorkingTile.WorkAction(1.0f, 0);
    }

    private MobEntity getMobToSpawn() {
        List spawnListEntries = ((ServerChunkProvider)this.field_145850_b.func_72863_F()).func_201711_g().func_177458_a(EntityClassification.MONSTER, this.field_174879_c);
        if (spawnListEntries.size() == 0) {
            return null;
        }
        Biome.SpawnListEntry spawnListEntry = (Biome.SpawnListEntry)spawnListEntries.get(this.field_145850_b.field_73012_v.nextInt(spawnListEntries.size()));
        if (!EntitySpawnPlacementRegistry.func_223515_a((EntityType)spawnListEntry.field_200702_b, (IWorld)this.field_145850_b, (SpawnReason)SpawnReason.NATURAL, (BlockPos)this.field_174879_c, (Random)this.field_145850_b.field_73012_v)) {
            return null;
        }
        Entity entity = spawnListEntry.field_200702_b.func_200721_a(this.field_145850_b);
        if (entity instanceof MobEntity) {
            ((MobEntity)entity).func_213386_a((IWorld)this.field_145850_b, this.field_145850_b.func_175649_E(this.field_174879_c), SpawnReason.NATURAL, null, null);
            entity.func_70107_b((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 1.0626, (double)this.field_174879_c.func_177952_p() + 0.5);
            if (this.field_145850_b.func_226669_j_(entity) && this.field_145850_b.func_195585_a(entity, this.field_145850_b.func_180495_p(this.field_174879_c.func_177984_a()).func_196954_c((IBlockReader)this.field_145850_b, this.field_174879_c.func_177984_a()))) {
                return (MobEntity)entity;
            }
        }
        return null;
    }

    public SidedFluidTankComponent<MechanicalDirtTile> getMeat() {
        return this.meat;
    }

    public void func_73660_a() {
        super.func_73660_a();
        if (this.isServer() && this.field_145850_b.func_82737_E() % 5L == 0L) {
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                TileEntity tile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(direction));
                if (!(tile instanceof MechanicalDirtTile)) continue;
                int difference = this.meat.getFluidAmount() - ((MechanicalDirtTile)tile).getMeat().getFluidAmount();
                if (difference > 0) {
                    difference = difference <= 25 ? (difference /= 2) : 25;
                    if (this.meat.getFluidAmount() >= difference) {
                        this.meat.drainForced(((MechanicalDirtTile)tile).getMeat().fill(new FluidStack((Fluid)ModuleCore.MEAT.getSourceFluid(), this.meat.drainForced(difference, IFluidHandler.FluidAction.SIMULATE).getAmount()), IFluidHandler.FluidAction.EXECUTE), IFluidHandler.FluidAction.EXECUTE);
                    }
                }
                if ((difference = this.getEnergyStorage().getEnergyStored() - ((MechanicalDirtTile)tile).getEnergyStorage().getEnergyStored()) <= 0) continue;
                if (difference <= 1000 && difference > 1) {
                    difference /= 2;
                }
                if (difference > 1000) {
                    difference = 1000;
                }
                if (this.getEnergyStorage().getEnergyStored() < difference) continue;
                this.getEnergyStorage().extractEnergyForced(((MechanicalDirtTile)tile).getEnergyStorage().receiveEnergy(difference, false));
            }
        }
    }

    protected IFactory<NBTEnergyHandler> getEnergyHandlerFactory() {
        return () -> new NBTEnergyHandler((BasicTile)this, MechanicalDirtConfig.maxStoredPower);
    }

    @Nonnull
    public MechanicalDirtTile getSelf() {
        return this;
    }
}

