/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.block.generator.tile;

import com.buuz135.industrial.block.tile.IndustrialGeneratorTile;
import com.buuz135.industrial.config.machine.generator.BiofuelGeneratorConfig;
import com.buuz135.industrial.module.ModuleCore;
import com.buuz135.industrial.module.ModuleGenerator;
import com.hrznstudio.titanium.annotation.Save;
import com.hrznstudio.titanium.component.IComponentHarness;
import com.hrznstudio.titanium.component.fluid.FluidTankComponent;
import com.hrznstudio.titanium.component.fluid.SidedFluidTankComponent;
import com.hrznstudio.titanium.component.progress.ProgressBarComponent;
import javax.annotation.Nonnull;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.DyeColor;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class BiofuelGeneratorTile
extends IndustrialGeneratorTile<BiofuelGeneratorTile> {
    private int getMaxStoredPower;
    private int getPowerPerTick;
    private int getExtractionRate;
    @Save
    private SidedFluidTankComponent<BiofuelGeneratorTile> biofuel = (SidedFluidTankComponent)new SidedFluidTankComponent("biofuel", BiofuelGeneratorConfig.maxBiofuelTankSize, 43, 20, 0).setColor(DyeColor.PURPLE).setComponentHarness((IComponentHarness)this).setTankAction(FluidTankComponent.Action.FILL).setValidator(fluidStack -> fluidStack.getFluid().func_207187_a((Fluid)ModuleCore.BIOFUEL.getSourceFluid()));

    public BiofuelGeneratorTile() {
        super(ModuleGenerator.BIOFUEL_GENERATOR);
        this.addTank((FluidTankComponent)this.biofuel);
        this.getMaxStoredPower = BiofuelGeneratorConfig.maxStoredPower;
        this.getPowerPerTick = BiofuelGeneratorConfig.powerPerTick;
        this.getExtractionRate = BiofuelGeneratorConfig.extractionRate;
    }

    public int consumeFuel() {
        if (this.biofuel.getFluidAmount() > 0) {
            this.biofuel.drainForced(1, IFluidHandler.FluidAction.EXECUTE);
            return 4;
        }
        return 0;
    }

    public boolean canStart() {
        return this.biofuel.getFluidAmount() > 0;
    }

    public int getEnergyProducedEveryTick() {
        return this.getPowerPerTick;
    }

    public ProgressBarComponent getProgressBar() {
        return new ProgressBarComponent(30, 20, 0, BiofuelGeneratorConfig.maxProgress).setComponentHarness((IComponentHarness)this).setBarDirection(ProgressBarComponent.BarDirection.VERTICAL_UP).setColor(DyeColor.CYAN);
    }

    public int getEnergyCapacity() {
        return this.getMaxStoredPower;
    }

    public int getExtractingEnergy() {
        return this.getExtractionRate;
    }

    @Nonnull
    public BiofuelGeneratorTile getSelf() {
        return this;
    }
}

