/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.util.helpers;

import cofh.lib.fluid.FluidStorageCoFH;
import cofh.lib.util.helpers.BlockHelper;
import cofh.lib.util.helpers.ColorHelper;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.EffectUtils;
import net.minecraft.potion.PotionUtils;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Tuple;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.EmptyFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

public class FluidHelper {
    public static final Predicate<FluidStack> IS_WATER = e -> e.getFluid().equals(Fluids.field_204546_a);
    public static final Predicate<FluidStack> IS_LAVA = e -> e.getFluid().equals(Fluids.field_204547_b);
    public static HashMap<Fluid, Integer> colorCache = new HashMap();

    public static int getFluidColor(FluidStack stack) {
        int color = -1;
        if (stack != null && stack.getFluid() != null) {
            color = colorCache.getOrDefault(stack.getFluid(), stack.getFluid().getAttributes().getColor(stack) != -1 ? stack.getFluid().getAttributes().getColor(stack) : ColorHelper.getColorFrom(stack.getFluid().getAttributes().getStillTexture(stack)));
            if (!colorCache.containsKey(stack.getFluid())) {
                colorCache.put(stack.getFluid(), color);
            }
        }
        return color;
    }

    public static int getFluidColor(Fluid fluid) {
        int color = -1;
        if (fluid != null) {
            color = colorCache.getOrDefault(fluid, fluid.getAttributes().getColor() != -1 ? fluid.getAttributes().getColor() : ColorHelper.getColorFrom(fluid.getAttributes().getStillTexture()));
            if (!colorCache.containsKey(fluid)) {
                colorCache.put(fluid, color);
            }
        }
        return color;
    }

    public static int fluidHashcodeNoTag(FluidStack stack) {
        return stack.getFluid().hashCode();
    }

    public static int fluidHashcode(FluidStack stack) {
        return stack.getTag() != null ? stack.getFluid().hashCode() + 31 * stack.getTag().hashCode() : stack.getFluid().hashCode();
    }

    public static boolean fluidsEqual(FluidStack resourceA, FluidStack resourceB) {
        return resourceA != null && resourceA.isFluidEqual(resourceB) || resourceA == null && resourceB == null;
    }

    public static boolean fluidsEqual(Fluid fluidA, FluidStack resourceB) {
        return fluidA != null && resourceB != null && fluidA == resourceB.getFluid();
    }

    public static boolean fluidsEqual(FluidStack resourceA, Fluid fluidB) {
        return fluidB != null && resourceA != null && fluidB == resourceA.getFluid();
    }

    public static boolean fluidsEqual(Fluid fluidA, Fluid fluidB) {
        return fluidA != null && fluidA.equals(fluidB);
    }

    public static boolean extractFromAdjacent(TileEntity tile, FluidStorageCoFH tank, Direction side) {
        return tank.getFluidStack().isEmpty() ? FluidHelper.extractFromAdjacent(tile, tank, tank.getCapacity(), side) : FluidHelper.extractFromAdjacent(tile, tank, new FluidStack(tank.getFluidStack(), tank.getSpace()), side);
    }

    public static boolean extractFromAdjacent(TileEntity tile, FluidStorageCoFH tank, int amount, Direction side) {
        Direction opposite;
        TileEntity adjTile = BlockHelper.getAdjacentTileEntity(tile, side);
        IFluidHandler handler = FluidHelper.getFluidHandlerCap(adjTile, opposite = side.func_176734_d());
        if (handler == EmptyFluidHandler.INSTANCE) {
            return false;
        }
        FluidStack drainStack = handler.drain(amount, IFluidHandler.FluidAction.SIMULATE);
        int drainAmount = tank.fill(drainStack, IFluidHandler.FluidAction.EXECUTE);
        if (drainAmount > 0) {
            handler.drain(drainAmount, IFluidHandler.FluidAction.EXECUTE);
            return true;
        }
        return false;
    }

    public static boolean extractFromAdjacent(TileEntity tile, FluidStorageCoFH tank, FluidStack resource, Direction side) {
        Direction opposite;
        TileEntity adjTile = BlockHelper.getAdjacentTileEntity(tile, side);
        IFluidHandler handler = FluidHelper.getFluidHandlerCap(adjTile, opposite = side.func_176734_d());
        if (handler == EmptyFluidHandler.INSTANCE) {
            return false;
        }
        FluidStack drainStack = handler.drain(resource, IFluidHandler.FluidAction.SIMULATE);
        int drainAmount = tank.fill(drainStack, IFluidHandler.FluidAction.EXECUTE);
        if (drainAmount > 0) {
            handler.drain(new FluidStack(resource, drainAmount), IFluidHandler.FluidAction.EXECUTE);
            return true;
        }
        return false;
    }

    public static boolean insertIntoAdjacent(TileEntity tile, FluidStorageCoFH tank, Direction side) {
        return FluidHelper.insertIntoAdjacent(tile, tank, tank.getAmount(), side);
    }

    public static boolean insertIntoAdjacent(TileEntity tile, FluidStorageCoFH tank, int amount, Direction side) {
        Direction opposite;
        if (tank.isEmpty()) {
            return false;
        }
        TileEntity adjTile = BlockHelper.getAdjacentTileEntity(tile, side);
        IFluidHandler handler = FluidHelper.getFluidHandlerCap(adjTile, opposite = side.func_176734_d());
        if (handler == EmptyFluidHandler.INSTANCE) {
            return false;
        }
        int fillAmount = handler.fill(new FluidStack(tank.getFluidStack(), amount), IFluidHandler.FluidAction.EXECUTE);
        if (fillAmount > 0) {
            tank.drain(fillAmount, IFluidHandler.FluidAction.EXECUTE);
            return true;
        }
        return false;
    }

    public static boolean hasFluidHandlerCap(TileEntity tile, Direction face) {
        return tile != null && tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, face).isPresent();
    }

    public static IFluidHandler getFluidHandlerCap(TileEntity tile, Direction face) {
        return tile == null ? EmptyFluidHandler.INSTANCE : (IFluidHandler)tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, face).orElse((Object)EmptyFluidHandler.INSTANCE);
    }

    public static boolean drainItemToHandler(ItemStack stack, IFluidHandler handler, PlayerEntity player, Hand hand) {
        if (stack.func_190926_b() || handler == null || player == null) {
            return false;
        }
        InvWrapper playerInv = new InvWrapper((IInventory)player.field_71071_by);
        FluidActionResult result = FluidUtil.tryEmptyContainerAndStow((ItemStack)stack, (IFluidHandler)handler, (IItemHandler)playerInv, (int)Integer.MAX_VALUE, (PlayerEntity)player, (boolean)true);
        if (result.isSuccess()) {
            player.func_184611_a(hand, result.getResult());
            return true;
        }
        return false;
    }

    public static boolean fillItemFromHandler(ItemStack stack, IFluidHandler handler, PlayerEntity player, Hand hand) {
        if (stack.func_190926_b() || handler == null || player == null) {
            return false;
        }
        InvWrapper playerInv = new InvWrapper((IInventory)player.field_71071_by);
        FluidActionResult result = FluidUtil.tryFillContainerAndStow((ItemStack)stack, (IFluidHandler)handler, (IItemHandler)playerInv, (int)Integer.MAX_VALUE, (PlayerEntity)player, (boolean)true);
        if (result.isSuccess()) {
            player.func_184611_a(hand, result.getResult());
            return true;
        }
        return false;
    }

    public static boolean interactWithHandler(ItemStack stack, IFluidHandler handler, PlayerEntity player, Hand hand) {
        return FluidHelper.fillItemFromHandler(stack, handler, player, hand) || FluidHelper.drainItemToHandler(stack, handler, player, hand);
    }

    public static boolean hasPotionTag(FluidStack stack) {
        return !stack.isEmpty() && stack.getTag() != null && stack.getTag().func_74764_b("Potion");
    }

    public static void addPotionTooltipStrings(FluidStack stack, List<String> list) {
        ArrayList<ITextComponent> lores = new ArrayList<ITextComponent>();
        FluidHelper.addPotionTooltip(stack, lores, 1.0f);
        for (ITextComponent text : lores) {
            list.add(text.func_150254_d());
        }
    }

    public static void addPotionTooltip(FluidStack stack, List<ITextComponent> list) {
        FluidHelper.addPotionTooltip(stack, list, 1.0f);
    }

    public static void addPotionTooltip(FluidStack stack, List<ITextComponent> lores, float durationFactor) {
        if (stack.isEmpty()) {
            return;
        }
        List list = PotionUtils.func_185185_a((CompoundNBT)stack.getTag());
        ArrayList list1 = Lists.newArrayList();
        if (list.isEmpty()) {
            lores.add(new TranslationTextComponent("effect.none", new Object[0]).func_211708_a(TextFormatting.GRAY));
        } else {
            for (EffectInstance effectinstance : list) {
                TranslationTextComponent itextcomponent = new TranslationTextComponent(effectinstance.func_76453_d(), new Object[0]);
                Effect effect = effectinstance.func_188419_a();
                Map map = effect.func_111186_k();
                if (!map.isEmpty()) {
                    for (Map.Entry entry : map.entrySet()) {
                        AttributeModifier attributemodifier = (AttributeModifier)entry.getValue();
                        AttributeModifier attributemodifier1 = new AttributeModifier(attributemodifier.func_111166_b(), effect.func_111183_a(effectinstance.func_76458_c(), attributemodifier), attributemodifier.func_220375_c());
                        list1.add(new Tuple((Object)((IAttribute)entry.getKey()).func_111108_a(), (Object)attributemodifier1));
                    }
                }
                if (effectinstance.func_76458_c() > 0) {
                    itextcomponent.func_150258_a(" ").func_150257_a((ITextComponent)new TranslationTextComponent("potion.potency." + effectinstance.func_76458_c(), new Object[0]));
                }
                if (effectinstance.func_76459_b() > 20) {
                    itextcomponent.func_150258_a(" (").func_150258_a(EffectUtils.func_188410_a((EffectInstance)effectinstance, (float)durationFactor)).func_150258_a(")");
                }
                lores.add(itextcomponent.func_211708_a(effect.func_220303_e().func_220306_a()));
            }
        }
        if (!list1.isEmpty()) {
            lores.add((ITextComponent)new StringTextComponent(""));
            lores.add(new TranslationTextComponent("potion.whenDrank", new Object[0]).func_211708_a(TextFormatting.DARK_PURPLE));
            for (Tuple tuple : list1) {
                AttributeModifier attributemodifier2 = (AttributeModifier)tuple.func_76340_b();
                double d0 = attributemodifier2.func_111164_d();
                double d1 = attributemodifier2.func_220375_c() != AttributeModifier.Operation.MULTIPLY_BASE && attributemodifier2.func_220375_c() != AttributeModifier.Operation.MULTIPLY_TOTAL ? attributemodifier2.func_111164_d() : attributemodifier2.func_111164_d() * 100.0;
                if (d0 > 0.0) {
                    lores.add(new TranslationTextComponent("attribute.modifier.plus." + attributemodifier2.func_220375_c().func_220371_a(), new Object[]{ItemStack.field_111284_a.format(d1), new TranslationTextComponent("attribute.name." + (String)tuple.func_76341_a(), new Object[0])}).func_211708_a(TextFormatting.BLUE));
                    continue;
                }
                if (!(d0 < 0.0)) continue;
                lores.add(new TranslationTextComponent("attribute.modifier.take." + attributemodifier2.func_220375_c().func_220371_a(), new Object[]{ItemStack.field_111284_a.format(d1 *= -1.0), new TranslationTextComponent("attribute.name." + (String)tuple.func_76341_a(), new Object[0])}).func_211708_a(TextFormatting.RED));
            }
        }
    }

    public static int luminosity(FluidStack stack) {
        return !stack.isEmpty() && stack.getFluid() != null ? stack.getFluid().getAttributes().getLuminosity(stack) : 0;
    }

    public static int density(FluidStack stack) {
        return !stack.isEmpty() && stack.getFluid() != null ? stack.getFluid().getAttributes().getDensity(stack) : 0;
    }

    public static boolean gaseous(FluidStack stack) {
        return !stack.isEmpty() && stack.getFluid() != null && stack.getFluid().getAttributes().isGaseous();
    }

    public static int temperature(FluidStack stack) {
        return !stack.isEmpty() && stack.getFluid() != null ? stack.getFluid().getAttributes().getTemperature(stack) : 0;
    }

    public static int viscosity(FluidStack stack) {
        return !stack.isEmpty() && stack.getFluid() != null ? stack.getFluid().getAttributes().getViscosity(stack) : 0;
    }
}

