/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.util;

import cofh.lib.util.helpers.MathHelper;
import cofh.lib.util.references.CoreReferences;
import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.BambooBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FireBlock;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.block.IGrowable;
import net.minecraft.block.SnowBlock;
import net.minecraft.block.TNTBlock;
import net.minecraft.block.material.Material;
import net.minecraft.dispenser.IPosition;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.monster.EndermanEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class Utils {
    private static int HORZ_MAX = 16;
    private static int VERT_MAX = 4;

    private Utils() {
    }

    public static boolean isClientWorld(World world) {
        return world.field_72995_K;
    }

    public static boolean isServerWorld(World world) {
        return !world.field_72995_K;
    }

    public static boolean isFakePlayer(Entity entity) {
        return entity instanceof FakePlayer;
    }

    public static String createPrettyJSON(String jsonString) {
        JsonParser parser = new JsonParser();
        JsonObject json = parser.parse(jsonString).getAsJsonObject();
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        return gson.toJson((JsonElement)json);
    }

    public static void loadConfig(ForgeConfigSpec spec, Path path) {
        CommentedFileConfig configData = (CommentedFileConfig)CommentedFileConfig.builder((Path)path).sync().autosave().writingMode(WritingMode.REPLACE).build();
        configData.load();
        spec.setConfig((CommentedConfig)configData);
    }

    public static void spawnBlockParticlesClient(World world, IParticleData particle, BlockPos pos, Random rand, int count) {
        for (int i = 0; i < count; ++i) {
            double d0 = (double)pos.func_177958_n() + rand.nextDouble();
            double d1 = (double)pos.func_177956_o() + rand.nextDouble();
            double d2 = (double)pos.func_177952_p() + rand.nextDouble();
            double d3 = (rand.nextDouble() - 0.5) * 0.5;
            double d4 = (rand.nextDouble() - 0.5) * 0.5;
            double d5 = (rand.nextDouble() - 0.5) * 0.5;
            world.func_195594_a(particle, d0, d1, d2, d3, d4, d5);
        }
    }

    public static void spawnParticles(World world, IParticleData particle, double posX, double posY, double posZ, int particleCount, double xOffset, double yOffset, double zOffset, double speed) {
        if (Utils.isServerWorld(world)) {
            ((ServerWorld)world).func_195598_a(particle, posX, posY + 1.0, posZ, particleCount, xOffset, yOffset, zOffset, speed);
        } else {
            world.func_195594_a(particle, posX + xOffset, posY + yOffset, posZ + zOffset, 0.0, 0.0, 0.0);
        }
    }

    public static boolean addToPlayerInventory(PlayerEntity player, ItemStack stack) {
        int index;
        if (stack.func_190926_b() || player == null) {
            return false;
        }
        if (stack.func_77973_b() instanceof ArmorItem && ((ItemStack)player.field_71071_by.field_70460_b.get(index = ((ArmorItem)stack.func_77973_b()).func_185083_B_().func_188454_b())).func_190926_b()) {
            player.field_71071_by.field_70460_b.set(index, (Object)stack);
            return true;
        }
        PlayerInventory inv = player.field_71071_by;
        for (int i = 0; i < inv.field_70462_a.size(); ++i) {
            if (!((ItemStack)inv.field_70462_a.get(i)).func_190926_b()) continue;
            inv.field_70462_a.set(i, (Object)stack.func_77946_l());
            return true;
        }
        return false;
    }

    public static boolean dropItemStackIntoWorld(ItemStack stack, World world, Vec3d pos) {
        return Utils.dropItemStackIntoWorld(stack, world, pos, false);
    }

    public static boolean dropItemStackIntoWorldWithRandomness(ItemStack stack, World world, BlockPos pos) {
        return Utils.dropItemStackIntoWorld(stack, world, new Vec3d((Vec3i)pos), true);
    }

    public static boolean dropItemStackIntoWorldWithRandomness(ItemStack stack, World world, Vec3d pos) {
        return Utils.dropItemStackIntoWorld(stack, world, pos, true);
    }

    public static boolean dropItemStackIntoWorld(ItemStack stack, World world, Vec3d pos, boolean velocity) {
        if (stack.func_190926_b()) {
            return false;
        }
        float x2 = 0.5f;
        float y2 = 0.0f;
        float z2 = 0.5f;
        if (velocity) {
            x2 = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
            y2 = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
            z2 = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
        }
        ItemEntity entity = new ItemEntity(world, pos.field_72450_a + (double)x2, pos.field_72448_b + (double)y2, pos.field_72449_c + (double)z2, stack.func_77946_l());
        if (velocity) {
            entity.func_213293_j(world.field_73012_v.nextGaussian() * (double)0.05f, world.field_73012_v.nextGaussian() * (double)0.05f + (double)0.2f, world.field_73012_v.nextGaussian() * (double)0.05f);
        } else {
            entity.func_213293_j(-0.05, 0.0, 0.0);
        }
        world.func_217376_c((Entity)entity);
        return true;
    }

    public static boolean dropDismantleStackIntoWorld(ItemStack stack, World world, BlockPos pos) {
        if (stack.func_190926_b()) {
            return false;
        }
        float f = 0.3f;
        double x2 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
        double y2 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
        double z2 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
        ItemEntity dropEntity = new ItemEntity(world, (double)pos.func_177958_n() + x2, (double)pos.func_177956_o() + y2, (double)pos.func_177952_p() + z2, stack);
        dropEntity.func_174867_a(10);
        world.func_217376_c((Entity)dropEntity);
        return true;
    }

    public static boolean teleportEntityTo(Entity entity, BlockPos pos) {
        return Utils.teleportEntityTo(entity, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
    }

    public static boolean teleportEntityTo(Entity entity, double x, double y, double z) {
        if (entity instanceof LivingEntity) {
            return Utils.teleportEntityTo((LivingEntity)entity, x, y, z);
        }
        entity.func_70012_b(x, y, z, entity.field_70177_z, entity.field_70125_A);
        entity.func_184185_a(SoundEvents.field_187534_aX, 1.0f, 1.0f);
        return true;
    }

    public static boolean teleportEntityTo(LivingEntity entity, double x, double y, double z) {
        EnderTeleportEvent event = new EnderTeleportEvent(entity, x, y, z, 0.0f);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return false;
        }
        if (entity instanceof ServerPlayerEntity && !Utils.isFakePlayer((Entity)entity)) {
            ServerPlayerEntity player = (ServerPlayerEntity)entity;
            if (player.field_71135_a.func_147298_b().func_150724_d() && !player.func_70608_bn()) {
                if (entity.func_184218_aH()) {
                    entity.func_184210_p();
                }
                entity.func_70634_a(event.getTargetX(), event.getTargetY(), event.getTargetZ());
                entity.field_70143_R = 0.0f;
            }
        } else {
            if (entity.func_184218_aH()) {
                entity.func_184210_p();
            }
            entity.func_70634_a(event.getTargetX(), event.getTargetY(), event.getTargetZ());
            entity.field_70143_R = 0.0f;
        }
        entity.func_184185_a(SoundEvents.field_187534_aX, 1.0f, 1.0f);
        return true;
    }

    public static int getEnchantedCapacity(int amount, int holding) {
        return amount + amount * holding / 2;
    }

    public static int getHeldEnchantmentLevel(LivingEntity living, Enchantment ench) {
        return Math.max(EnchantmentHelper.func_77506_a((Enchantment)ench, (ItemStack)living.func_184614_ca()), EnchantmentHelper.func_77506_a((Enchantment)ench, (ItemStack)living.func_184592_cb()));
    }

    public static void addEnchantment(ItemStack stack, Enchantment ench, int level) {
        stack.func_77966_a(ench, level);
    }

    public static void removeEnchantment(ItemStack stack, Enchantment ench) {
        if (stack.func_77978_p() == null || !stack.func_77978_p().func_150297_b("Enchantments", 9)) {
            return;
        }
        ListNBT list = stack.func_77978_p().func_150295_c("Enchantments", 10);
        String encId = String.valueOf(ForgeRegistries.ENCHANTMENTS.getKey((IForgeRegistryEntry)ench));
        for (int i = 0; i < list.size(); ++i) {
            CompoundNBT tag = list.func_150305_b(i);
            String id = tag.func_74779_i("id");
            if (!encId.equals(id)) continue;
            list.remove(i);
            break;
        }
        if (list.isEmpty()) {
            stack.func_196083_e("Enchantments");
        }
    }

    public static void igniteNearbyEntities(Entity entity, World worldIn, BlockPos pos, int radius, int duration) {
        AxisAlignedBB area = new AxisAlignedBB(pos.func_177982_a(-radius, -radius, -radius), pos.func_177982_a(1 + radius, 1 + radius, 1 + radius));
        List mobs = worldIn.func_175647_a(LivingEntity.class, area, EntityPredicates.field_94557_a);
        mobs.removeIf(Entity::func_70090_H);
        mobs.removeIf(Entity::func_70045_F);
        mobs.removeIf(mob -> mob instanceof EndermanEntity);
        for (LivingEntity mob2 : mobs) {
            mob2.func_70015_d(duration);
        }
    }

    public static void igniteNearbyGround(Entity entity, World worldIn, BlockPos pos, int radius, double chance) {
        float f = Math.min(HORZ_MAX, radius);
        float v = Math.min(VERT_MAX, radius);
        float f2 = f * f;
        BlockPos.Mutable mutable = new BlockPos.Mutable();
        for (BlockPos blockpos : BlockPos.func_218278_a((BlockPos)pos.func_177963_a((double)(-f), (double)(-v), (double)(-f)), (BlockPos)pos.func_177963_a((double)f, (double)v, (double)f))) {
            double distance = blockpos.func_218138_a((IPosition)entity.func_213303_ch(), true);
            if (!(distance < (double)f2)) continue;
            mutable.func_181079_c(blockpos.func_177958_n(), blockpos.func_177956_o() + 1, blockpos.func_177952_p());
            BlockState blockstate1 = worldIn.func_180495_p((BlockPos)mutable);
            if (!blockstate1.isAir((IBlockReader)worldIn, (BlockPos)mutable) || !Utils.isValidFirePosition(worldIn, (BlockPos)mutable, chance)) continue;
            worldIn.func_175656_a((BlockPos)mutable, ((FireBlock)Blocks.field_150480_ab).func_196448_a((IBlockReader)worldIn, (BlockPos)mutable));
        }
    }

    public static void igniteSpecial(Entity entity, World worldIn, BlockPos pos, int radius, boolean campfire, boolean tnt) {
        float f = Math.min(HORZ_MAX, radius);
        float v = Math.min(VERT_MAX, radius);
        float f2 = f * f;
        for (BlockPos blockpos : BlockPos.func_218278_a((BlockPos)pos.func_177963_a((double)(-f), (double)(-v), (double)(-f)), (BlockPos)pos.func_177963_a((double)f, (double)v, (double)f))) {
            double distance = blockpos.func_218138_a((IPosition)entity.func_213303_ch(), true);
            if (!(distance < (double)f2)) continue;
            BlockState state = worldIn.func_180495_p(blockpos);
            if (campfire && Utils.isUnlitCampfire(state)) {
                worldIn.func_175656_a(blockpos, (BlockState)state.func_206870_a((IProperty)BlockStateProperties.field_208190_q, (Comparable)Boolean.valueOf(true)));
            }
            if (!tnt || !Utils.isUnlitTNT(state)) continue;
            TNTBlock.func_196534_a((World)worldIn, (BlockPos)blockpos);
            worldIn.func_175656_a(blockpos, Blocks.field_150350_a.func_176223_P());
        }
    }

    private static boolean isValidFirePosition(World worldIn, BlockPos pos, double chance) {
        BlockState state = worldIn.func_180495_p(pos.func_177977_b());
        if (Block.func_208061_a((VoxelShape)state.func_196952_d((IBlockReader)worldIn, pos.func_177977_b()), (Direction)Direction.UP)) {
            return state.func_185904_a().func_76217_h() || worldIn.field_73012_v.nextDouble() < chance;
        }
        return false;
    }

    private static boolean isUnlitCampfire(BlockState state) {
        return state.func_177230_c() == Blocks.field_222433_lV && (Boolean)state.func_177229_b((IProperty)BlockStateProperties.field_208198_y) == false && (Boolean)state.func_177229_b((IProperty)BlockStateProperties.field_208190_q) == false;
    }

    private static boolean isUnlitTNT(BlockState state) {
        return state.func_177230_c() == Blocks.field_150335_W;
    }

    public static void freezeNearbyGround(Entity entity, World worldIn, BlockPos pos, int radius) {
        BlockState state = Blocks.field_150433_aE.func_176223_P();
        float f = Math.min(HORZ_MAX, radius);
        float v = Math.min(VERT_MAX, radius);
        float f2 = f * f;
        BlockPos.Mutable mutable = new BlockPos.Mutable();
        for (BlockPos blockpos : BlockPos.func_218278_a((BlockPos)pos.func_177963_a((double)(-f), (double)(-v), (double)(-f)), (BlockPos)pos.func_177963_a((double)f, (double)v, (double)f))) {
            double distance = blockpos.func_218138_a((IPosition)entity.func_213303_ch(), true);
            if (!(distance < (double)f2)) continue;
            mutable.func_181079_c(blockpos.func_177958_n(), blockpos.func_177956_o() + 1, blockpos.func_177952_p());
            BlockState blockstate1 = worldIn.func_180495_p((BlockPos)mutable);
            if (!blockstate1.isAir((IBlockReader)worldIn, (BlockPos)mutable) || !(worldIn.func_226691_t_((BlockPos)mutable).func_225486_c(blockpos) < 0.8f) || !Utils.isValidSnowPosition(worldIn, (BlockPos)mutable)) continue;
            worldIn.func_175656_a((BlockPos)mutable, state);
        }
    }

    public static void freezeNearbyWater(Entity entity, World worldIn, BlockPos pos, int radius, boolean permanent) {
        BlockState state = permanent ? Blocks.field_150432_aD.func_176223_P() : Blocks.field_185778_de.func_176223_P();
        float f = Math.min(HORZ_MAX, radius);
        float v = Math.min(VERT_MAX, radius);
        float f2 = f * f;
        BlockPos.Mutable mutable = new BlockPos.Mutable();
        for (BlockPos blockpos : BlockPos.func_218278_a((BlockPos)pos.func_177963_a((double)(-f), (double)(-v), (double)(-f)), (BlockPos)pos.func_177963_a((double)f, (double)v, (double)f))) {
            boolean isFull;
            double distance = blockpos.func_218138_a((IPosition)entity.func_213303_ch(), true);
            if (!(distance < (double)f2)) continue;
            mutable.func_181079_c(blockpos.func_177958_n(), blockpos.func_177956_o() + 1, blockpos.func_177952_p());
            BlockState blockstate1 = worldIn.func_180495_p((BlockPos)mutable);
            if (!blockstate1.isAir((IBlockReader)worldIn, (BlockPos)mutable)) continue;
            BlockState blockstate2 = worldIn.func_180495_p(blockpos);
            boolean bl = isFull = blockstate2.func_177230_c() == Blocks.field_150355_j && (Integer)blockstate2.func_177229_b((IProperty)FlowingFluidBlock.field_176367_b) == 0;
            if (blockstate2.func_185904_a() != Material.field_151586_h || !isFull || !state.func_196955_c((IWorldReader)worldIn, blockpos) || !worldIn.func_226663_a_(state, blockpos, ISelectionContext.func_216377_a())) continue;
            worldIn.func_175656_a(blockpos, state);
            worldIn.func_205220_G_().func_205360_a(blockpos, (Object)Blocks.field_185778_de, MathHelper.nextInt(worldIn.field_73012_v, 60, 120));
        }
    }

    public static void freezeNearbyLava(Entity entity, World worldIn, BlockPos pos, int radius, boolean permanent) {
        if (CoreReferences.GLOSSED_MAGMA == null && !permanent) {
            return;
        }
        BlockState state = permanent ? Blocks.field_150343_Z.func_176223_P() : CoreReferences.GLOSSED_MAGMA.func_176223_P();
        float f = Math.min(HORZ_MAX, radius);
        float v = Math.min(VERT_MAX, radius);
        float f2 = f * f;
        BlockPos.Mutable mutable = new BlockPos.Mutable();
        for (BlockPos blockpos : BlockPos.func_218278_a((BlockPos)pos.func_177963_a((double)(-f), (double)(-v), (double)(-f)), (BlockPos)pos.func_177963_a((double)f, (double)v, (double)f))) {
            boolean isFull;
            double distance = blockpos.func_218138_a((IPosition)entity.func_213303_ch(), true);
            if (!(distance < (double)f2)) continue;
            mutable.func_181079_c(blockpos.func_177958_n(), blockpos.func_177956_o() + 1, blockpos.func_177952_p());
            BlockState blockstate1 = worldIn.func_180495_p((BlockPos)mutable);
            if (!blockstate1.isAir((IBlockReader)worldIn, (BlockPos)mutable)) continue;
            BlockState blockstate2 = worldIn.func_180495_p(blockpos);
            boolean bl = isFull = blockstate2.func_177230_c() == Blocks.field_150353_l && (Integer)blockstate2.func_177229_b((IProperty)FlowingFluidBlock.field_176367_b) == 0;
            if (blockstate2.func_185904_a() != Material.field_151587_i || !isFull || !state.func_196955_c((IWorldReader)worldIn, blockpos) || !worldIn.func_226663_a_(state, blockpos, ISelectionContext.func_216377_a())) continue;
            worldIn.func_175656_a(blockpos, state);
            worldIn.func_205220_G_().func_205360_a(blockpos, (Object)CoreReferences.GLOSSED_MAGMA, MathHelper.nextInt(worldIn.field_73012_v, 60, 120));
        }
    }

    public static boolean isValidSnowPosition(World worldIn, BlockPos pos) {
        BlockState state = worldIn.func_180495_p(pos.func_177977_b());
        Block block = state.func_177230_c();
        if (block == Blocks.field_150432_aD || block == Blocks.field_150403_cj || block == Blocks.field_180401_cv || block == Blocks.field_185778_de || block == CoreReferences.GLOSSED_MAGMA) {
            return false;
        }
        return Block.func_208061_a((VoxelShape)state.func_196952_d((IBlockReader)worldIn, pos.func_177977_b()), (Direction)Direction.UP) || block == Blocks.field_150433_aE && (Integer)state.func_177229_b((IProperty)SnowBlock.field_176315_a) == 8;
    }

    public static void transformArea(Entity entity, World worldIn, BlockPos pos, BlockState replaceable, BlockState replacement, int radius, boolean requireAir) {
        float f = Math.min(HORZ_MAX, radius);
        float v = Math.min(VERT_MAX, radius);
        float f2 = f * f;
        BlockPos.Mutable mutable = new BlockPos.Mutable();
        if (requireAir) {
            for (BlockPos iterPos : BlockPos.func_218278_a((BlockPos)pos.func_177963_a((double)(-f), (double)(-v), (double)(-f)), (BlockPos)pos.func_177963_a((double)f, (double)v, (double)f))) {
                double distance = iterPos.func_218138_a((IPosition)entity.func_213303_ch(), true);
                if (!(distance < (double)f2)) continue;
                mutable.func_181079_c(iterPos.func_177958_n(), iterPos.func_177956_o() + 1, iterPos.func_177952_p());
                BlockState blockstate1 = worldIn.func_180495_p((BlockPos)mutable);
                if (!blockstate1.isAir((IBlockReader)worldIn, (BlockPos)mutable) || worldIn.func_180495_p(iterPos) != replaceable) continue;
                worldIn.func_175656_a(iterPos, replacement);
            }
        } else {
            for (BlockPos iterPos : BlockPos.func_218278_a((BlockPos)pos.func_177963_a((double)(-f), (double)(-v), (double)(-f)), (BlockPos)pos.func_177963_a((double)f, (double)v, (double)f))) {
                double distance = iterPos.func_218138_a((IPosition)entity.func_213303_ch(), true);
                if (!(distance < (double)f2) || worldIn.func_180495_p(iterPos) != replaceable) continue;
                worldIn.func_175656_a(iterPos, replacement);
            }
        }
    }

    public static void transformArea(Entity entity, World worldIn, BlockPos pos, Set<BlockState> replaceable, BlockState replacement, int radius, boolean requireAir) {
        float f = Math.min(HORZ_MAX, radius);
        float v = Math.min(VERT_MAX, radius);
        float f2 = f * f;
        BlockPos.Mutable mutable = new BlockPos.Mutable();
        if (requireAir) {
            for (BlockPos blockpos : BlockPos.func_218278_a((BlockPos)pos.func_177963_a((double)(-f), (double)(-v), (double)(-f)), (BlockPos)pos.func_177963_a((double)f, (double)v, (double)f))) {
                double distance = blockpos.func_218138_a((IPosition)entity.func_213303_ch(), true);
                if (!(distance < (double)f2)) continue;
                mutable.func_181079_c(blockpos.func_177958_n(), blockpos.func_177956_o() + 1, blockpos.func_177952_p());
                BlockState blockstate1 = worldIn.func_180495_p((BlockPos)mutable);
                if (!blockstate1.isAir((IBlockReader)worldIn, (BlockPos)mutable) || !replaceable.contains(worldIn.func_180495_p(blockpos))) continue;
                worldIn.func_175656_a(blockpos, replacement);
            }
        } else {
            for (BlockPos iterPos : BlockPos.func_218278_a((BlockPos)pos.func_177963_a((double)(-f), (double)(-v), (double)(-f)), (BlockPos)pos.func_177963_a((double)f, (double)v, (double)f))) {
                if (!iterPos.func_218137_a((IPosition)entity.func_213303_ch(), (double)f) || !replaceable.contains(worldIn.func_180495_p(iterPos))) continue;
                worldIn.func_175656_a(iterPos, replacement);
            }
        }
    }

    public static void transformGrass(Entity entity, World worldIn, BlockPos pos, int radius) {
        Utils.transformArea(entity, worldIn, pos, Blocks.field_150346_d.func_176223_P(), Blocks.field_196658_i.func_176223_P(), radius, true);
    }

    public static void transformMycelium(Entity entity, World worldIn, BlockPos pos, int radius) {
        HashSet<BlockState> replaceable = new HashSet<BlockState>();
        Collections.addAll(replaceable, Blocks.field_150346_d.func_176223_P(), Blocks.field_196658_i.func_176223_P());
        Utils.transformArea(entity, worldIn, pos, replaceable, Blocks.field_150391_bh.func_176223_P(), radius, true);
    }

    public static void transformSignalAir(Entity entity, World worldIn, BlockPos pos, int radius) {
        HashSet<BlockState> replaceable = new HashSet<BlockState>();
        Collections.addAll(replaceable, Blocks.field_150350_a.func_176223_P(), Blocks.field_201941_jj.func_176223_P());
        Utils.transformArea(entity, worldIn, pos, replaceable, CoreReferences.SIGNAL_AIR.func_176223_P(), radius, false);
    }

    public static void transformGlowAir(Entity entity, World worldIn, BlockPos pos, int radius) {
        HashSet<BlockState> replaceable = new HashSet<BlockState>();
        Collections.addAll(replaceable, Blocks.field_150350_a.func_176223_P(), Blocks.field_201941_jj.func_176223_P());
        Utils.transformArea(entity, worldIn, pos, replaceable, CoreReferences.GLOW_AIR.func_176223_P(), radius, false);
    }

    public static void transformEnderAir(Entity entity, World worldIn, BlockPos pos, int radius) {
        HashSet<BlockState> replaceable = new HashSet<BlockState>();
        Collections.addAll(replaceable, Blocks.field_150350_a.func_176223_P(), Blocks.field_201941_jj.func_176223_P());
        Utils.transformArea(entity, worldIn, pos, replaceable, CoreReferences.ENDER_AIR.func_176223_P(), radius, false);
    }

    public static void growMushrooms(Entity entity, World worldIn, BlockPos pos, int radius, int count) {
        float f = Math.min(HORZ_MAX, radius);
        float v = Math.min(VERT_MAX, radius);
        float f2 = f * f;
        int grow = 0;
        BlockPos.Mutable mutable = new BlockPos.Mutable();
        mutable.func_189533_g((Vec3i)entity.func_180425_c().func_177984_a());
        BlockState blockstate1 = worldIn.func_180495_p((BlockPos)mutable);
        if (blockstate1.isAir((IBlockReader)worldIn, (BlockPos)mutable) && Utils.isValidMushroomPosition(worldIn, entity.func_180425_c(), 1.0)) {
            worldIn.func_175656_a((BlockPos)mutable, worldIn.field_73012_v.nextBoolean() ? Blocks.field_150338_P.func_176223_P() : Blocks.field_150337_Q.func_176223_P());
            ++grow;
        }
        for (BlockPos iterPos : BlockPos.func_218278_a((BlockPos)pos.func_177963_a((double)(-f), (double)(-v), (double)(-f)), (BlockPos)pos.func_177963_a((double)f, (double)v, (double)f))) {
            if (grow >= count) {
                return;
            }
            double distance = iterPos.func_218138_a((IPosition)entity.func_213303_ch(), true);
            if (!(distance < (double)f2)) continue;
            mutable.func_181079_c(iterPos.func_177958_n(), iterPos.func_177956_o() + 1, iterPos.func_177952_p());
            blockstate1 = worldIn.func_180495_p((BlockPos)mutable);
            if (!blockstate1.isAir((IBlockReader)worldIn, (BlockPos)mutable) || !Utils.isValidMushroomPosition(worldIn, iterPos, 0.5 - distance / (double)f2)) continue;
            worldIn.func_175656_a((BlockPos)mutable, worldIn.field_73012_v.nextBoolean() ? Blocks.field_150338_P.func_176223_P() : Blocks.field_150337_Q.func_176223_P());
            ++grow;
        }
    }

    private static boolean isValidMushroomPosition(World worldIn, BlockPos pos, double chance) {
        Block block = worldIn.func_180495_p(pos).func_177230_c();
        return worldIn.field_73012_v.nextDouble() < chance && (block == Blocks.field_150391_bh || block == Blocks.field_196661_l);
    }

    public static void growPlants(Entity entity, World worldIn, BlockPos pos, int radius, int count) {
        BlockState state;
        int grow;
        float f2;
        float v;
        float f;
        block7: {
            IGrowable growable;
            f = Math.min(HORZ_MAX, radius);
            v = Math.min(VERT_MAX, radius);
            f2 = f * f;
            grow = 0;
            state = worldIn.func_180495_p(entity.func_180425_c());
            if (state.func_177230_c() instanceof IGrowable && (growable = (IGrowable)state.func_177230_c()).func_176473_a((IBlockReader)worldIn, pos, state, worldIn.field_72995_K) && !worldIn.field_72995_K && growable.func_180670_a(worldIn, worldIn.field_73012_v, pos, state)) {
                try {
                    growable.func_225535_a_((ServerWorld)worldIn, worldIn.field_73012_v, pos, state);
                    ++grow;
                }
                catch (Exception e) {
                    if (growable instanceof BambooBlock) break block7;
                    throw e;
                }
            }
        }
        for (BlockPos iterPos : BlockPos.func_218278_a((BlockPos)pos.func_177963_a((double)(-f), (double)(-v), (double)(-f)), (BlockPos)pos.func_177963_a((double)f, (double)v, (double)f))) {
            IGrowable growable;
            if (grow >= count) {
                return;
            }
            double distance = iterPos.func_218138_a((IPosition)entity.func_213303_ch(), true);
            if (!(distance < (double)f2) || !((state = worldIn.func_180495_p(iterPos)).func_177230_c() instanceof IGrowable) || !(growable = (IGrowable)state.func_177230_c()).func_176473_a((IBlockReader)worldIn, iterPos, state, worldIn.field_72995_K) || worldIn.field_72995_K || !growable.func_180670_a(worldIn, worldIn.field_73012_v, iterPos, state) || !(worldIn.field_73012_v.nextDouble() < 0.5 - distance / (double)f2)) continue;
            try {
                growable.func_225535_a_((ServerWorld)worldIn, worldIn.field_73012_v, iterPos, state);
                ++grow;
            }
            catch (Exception e) {
                if (growable instanceof BambooBlock) continue;
                throw e;
            }
        }
    }
}

