/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.inventory;

import cofh.lib.inventory.ItemStorageCoFH;
import cofh.lib.tileentity.ITileCallback;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;

public class SimpleItemHandler
implements IItemHandler {
    @Nullable
    protected ITileCallback tile;
    protected List<ItemStorageCoFH> slots;

    public SimpleItemHandler() {
        this(null);
    }

    public SimpleItemHandler(@Nullable ITileCallback tile) {
        this.tile = tile;
        this.slots = new ArrayList<ItemStorageCoFH>();
    }

    public SimpleItemHandler(@Nullable ITileCallback tile, @Nonnull List<ItemStorageCoFH> slots) {
        this.tile = tile;
        this.slots = slots;
    }

    public boolean hasSlots() {
        return this.slots.size() > 0;
    }

    public boolean isEmpty() {
        for (ItemStorageCoFH slot : this.slots) {
            if (slot.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public int getSlots() {
        return this.slots.size();
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        if (slot < 0 || slot > this.getSlots()) {
            return ItemStack.field_190927_a;
        }
        return this.slots.get(slot).getItemStack();
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        if (slot < 0 || slot > this.getSlots()) {
            return stack;
        }
        ItemStack ret = this.slots.get(slot).insertItem(slot, stack, simulate);
        if (this.tile != null && !simulate) {
            this.tile.onInventoryChange(slot);
        }
        return ret;
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (slot < 0 || slot > this.getSlots()) {
            return ItemStack.field_190927_a;
        }
        ItemStack ret = this.slots.get(slot).extractItem(slot, amount, simulate);
        if (this.tile != null && !simulate) {
            this.tile.onInventoryChange(slot);
        }
        return ret;
    }

    public int getSlotLimit(int slot) {
        if (slot < 0 || slot > this.getSlots()) {
            return 0;
        }
        return this.slots.get(slot).getSlotLimit(slot);
    }

    public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
        if (slot < 0 || slot > this.getSlots()) {
            return false;
        }
        return this.slots.get(slot).isItemValid(stack);
    }
}

