/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.capability.templates;

import cofh.lib.capability.CapabilityAOE;
import cofh.lib.capability.IAOEItem;
import cofh.lib.util.helpers.AOEHelper;
import cofh.lib.util.references.EnsorcellationReferences;
import com.google.common.collect.ImmutableList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;

public class AOEMiningItem
implements IAOEItem,
ICapabilityProvider {
    private final LazyOptional<IAOEItem> holder = LazyOptional.of(() -> this);
    private final int radius;
    private final int depth;
    private final Type type;

    public AOEMiningItem(int radius, int depth, Type type) {
        this.radius = radius;
        this.depth = depth;
        this.type = type;
    }

    public AOEMiningItem(int radius, Type type) {
        this(radius, 1, type);
    }

    @Override
    public ImmutableList<BlockPos> getAOEBlocks(ItemStack stack, BlockPos pos, PlayerEntity player) {
        if (this.type == Type.SICKLE) {
            return AOEHelper.getAOEBlocksSickle(stack, pos, player, this.radius, this.depth);
        }
        return AOEHelper.getAOEBlocksMiningRadius(stack, pos, player, this.radius + EnchantmentHelper.func_77506_a((Enchantment)EnsorcellationReferences.EXCAVATING, (ItemStack)stack));
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        return CapabilityAOE.AOE_ITEM_CAPABILITY.orEmpty(cap, this.holder);
    }

    public static enum Type {
        EXCAVATOR,
        HAMMER,
        SICKLE;

    }
}

